// WalkthroughView.cpp : implementation of the CWalkthroughView class
//

#include "stdafx.h"

#include "WalkthroughView.h"

#include "WalkthroughApp.h"
#include "WalkthroughDoc.h"
#include "Sensitivity.h"

#define ValZWMin 1

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughView

IMPLEMENT_DYNCREATE(CWalkthroughView, CView)

BEGIN_MESSAGE_MAP(CWalkthroughView, OCC_3dView)
	//{{AFX_MSG_MAP(CWalkthroughView)
	ON_COMMAND(ID_BUTTONPan, OnBUTTONPan)
	ON_COMMAND(ID_BUTTONPanGlo, OnBUTTONPanGlo)
	ON_COMMAND(ID_BUTTONReset, OnBUTTONReset)
	ON_COMMAND(ID_BUTTONRot, OnBUTTONRot)
	ON_COMMAND(ID_BUTTONZoomAll, OnBUTTONZoomAll)
	ON_WM_SIZE()
	ON_COMMAND(ID_BUTTONZoomProg, OnBUTTONZoomProg)
	ON_COMMAND(ID_BUTTONZoomWin, OnBUTTONZoomWin)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_UPDATE_COMMAND_UI(ID_BUTTONHlrOn, OnUpdateBUTTONHlrOn)
	ON_UPDATE_COMMAND_UI(ID_BUTTONPan, OnUpdateBUTTONPan)
	ON_UPDATE_COMMAND_UI(ID_BUTTONZoomProg, OnUpdateBUTTONZoomProg)
	ON_UPDATE_COMMAND_UI(ID_BUTTONZoomWin, OnUpdateBUTTONZoomWin)
	ON_UPDATE_COMMAND_UI(ID_BUTTONRot, OnUpdateBUTTONRot)
	ON_COMMAND(ID_SENSITIVITY, OnSensitivity)
	ON_COMMAND(ID_BUTTONFly, OnBUTTONFly)
	ON_COMMAND(ID_BUTTONTurn, OnBUTTONTurn)
	ON_UPDATE_COMMAND_UI(ID_BUTTONFly, OnUpdateBUTTONFly)
	ON_UPDATE_COMMAND_UI(ID_BUTTONTurn, OnUpdateBUTTONTurn)
	ON_WM_TIMER()
	ON_COMMAND(ID_VIEW_DISPLAYSTATUS, OnViewDisplaystatus)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAYSTATUS, OnUpdateViewDisplaystatus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughView construction/destruction

CWalkthroughView::CWalkthroughView()
{
	// TODO: add construction code here
    myXmin=0;
    myYmin=0;  
    myXmax=0;
    myYmax=0;
    myCurZoom=0;

    // will be set in OnInitial update, but, for more security :
    myCurrentMode = CurrentAction3d_Nothing;
    myDegenerateModeIsOn=Standard_True;
    m_Pen = NULL;
	m_FlySens = 500. ;
	m_TurnSens = Standard_PI / 40. ;

}

CWalkthroughView::~CWalkthroughView()
{
	myView->Remove();
       	if (m_Pen) delete m_Pen;

}

BOOL CWalkthroughView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughView drawing
void CWalkthroughView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	Handle(V3d_Viewer) aViewer ;
	
    aViewer = GetDocument()->GetViewer() ;
	aViewer->DefaultPerspectiveView () ;
	aViewer->SetDefaultTypeOfView ( V3d_PERSPECTIVE ) ;
    myView = aViewer->CreateView();

    // set the default mode in wireframe ( not hidden line ! )
    myView->SetDegenerateModeOn();
    // store for restore state after rotation (witch is in Degenerated mode)
    myDegenerateModeIsOn = Standard_True;


	Handle(Graphic3d_WNTGraphicDevice) theGraphicDevice = 
		((CWalkthroughApp*)AfxGetApp())->GetGraphicDevice();
    
    Handle(WNT_Window) aWNTWindow = new WNT_Window(theGraphicDevice,GetSafeHwnd ());
    myView->SetWindow(aWNTWindow);
    if (!aWNTWindow->IsMapped()) aWNTWindow->Map();


	myPView = Handle(V3d_PerspectiveView)::DownCast (myView);
	m_Tune.Create ( IDD_TUNE , NULL ) ;
	
	RECT dlgrect;
	m_Tune.GetWindowRect(&dlgrect);
	LONG width = dlgrect.right-dlgrect.left;
	LONG height = dlgrect.bottom-dlgrect.top;
	RECT MainWndRect;
	AfxGetApp()->m_pMainWnd->GetWindowRect(&MainWndRect);
	LONG left = MainWndRect.left+3;
	LONG top = MainWndRect.top + 112;
	m_Tune.MoveWindow(left,top,width,height);
	
	m_Tune.m_pView = this ;

    // store the mode ( nothing , dynamic zooming, dynamic ... )

    myCurrentMode = CurrentAction3d_Nothing;

	ReloadData () ;
}

void CWalkthroughView::OnDraw(CDC* pDC)
{
	CWalkthroughDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	myView->Redraw();

}

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughView diagnostics

#ifdef _DEBUG
void CWalkthroughView::AssertValid() const
{
	CView::AssertValid();
}

void CWalkthroughView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWalkthroughDoc* CWalkthroughView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWalkthroughDoc)));
	return (CWalkthroughDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughView message handlers




void CWalkthroughView::OnSize(UINT nType, int cx, int cy) 
{
	m_cx = cx ;
	m_cy = cy ;
  if (!myView.IsNull())
   myView->MustBeResized();
}

void CWalkthroughView::OnBUTTONPan() 
{  myCurrentMode = CurrentAction3d_DynamicPanning; }

void CWalkthroughView::OnBUTTONPanGlo() 
{
  // save the current zoom value 
  myCurZoom = myView->Scale();
  // Do a Global Zoom 
  myView->FitAll();
  // Set the mode 
  myCurrentMode = CurrentAction3d_GlobalPanning;
  ReloadData () ;
}

void CWalkthroughView::OnBUTTONReset() 
{   myView->Reset();
    ReloadData () ;
}

void CWalkthroughView::OnBUTTONRot() 
{   myCurrentMode = CurrentAction3d_DynamicRotation; }


void CWalkthroughView::OnBUTTONZoomAll() 
{
  SetDimensions () ;
}

void CWalkthroughView::OnBUTTONZoomProg() 
{  myCurrentMode = CurrentAction3d_DynamicZooming; }

void CWalkthroughView::OnBUTTONZoomWin() 
{  myCurrentMode = CurrentAction3d_WindowZooming; }


void CWalkthroughView::OnBUTTONFly() 
{  myCurrentMode = CurrentAction3d_Fly; }

void CWalkthroughView::OnBUTTONTurn() 
{  myCurrentMode = CurrentAction3d_Turn; }

void CWalkthroughView::OnLButtonDown(UINT nFlags, CPoint point) 
{
  //  save the current mouse coordinate in min 
  myXmin=point.x;  myYmin=point.y;
  myXmax=point.x;  myYmax=point.y;

  if ( nFlags & MK_SHIFT )
	  m_bShift = TRUE ;
  else
	  m_bShift = FALSE ;

  if ( nFlags & MK_CONTROL ) 
	  {
	    // Button MB1 down Control :start zomming 
        // SetCursor(AfxGetApp()->LoadStandardCursor());
	  }
	else // if ( Ctrl )
	  {
		myView->At  ( m_Atx  , m_Aty  , m_Atz  ) ;
		myView->Eye ( m_Eyex , m_Eyey , m_Eyez ) ;

        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing : // start a drag
           if (nFlags & MK_SHIFT)
       	        GetDocument()->ShiftDragEvent(myXmax,myYmax,-1,myView);
           else
                GetDocument()->DragEvent(myXmax,myYmax,-1,myView);
        break;
         break;
         case CurrentAction3d_DynamicZooming : // noting
         break;
         case CurrentAction3d_WindowZooming : 
         break;
         case CurrentAction3d_DynamicPanning :// noting
         break;
         case CurrentAction3d_GlobalPanning :// noting
        break;
        case  CurrentAction3d_DynamicRotation :
			if (!myDegenerateModeIsOn)
			  myView->SetDegenerateModeOn();
			myView->StartRotation(point.x,point.y);  
        break;
        case  CurrentAction3d_Fly :
			KillTimer (1) ;
			SetTimer ( 1 , 100 , NULL ) ;
		break ;
        case  CurrentAction3d_Turn :
			KillTimer (1) ;
			SetTimer ( 1 , 100 , NULL ) ;
		break ;

		default :
        break;
        }
    }
}

void CWalkthroughView::OnLButtonUp(UINT nFlags, CPoint point) 
{
   if ( nFlags & MK_CONTROL ) 
	  {
        return;
	  }
	else // if ( Ctrl )
	  {
        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing :
         if (point.x == myXmin && point.y == myYmin)
         { // no offset between down and up --> selectEvent
            myXmax=point.x;  
            myYmax=point.y;
            if (nFlags & MK_SHIFT )
              GetDocument()->ShiftInputEvent(point.x,point.y,myView);
            else
              GetDocument()->InputEvent     (point.x,point.y,myView);
         } else
         {
            DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
            myXmax=point.x;  
            myYmax=point.y;
		    if (nFlags & MK_SHIFT)
				GetDocument()->ShiftDragEvent(point.x,point.y,1,myView);
			else
				GetDocument()->DragEvent(point.x,point.y,1,myView);
         }
         break;
         case CurrentAction3d_DynamicZooming :
         break;
         case CurrentAction3d_WindowZooming :
           DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
           myXmax=point.x;  
           myYmax=point.y;
	       if ((abs(myXmin-myXmax)>ValZWMin) || (abs(myYmin-myYmax)>ValZWMin))
					 // Test if the zoom window is greater than a minimale window.
			{
			  // Do the zoom window between Pmin and Pmax
			  myView->WindowFitAll(myXmin,myYmin,myXmax,myYmax);  
			}  
	       myCurrentMode = CurrentAction3d_Nothing;
         break;
         case CurrentAction3d_DynamicPanning :
         break;
         case CurrentAction3d_GlobalPanning :
	       myView->Place(point.x,point.y,myCurZoom); 
	       myCurrentMode = CurrentAction3d_Nothing;
        break;
        case  CurrentAction3d_DynamicRotation :
        break;
        case  CurrentAction3d_Fly :
			KillTimer ( 1 ) ;
        case  CurrentAction3d_Turn :
			KillTimer ( 1 ) ;
        default :
        break;
        } //switch (myCurrentMode)
    } //	else // if ( Ctrl )
}

void CWalkthroughView::OnMButtonDown(UINT nFlags, CPoint point) 
{
   if ( nFlags & MK_CONTROL ) 
	  {
      	// Button MB2 down Control : panning init  
        // SetCursor(AfxGetApp()->LoadStandardCursor());   
	  }
}

void CWalkthroughView::OnMButtonUp(UINT nFlags, CPoint point) 
{
   if ( nFlags & MK_CONTROL ) 
	  {
      	// Button MB2 down Control : panning init  
        // SetCursor(AfxGetApp()->LoadStandardCursor());   
	  }
}

void CWalkthroughView::OnRButtonDown(UINT nFlags, CPoint point) 
{
   if ( nFlags & MK_CONTROL ) 
	  {
        // SetCursor(AfxGetApp()->LoadStandardCursor());   
	    if (!myDegenerateModeIsOn)
	      myView->SetDegenerateModeOn();
	      myView->StartRotation(point.x,point.y);  
	  }
	else // if ( Ctrl )
	  {
	    GetDocument()->Popup(point.x,point.y,myView);
      }	
}

void CWalkthroughView::OnRButtonUp(UINT nFlags, CPoint point) 
{
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
    if (!myDegenerateModeIsOn)
    {  
      myView->SetDegenerateModeOff();
      myDegenerateModeIsOn = Standard_False;
    } else
    {
      myView->SetDegenerateModeOn();
      myDegenerateModeIsOn = Standard_True;
    }
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
}

void CWalkthroughView::OnMouseMove(UINT nFlags, CPoint point) 
{
    //   ============================  LEFT BUTTON =======================

  m_curx = point.x ;
  m_cury = point.y ;

  if ( nFlags & MK_SHIFT )
	  m_bShift = TRUE ;
  else
	  m_bShift = FALSE ;

  if ( nFlags & MK_LBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
	    // move with MB1 and Control : on the dynamic zooming  
	    // Do the zoom in function of mouse's coordinates  
	    myView->Zoom(myXmax,myYmax,point.x,point.y); 
	    // save the current mouse coordinate in min 
		myXmax = point.x; 
        myYmax = point.y;	
	  }
	  else // if ( Ctrl )
	  {
        switch (myCurrentMode)
        {
         case CurrentAction3d_Nothing :
		   myXmax = point.x;      myYmax = point.y;
       	   DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False);
           if (nFlags & MK_SHIFT)		
       	     GetDocument()->ShiftDragEvent(myXmax,myYmax,0,myView);
           else
             GetDocument()->DragEvent(myXmax,myYmax,0,myView);
       	   DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_True);
          break;
         case CurrentAction3d_DynamicZooming :
	       myView->Zoom(myXmax,myYmax,point.x,point.y); 
	       // save the current mouse coordinate in min \n";
	       myXmax=point.x;  myYmax=point.y;
         break;
         case CurrentAction3d_WindowZooming :
		   myXmax = point.x; myYmax = point.y;	
       	   DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_False,LongDash);
       	   DrawRectangle(myXmin,myYmin,myXmax,myYmax,Standard_True,LongDash);

         break;
         case CurrentAction3d_DynamicPanning :
		   myView->Pan(point.x-myXmax,myYmax-point.y); // Realize the panning
		   myXmax = point.x; myYmax = point.y;	
         break;
         case CurrentAction3d_GlobalPanning : // nothing           
        break;
        case  CurrentAction3d_DynamicRotation :
          myView->Rotation(point.x,point.y);
	      myView->Redraw();
        break;
		case CurrentAction3d_Fly :
			break ;
		case CurrentAction3d_Turn :
			break ;

        default :
        break;
        }//  switch (myCurrentMode)
      }// if ( nFlags & MK_CONTROL )  else 
    } else //   if ( nFlags & MK_LBUTTON) 
    //   ============================  MIDDLE BUTTON =======================
    if ( nFlags & MK_MBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
		myView->Pan(point.x-myXmax,myYmax-point.y); // Realize the panning
		myXmax = point.x; myYmax = point.y;	

	  }
    } else //  if ( nFlags & MK_MBUTTON)
    //   ============================  RIGHT BUTTON =======================
    if ( nFlags & MK_RBUTTON)
    {
     if ( nFlags & MK_CONTROL ) 
	  {
      	 myView->Rotation(point.x,point.y);
	  }
    }else //if ( nFlags & MK_RBUTTON)
    //   ============================  NO BUTTON =======================
    {  // No buttons 
	  myXmax = point.x; myYmax = point.y;	
	  if (nFlags & MK_SHIFT)
		GetDocument()->ShiftMoveEvent(point.x,point.y,myView);
	  else
		GetDocument()->MoveEvent(point.x,point.y,myView);
   }
}


void CWalkthroughView::OnUpdateBUTTONPanGlo(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_GlobalPanning);
}

void CWalkthroughView::OnUpdateBUTTONPan(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_DynamicPanning);
}

void CWalkthroughView::OnUpdateBUTTONZoomProg(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_DynamicZooming );
}

void CWalkthroughView::OnUpdateBUTTONZoomWin(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_WindowZooming);
}

void CWalkthroughView::OnUpdateBUTTONRot(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_DynamicRotation);
}

void CWalkthroughView::OnUpdateBUTTONFly(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_Fly);
}

void CWalkthroughView::OnUpdateBUTTONTurn(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (myCurrentMode == CurrentAction3d_Turn);
}



void CWalkthroughView::OnSensitivity() 
{
	CSensitivity dial ;

	dial.m_SensFly   = m_FlySens  ;
	dial.m_SensTurn  = m_TurnSens ;
	if ( dial.DoModal () ) {
		m_FlySens  = dial.m_SensFly   ;
        m_TurnSens = dial.m_SensTurn  ;
	}
}

void CWalkthroughView::Fly (int x , int y)
{
	double v [3] ;
	double l ;
	double sens ;
	int    i     ;

	sens = (double) myYmin - (double) y ;
	sens /= (double) m_cy ;
	sens *= m_FlySens ;

	v [0] = m_Atx - m_Eyex ;
	v [1] = m_Aty - m_Eyey ;
	v [2] = m_Atz - m_Eyez ;
	l = sqrt ( v[0]*v[0] + v[1]*v[1] + v[2]*v[2] ) ;
	if ( l > 1.e-3 ) {
		for ( i=0 ; i<3 ; i++ )
          v [i] = v [i] / l * sens ;

		m_Atx += v [0] ;
		m_Aty += v [1] ;
		m_Atz += v [2] ;

		m_Eyex += v [0] ;
		m_Eyey += v [1] ;
		m_Eyez += v [2] ;

	}

}

/* Rotation */

void CWalkthroughView::Turn (int x , int y)
{
	gp_Vec z (0.,0.,1.) ;

	double v [3] ;
	double sens ;
	double aX , aY , aZ ;

	sens = (double) x - (double) myXmin ;
	sens /= (double) m_cx ;
	sens *= m_TurnSens ;

	v [0] = m_Atx - m_Eyex ;
	v [1] = m_Aty - m_Eyey ;
	v [2] = m_Atz - m_Eyez ;

	gp_Pnt eye ( m_Eyex , m_Eyey , m_Eyez ) ;

	gp_Vec reg (v[0],v[1],v[2] );

	gp_Vec vert = reg ^ z ;
	gp_Vec haut = vert ^ reg ;

	gp_Dir dh (haut) ;
	gp_Ax1 rot (eye,dh);

	reg.Rotate (rot,sens) ;

	reg.Coord ( aX , aY , aZ ) ;

	m_Atx = m_Eyex + aX ;
	m_Aty = m_Eyey + aY ;
	m_Atz = m_Eyez + aZ ;

}

void CWalkthroughView::Roll (int x , int y)
{
	gp_Vec z (0.,0.,1.) ;

	double v [3] ;
	double sens ;
	double aX , aY , aZ ;

	sens = (double) x - (double) myXmin ;
	sens /= (double) m_cx ;
	sens *= m_TurnSens ;

	v [0] = m_Atx - m_Eyex ;
	v [1] = m_Aty - m_Eyey ;
	v [2] = m_Atz - m_Eyez ;

	gp_Pnt eye ( m_Eyex , m_Eyey , m_Eyez ) ;

	gp_Vec reg (v[0],v[1],v[2] );

	gp_Vec vert = reg ^ z ;

	gp_Dir dh (vert) ;
	gp_Ax1 rot (eye,dh);

	reg.Rotate (rot,sens) ;

	reg.Coord ( aX , aY , aZ ) ;

	m_Atx = m_Eyex + aX ;
	m_Aty = m_Eyey + aY ;
	m_Atz = m_Eyez + aZ ;

}

void CWalkthroughView::Twist (int x , int y)
{
	double sens ;
	double a ;
	
	a = myView->Twist () ;

	sens = (double) x - (double) myXmin ;
	sens /= (double) m_cx ;
	sens *= m_TurnSens ;

	a += sens ;

	myView->SetTwist (a) ;

}


void CWalkthroughView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnTimer(nIDEvent);

	if ( nIDEvent == 1 ) {
	  myView->SetImmediateUpdate ( Standard_False ) ;
      if ( myCurrentMode == CurrentAction3d_Fly ) {

         Fly  ( m_curx , m_cury ) ;
	     if ( m_bShift )
           Roll ( m_curx , m_cury ) ;
	     else
           Turn ( m_curx , m_cury ) ;

 		myView->SetAt  ( m_Atx  , m_Aty  , m_Atz  ) ;
		myView->SetEye ( m_Eyex , m_Eyey , m_Eyez ) ;

	  }
      else if ( myCurrentMode == CurrentAction3d_Turn ) {
           Twist ( m_curx , m_cury ) ;
	  }
	  else
		  KillTimer (1) ;


  	  myView->SetImmediateUpdate ( Standard_True ) ;

      myView->Update ();
	}

	ReloadData () ;
}

void CWalkthroughView::SetFocal(double dFocus,double dAngle)
{
	double v [3] ;
	double l ;
	int    i     ;

	v [0] = m_Atx - m_Eyex ;
	v [1] = m_Aty - m_Eyey ;
	v [2] = m_Atz - m_Eyez ;

	l = sqrt ( v[0]*v[0] + v[1]*v[1] + v[2]*v[2] ) ;
	if ( l > 1.e-3 ) {
		for ( i=0 ; i<3 ; i++ )
          v [i] = v [i] / l * dFocus ;

		m_Focus = dFocus ;

		m_Atx = v [0] + m_Eyex ;
		m_Aty = v [1] + m_Eyey ;
		m_Atz = v [2] + m_Eyez ;

        myView->SetImmediateUpdate ( Standard_False ) ;
 		myView->SetAt  ( m_Atx  , m_Aty  , m_Atz  ) ;
		m_dAngle = dAngle ;
		dAngle = dAngle * Standard_PI / 180. ;
        myPView->SetAngle ( dAngle ) ;
		dAngle = myPView->Angle () ;

        myView->SetImmediateUpdate ( Standard_True ) ;
        myView->Update ();

	}
}

void CWalkthroughView::ReloadData()
{

	char szMsg [128] ;
	double dTwist ;

	myView->At  ( m_Atx  , m_Aty  , m_Atz  ) ;
	myView->Eye ( m_Eyex , m_Eyey , m_Eyez ) ;

	dTwist = myView->Twist () ;
	dTwist = dTwist * 180. / Standard_PI ;

	sprintf ( szMsg , "%lf" , m_Atx ) ;
	(m_Tune.GetDlgItem ( IDC_XAT ))->SetWindowText ( szMsg ) ;
	sprintf ( szMsg , "%lf" , m_Aty ) ;
	(m_Tune.GetDlgItem ( IDC_YAT ))->SetWindowText ( szMsg ) ;
	sprintf ( szMsg , "%lf" , m_Atz ) ;
	(m_Tune.GetDlgItem ( IDC_ZAT ))->SetWindowText ( szMsg ) ;

	sprintf ( szMsg , "%lf" , m_Eyex ) ;
	(m_Tune.GetDlgItem ( IDC_XEYE ))->SetWindowText ( szMsg ) ;
	sprintf ( szMsg , "%lf" , m_Eyey ) ;
	(m_Tune.GetDlgItem ( IDC_YEYE ))->SetWindowText ( szMsg ) ;
	sprintf ( szMsg , "%lf" , m_Eyez ) ;
	(m_Tune.GetDlgItem ( IDC_ZEYE ))->SetWindowText ( szMsg ) ;

	sprintf ( szMsg , "%lf" , dTwist ) ;
	(m_Tune.GetDlgItem ( IDC_TWIST ))->SetWindowText ( szMsg ) ;

	double dx,dy,dz ;
	dx = m_Atx - m_Eyex ;
	dy = m_Aty - m_Eyey ;
	dz = m_Atz - m_Eyez ;

    m_Focus = sqrt ( dx * dx + dy * dy + dz * dz ) ;
	m_dAngle = myPView->Angle () ;
	m_dAngle = m_dAngle * 180. / Standard_PI ;

	m_Tune.m_dAngle = m_dAngle ;
	m_Tune.m_dFocus = m_Focus  ;
	m_Tune.UpdateData ( FALSE ) ;

}

void CWalkthroughView::SetDimensions()
{

  CWalkthroughDoc* pDoc = GetDocument();

  myView->SetImmediateUpdate ( Standard_False ) ;

  m_Atx  = ( pDoc->m_Xmin + pDoc->m_Xmax ) / 2. ;
  m_Aty  = ( pDoc->m_Ymin + pDoc->m_Ymax ) / 2. ;
  m_Atz  = ( pDoc->m_Zmin + pDoc->m_Zmax ) / 2. ;
  m_Eyex = pDoc->m_Xmax ;
  m_Eyey = pDoc->m_Ymax ;
  m_Eyez = pDoc->m_Zmax ;

  myView->SetAt    ( m_Atx  , m_Aty  , m_Atz  ) ;
  myView->SetEye   ( m_Eyex , m_Eyey , m_Eyez ) ;
  myView->SetTwist (0.) ;

  myView->SetImmediateUpdate ( Standard_False ) ;
  myView->FitAll();
  myView->SetImmediateUpdate ( Standard_False ) ;
  myView->ZFitAll();

  myView->SetImmediateUpdate ( Standard_True ) ;

  ReloadData () ;
  myView->Update ();
}

void CWalkthroughView::OnViewDisplaystatus() 
{
	// TODO: Add your command handler code here

	if ( m_Tune.IsWindowVisible () ) {

	}
	else {
		m_Tune.ShowWindow ( SW_SHOWNORMAL ) ;
	}

}

void CWalkthroughView::OnUpdateViewDisplaystatus(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	if ( m_Tune.IsWindowVisible () ) {
		pCmdUI->SetCheck ( 1 ) ;
	}
	else {
		pCmdUI->SetCheck ( 0 ) ;
	}
}
