/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __DIRECT3D_H__
#define __DIRECT3D_H__

#include <windows.h>
#include "DirectDraw.h"
#include <d3d.h>
#include "poly.h"

#define MAX_TEXTURES 128

class CView;
class CTexture;

class CDirect3D
{
	CDirectDraw *DDraw;
	IDirectDrawSurface7* lpRenderTarget;
	IDirectDrawSurface7* lpZBuffer;
	IDirect3D7* lpD3D;
	IDirect3DDevice7* lpD3DDevice;
	CView *view;
	CDirect3D *D3DReflect;
	int scrnX,scrnY,texCount;
    CTexture *texture[MAX_TEXTURES];
    int maxVert,vertSectionSize;
    int stencil;
public:
    D3DDEVICEDESC7 devCaps;
	CDirect3D(CDirectDraw *dd,IDirectDrawSurface7* target);
	~CDirect3D();
    void SetWorldMatrix(D3DMATRIX *mat);
	IDirect3D7* GetD3D() { return lpD3D; }
	CDirectDraw* GetDDraw() { return DDraw; }
	IDirect3DDevice7* GetD3DDevice() { return lpD3DDevice; }
    void SetView(CView *_view);
	void SetRenderState(D3DRENDERSTATETYPE state,DWORD val);
	void SetRenderStateFloat(D3DRENDERSTATETYPE state,float val);
	void SetBackgroundColor(D3DCOLOR color);
	void BeginRender();
	void EndRender();
	void BeginScene();
	void EndScene();
	void DrawPrimitive(D3DPRIMITIVETYPE type,Vertex* vert,
		int count,DWORD flags);
	void SetTexture(int stage,CTexture *tex);
    void ClearZBuffer();
    void ClearStencilBuffer();
	void AddTexture(CTexture *tex) { texture[texCount++]=tex; }
    void SetTextureStageState(int stage,
        D3DTEXTURESTAGESTATETYPE state,DWORD value);
};

#endif
