/* AWTException.java -- Generic AWT exception
   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of the non-peer AWT libraries of GNU Classpath.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published 
by the Free Software Foundation, either version 2 of the License, or
(at your option) any later verion.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; if not, write to the Free Software Foundation
Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA. */


package java.awt;

/**
  * This is a generic exception that indicates an error occurred in the
  * AWT system.
  *
  * @author Aaron M. Renn (arenn@urbanophile.com)
  */
public class AWTException extends Exception
{

/**
  * Initializes a new instance of <code>AWTException</code> with the
  * specified detailed error message.
  *
  * @param message The detailed error message.
  */
public
AWTException(String message)
{
  super(message);
}

} // class AWTException 

