#!/usr/bin/perl -w

print "Attention: This script is still very experimental and does not behave well under all circumstances!\n".
      "Please check its results!\nDo you want to continue? [y/N] ";
$answer = <>;
exit if (($answer !~ "^Y") && ($answer !~ "^y"));

$pinercname = $ENV{"HOME"}."/.pinerc";
$masterrcname = "/etc/pine.conf";
if (!(stat $masterrcname)) {
  $masterrcname = "/usr/local/etc/pine.conf";
  if (!(stat $masterrcname)) {$masterrcname = undef;}
}

$sizemyrc = (stat $pinercname)[7];
if ($sizemyrc) {
  open IN,$pinercname || die "Error opening ".$pinercname;
  read IN,$pinerc,$sizemyrc;
  close IN;
}

if (stat "/usr/local/bin/pgp4pine") {
  $pgp4pine = "/usr/local/bin/pgp4pine"
} elsif (stat "/usr/bin/pgp4pine")  {
  $pgp4pine = "/usr/bin/pgp4pine"
} else {
  print "Unable to find pgp4pine executable. Please enter the full path: ";
  $pgp4pine = <>;
  if (!(stat $pgp4pine) && ($pgp4pine !~ m/\//)) {
    $pgp4pine .= "/pgp4pine";
  }
  (stat $pgp4pine) || die "pgp4pine still not found."
}

$done=0;
if ($sizemyrc) {
  if ($pinerc =~ /display-filters=.*_BEGINNING\("-----BEGIN PGP"\)_/m ) { # found display
    print "Display filter seems to be already installed.\n";
    $done=1;
  }
  if ($pinerc =~ /sending-filters=.*pgp4pine/) { # found sending
    print "Sending filter seems to be already installed.\n";
    $done=1;
  }
}

if ($masterrcname) {
  $size = (stat $masterrcname)[7];
  open IN,$masterrcname || die "Error opening ".$masterrcname;
  read IN,$masterrc,$size;
  close IN;

  if ($masterrc =~ /display-filters\s*=.*_BEGINNING\("-----BEGIN PGP"\)_/m ) { # found display
    print "Display filter seems to be already installed in system-wide pine.conf.\n";
    $found_in_master=1;
    $done=1;
  }
  if ($masterrc =~ /sending-filters\s*=.*pgp4pine/) { # found sending
    print "Sending filter seems to be already installed in system-wide pine.conf.\n";
    $found_in_master=1;
    $done=1;
  }
}

$display_string = "display-filters=_BEGINNING(\"-----BEGIN PGP\")_ $pgp4pine -d -i _TMPFILE_";
$sending_string = "sending-filters=$pgp4pine -e -i _TMPFILE_ -r _RECIPIENTS_";

if (($> == 0) && ($masterrcname && !$found_in_master)) { # Being root and no entry yet
  print "Do you want to make pgp4pine entries into the system-wide pine.conf\nat ${masterrcname}? [Y/n]";
  $answer = <>;
  if ($answer eq "\n" || $answer =~ "^y" || $answer =~ "^Y") {
    if ($masterrc =~ /display-filters\s*=\s*\S+.*\n/) # there is a non-zero entry
      { $masterrc =~ s/display-filters\s*=\s*(\S+.*\n)/$display_string,\n\t$1/m}
    elsif ($masterrc =~ /display-filters\s*=/)	# just the tag, but no entry
      { $masterrc =~ s/display-filters\s*=/$display_string/}
    else
      { $masterrc .= "# Entry inserted by pgp4pine\n".$display_string."\n";} 
    
    if ($masterrc =~ /sending-filters\s*=\s*\S+.*\n/) # there is a non-zero entry
      { $masterrc =~ s/sending-filters\s*=\s*(\S+.*\n)/$sending_string,\n\t$1/m}
    elsif ($masterrc =~ /sending-filters\s*=/)	# just the tag, but no entry
      { $masterrc =~ s/sending-filters\s*=/$sending_string/}
    else
      { $masterrc .= "# Entry inserted by pgp4pine\n".$sending_string."\n";}
    chmod 0644,$masterrcname;
    open OUT, ">".$masterrcname;
    print OUT $masterrc;
    close OUT;
    $done=1;
  }
}

if (!$done) {
  print "Do you want to make pgp4pine entries to your private .pinerc? [Y/n]";
  $answer = <>;
  if ($answer eq "\n" || $answer =~ "^y" || $answer =~ "^Y") {
    if ($sizemyrc) { 	# Is there a personal .pinerc?
      if ($pinerc =~ /display-filters\s*=\s*\S+.*\n/m) # there is a non-zero entry
        { $pinerc =~ s/display-filters\s*=\s*(\S+.*\n)/$display_string,\n\t$1/m}
      elsif ($pinerc =~ /display-filters\s*=/)	# just the tag, but no entry
        { $pinerc =~ s/display-filters\s*=/$display_string/}
      else
        { $pinerc .= "# Entry inserted by pgp4pine\n".$display_string."\n";} 
    
      if ($pinerc =~ /sending-filters\s*=\s*\S+.*\n/m) # there is a non-zero entry
        { $pinerc =~ s/sending-filters\s*=\s*(\S+.*\n)/$sending_string,\n\t$1/m}
      elsif ($pinerc =~ /sending-filters\s*=/)	# just the tag, but no entry
        { $pinerc =~ s/sending-filters\s*=/$sending_string/}
      else
        { $pinerc .= "# Entry inserted by pgp4pine\n".$sending_string."\n";}
      print "Jetzt:$masterrc";
    } else { 	# No personal rc, create one
      $pinerc = "# Entries created by pgp4pine\n$display_string\n$sending_string\n";
    }    
    chmod 0644,$pinercname;
    open OUT, ">".$pinercname;
    print OUT $pinerc;
    close OUT;
  }
}
