/****************************************************************************
** menu.h file.
**
** This file handles the user input to generate a DVD menu.
** Please note that this is work in progress and depends also oin the
** developement of dvdauthor, which is at the moment in version 0.67.
** Future versions of dvdauthort might need changes to this file.
**
*****************************************************************************/

#include <stdlib.h>

#include "global.h"
#include "dialogman.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qstringlist.h>
#include <qlineedit.h>

/*
 *  Constructs a MyDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DialogMan::DialogMan( QStringList &listOfCommands, QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )

{
	uint t;
    if ( !name )
	setName( "DialogMan" );
	setSizeGripEnabled( TRUE );
	MyDialogLayout = new QGridLayout( this, 1, 1, 11, 6, "MyDialogLayout");

	Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1"); 

	buttonHelp = new QPushButton( this, "buttonHelp" );
	buttonHelp->setAutoDefault( TRUE );
	Layout1->addWidget( buttonHelp );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout1->addItem( spacer );

	m_pEditFind = new QLineEdit ( this, "m_pEditFind" );
	Layout1->addWidget( m_pEditFind );
    
	buttonFind = new QPushButton( this, "buttonFind" );
	buttonFind->setAutoDefault( TRUE );
	buttonFind->setDefault( TRUE );
	Layout1->addWidget( buttonFind );
    
	buttonOk = new QPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	Layout1->addWidget( buttonOk );

	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	Layout1->addWidget( buttonCancel );

	MyDialogLayout->addLayout( Layout1, 1, 0 );

	tabWidget2 = new QTabWidget( this, "tabWidget2" );

	QWidget		*pTab;
	QGridLayout	*pTabLayout;
	QTextEdit	*pTextEdit;
	QString		 command;
	QString		line;
	for (t=0;t<listOfCommands.count();t++)	{
		pTab = new QWidget( tabWidget2, (const char *)listOfCommands[t] );
		pTabLayout = new QGridLayout( pTab, 1, 1, 11, 6, QString("tabLayout%1").arg(t));

		pTextEdit = new QTextEdit( pTab, QString("textEdit%1").arg(t) );
		pTextEdit->setPaletteForegroundColor( QColor( 119, 194, 40 ) );
		pTextEdit->setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
		pTextEdit->setReadOnly ( true );

		pTabLayout->addWidget( pTextEdit, 0, 0 );
		tabWidget2->insertTab( pTab, (QString ("man ") + listOfCommands[t] ));

		// here we put the man pages into a text file and read tis file into the textEdit.
		command = QString("man %1 2>/dev/null | col -b > /tmp/%2.man").arg(listOfCommands[t]).arg(listOfCommands[t]);
		system ((const char *)command);
		command = QString("/tmp/%1.man").arg(listOfCommands[t]);
		QFileInfo fileInfo(command);
		// Check to see if we found a man page for this command ...
		if (fileInfo.size() < 10)
			pTextEdit->append(QString("No man page found for command %1.").arg(listOfCommands[t]));
		else	{	// Okay seems like we foun d a valid man page ...
			QFile file (command);
			file.open (IO_ReadOnly);
			while (file.readLine(line, 1024) > -1)	{
				pTextEdit->append(line);
			}
			file.close();
		}
		// go back to the top.
		pTextEdit->center(0, 0);
		m_listTextEdit.append(pTextEdit);
	}

	MyDialogLayout->addWidget( tabWidget2, 0, 0 );
	languageChange();
	resize( QSize(783, 614).expandedTo(minimumSizeHint()) );

	// signals and slots connections
	connect( buttonFind, SIGNAL( clicked() ), this, SLOT( slotFind() ) );
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
DialogMan::~DialogMan()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DialogMan::languageChange()
{
	setCaption( tr( "DialogMan" ) );
	buttonHelp->setText( tr( "&Help" ) );
	buttonHelp->setAccel( QKeySequence( tr( "F1" ) ) );
	buttonFind->setText( tr( "&Find" ) );
	buttonFind->setAccel( QKeySequence( QString::null ) );
	buttonOk->setText( tr( "&OK" ) );
	buttonOk->setAccel( QKeySequence( QString::null ) );
	buttonCancel->setText( tr( "&Cancel" ) );
	buttonCancel->setAccel( QKeySequence( QString::null ) );
}

void DialogMan::slotFind ()
{
	// This function will take the entered text and search for it in the Man page currently active ...
	if (m_listTextEdit.count() < 1)
		return;
	QTextEdit *pTextEdit = m_listTextEdit[0];
	bool bFound = pTextEdit->find (m_pEditFind->text(), false, false);
	if (!bFound)	{
		// Set cursor back to the top ...
		pTextEdit->setCursorPosition(0, 0);
		bFound = pTextEdit->find (m_pEditFind->text(), false, false);
		if (!bFound)
			return;
	}
}


