
#include <qapplication.h>
#include <qtextcodec.h>
#include <qdir.h>

#include "global.h"
#include "dvdmenu.h"
#include "qdvdauthor.h"

int main( int argc, char ** argv )
{
	Global::pLogObject = new Log(Log::logDebug);
	int iReturn = 0; 
	QApplication application( argc, argv );
	// translation file for Qt
	QTranslator qt( 0 );
	// Under $QTDIR/translations/
	qt.load( QString( "qt_" ) + QTextCodec::locale(), "." );
	application.installTranslator( &qt );

	QDVDAuthor dvdAuthor;
	VMGMenu *pDVDMenu = new VMGMenu (&dvdAuthor);

	dvdAuthor.addDVDMenu(pDVDMenu, true);
	dvdAuthor.show();
	dvdAuthor.postInit ();
	application.connect( &application, SIGNAL( lastWindowClosed() ), &application, SLOT( quit() ) );
	iReturn = application.exec();

	delete Global::pLogObject;
	Global::pLogObject = NULL;
	return iReturn;
}

