/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef QDVDAUTHOR_H
#define QDVDAUTHOR_H


class QDomNode;
class QDomElement;
class QListViewItem;
class QTranslator;
class QPopupMenu;
class QTimer;
class QListBox;
class QPopupMenu;

#include ".ui/formmain.h"

class ButtonObject;
class ColorToolBar;
class SourceToolBar;
class StructureToolBar;
class SourceFileEntry;
class DVDMenu;
class MediaInterface;
class MediaInfo;
class uiDialogRenderPreview;
class DialogExecute;
class TemplateWizard;
#define DVDAUTHOR_XML "dvdauthor.xml"

#include "utils.h"
#include "dragndropcontainer.h"

class QDVDAuthor : public CFormMain
{
	Q_OBJECT

public:
	 QDVDAuthor ();
	~QDVDAuthor ();

public slots:
	virtual void fileNew();
	virtual void fileOpen();
	virtual void fileSave();
	virtual void fileSave(QString);
	virtual void fileSaveAs();
	virtual void filePrint();
	virtual void fileExit();
	virtual void editUndo();
	virtual void editRedo();
	virtual void editCut();
	virtual void editPaste();
	virtual void editFind();
	virtual void helpIndex();
	virtual void helpContents();
	virtual void helpAbout();

	virtual void slotAutosave                 ();
	virtual void slotChangeLanguage        (int);
	virtual void slotVisibleRegion        (bool);
	virtual void slotSetup                    ();
	virtual void slotDialogTemp               ();
	virtual void slotExportDVDAuthorXML       ();
	virtual void slotEditAddMovie             ();
	virtual void slotEditAddSlideshow         ();
	virtual void slotStructureClicked(QListViewItem*);
	virtual void slotGenerateMasks            ();
	virtual void slotCreateDVD                ();
	virtual void slotCreateSVCD               ();
	virtual void slotCreateVCD                ();
	virtual void slotAddSubMenu               ();
	virtual void slotAddFromTemplate          ();
	virtual void slotFeedback                 ();
	virtual void slotTabChanged      (QWidget *);
	virtual void slotRemoveCurrentSubMenu     ();
	virtual void slotDeleteTemplateWizard     ();
	virtual void slotRenameCurrentSubMenu     ();
	virtual void slotUndoStack                ();
	virtual void slotUpdateStructure          ();
	virtual void slotDeleteTempOlderThan      ();
	virtual void slotCreateXml (const QString &);
	virtual void slotUpdateMenuBar            ();
	virtual void slotChangeHistory         (int);
	virtual void slotRenderMenu        (QString);
	virtual void slotChangeStyle(const QString&);
	virtual void slotCalculateSize            ();
//	virtual void slotSetSlideshowEntry (QString);
//	virtual void slotSlideshowDone     (QString);
signals:
	void signalVisibleRegion (bool);

public:
	void postInit             ();
	void addDVDMenu           (DVDMenu *, bool b=false);
	void createDvdauthorXml   (QString &);
	void returnFromRenderMenu ();
	bool checkForNewProject   ();

	int  getFreeSourceSlot();
	void addMovieList (QStringList &, QString *p=NULL);
	int  sourceFileCount();
	SourceFileEntry *sourceFileEntry(uint);
	SourceFileEntry *getSourceEntryByDisplayName(QString &);
	void appendSourceFileEntry (SourceFileEntry *);
	void removeSourceFileEntry (SourceFileEntry *); // called to remove the SourceFileEntry
	void removedSourceEntry (SourceFileEntry *);    // called after entry has been removed from SourceToolBar
	void replaceSourceDisplayName (QString &, QString &);
	bool isSourceEntryUsed(QString &);
	void addSound (QStringList &);
	void setColor (uint, QColor);
	MediaInfo *getMediaInfo ();
	DragNDropContainer *getDragNDropContainer();
	
	DVDMenu         *getCurrentSubMenu  ();
	DVDMenu         *getSubMenuByName(QString);
	QValueList<DVDMenu *> &getSubMenus  ();
	QString &currentPath   ();

	QString getUniqueMenuTitle (QString, int i=0, DVDMenu *p=NULL);
	QString getImageFilter ();
	QString getMovieFilter ();
	QString getSoundFilter ();

private: 	// Private functions ...
	void initMe   ();
	bool cleanUp  ();
	void LoadIni  ();
	void SaveIni  ();
	void newWizard();
	void fileOpen(QString);
	void buildHistoryEntries           ();
	void updateHistoryPix             ( );
	void initLanguages              (   );
	void initStyles               (     );
	void addHistory             (QString);
	bool readProjectFile     (QDomNode &);
	bool writeProjectFile (QDomElement &);
	void setAutosave      ( bool b=false);
	void createTempDirStructure ();
	void createDvdauthorXml ();
	void createMenuXml ();
	void createMenuXml (DVDMenu *pMenu);
	void createDVD ();
	bool checkHealth ();
	QString getTempFile        (QString);
	QString getButtonAction    (ButtonObject *, int, bool b=false);

private:
	// Here we store the path to the different tools required.
	QValueList<Utils::toolsPaths *>  m_listToolsPaths;
	bool    m_bVisibleRegion;

	DVDMenu *m_pVMGMenu;
	QValueList<DVDMenu *>	m_listDVDMenus;
	DragNDropContainer      m_dragNDropContainer;
	QStringList             m_listHistory;
	QValueList<QPixmap *>   m_listHistoryPix;
	int                     m_iMaxHistoryFiles;
	int                     m_iAutosave;	// Autosave every x seconds ...
	QString                 m_qsStyle;
	QTimer                 *m_pTimerAutosave;
	
	ColorToolBar           *m_pColorToolbar;
	SourceToolBar          *m_pSourceToolbar;
	StructureToolBar       *m_pStructureToolbar;
	QPopupMenu             *m_pMenuHistory;
		bool m_bModified;
	QTranslator            *m_pTranslator;
	QPopupMenu             *m_pLanguagePopup;
	QPopupMenu             *m_pStylesPopup;
	DialogExecute          *m_pDialogExecute;
	TemplateWizard         *m_pTemplateWizard;
};

#endif // QDVDAUTHOR_H
