/****************************************************************************
** TemplateWizard class
**
** Created: Mon May 23 12:09:08 2005
**      by: Varol Okan using kate editor
**
** This class allows the user to choose a template and simply fillin the 
** blanks.
**
** Templates are stored under :
** /usr/share/qdvdauthor/templates/static/<tmpltdir>
** /usr/share/qdvdauthor/templates/movie/<tmpltdir>
** - each template has its own tmpltdir
** - each tmpltdir has a preview.jpg OR preview.mpg
** - each tmpltdir has a template.xml file, which describes the template.
**
****************************************************************************/

#ifndef TEMPLATEWIZARD_H
#define TEMPLATEWIZARD_H

#include <qframe.h>

#include "uitemplatewizard.h"

class MediaInterface;
class QDVDAuthor;
class DVDMenu;

// This class was derived to have the mouseClick covered
class TemplateFrame : public QFrame
{
	Q_OBJECT
public:
	TemplateFrame ( QWidget *p=0, const char *n=0, WFlags f=0 );
	virtual ~TemplateFrame ();

protected slots:
	void mouseReleaseEvent ( QMouseEvent * );

signals:
	void signalMouseReleaseEvent (QMouseEvent *);
};

class TemplateWizard : public uiTemplateWizard
{
	Q_OBJECT

public:
	class DropZone
	{
		 DropZone ();
	public:
		 DropZone (int, QString, QRect);
 		~DropZone ();

		int      iNumber;	// Counter, of which DropZone we have ... E.g. 1
		bool     bMovie;	// Is this a movie Source ?
		QString  qsText;	// E.g "Movie 1" used for ???
		QRect    rect;
		QString  qsFileName;
		QPixmap *pPixmap;
	};

	 TemplateWizard( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~TemplateWizard();

	void initMe (QDVDAuthor *);
	DVDMenu *getMenu        ();

protected:
	void initTab (QString, QIconView *);
	void initPreview                 ();
	void refreshBackground           ();
	void refreshComboMenu            ();

	QString readProjectFile (QString, bool);

protected slots:
	virtual void slotTemplateClicked   (QMouseEvent   *);
	virtual void slotIconViewClicked   (QIconViewItem *);
	virtual void slotTargetMenuChanged (const QString &);
	virtual void slotPlaybackFinished  ();
	virtual void next   ();
	virtual void reject ();
	virtual void accept ();
	virtual void hide   ();
    
private:
	QDVDAuthor              *m_pDVDAuthor;
	TemplateFrame           *m_pFrameProperties;
	DVDMenu                 *m_pDVDMenu;
	MediaInterface          *m_pMediaInterface;
	bool                     m_bDontRestart;

	QValueList<DVDMenu *>    m_listDVDMenus;
	QString                  m_qsPathName;
	QValueList<DropZone *>   m_listDropZones;
	QString                  m_qsXMLDVDMenu;
	QString                  m_qsCurrentTemplate;
	float                    m_fScale;
};

#endif // TEMPLATEWIZARD_H
