
#ifndef UTILS_H
#define UTILS_H

#include <qvaluelist.h>
#include <qstring.h>
#include <qcolor.h>

class Utils
{

public:
	// Structure to store the paths to the different tools.
	struct toolsPaths {
		toolsPaths ()	{ bPresent = false; };
//		toolsPaths &operator = (toolsPaths &theOther)
//		{
//			qsExecutableName = theOther.qsExecutableName;
//			qsFullPath  = theOther.qsFullPath;
//			bPresent = theOther.bPresent;
//			return *this;
//		}
		QString qsExecutableName; 
		QString qsFullPath; 
		bool bPresent;
	};

	 Utils ();
	~Utils ();
	
	bool    recRmdir(const QString &, const char *p=NULL) const;
	QString iso639 (QString, bool b=false);
	QString checkForExe          (QString);
	QString getToolsDisplayName  (QString);
	int getIndexFromToolName     (QString);
	QString getTempFile          (QString);
	QStringList getProjectsFromTempPath ();
	QString getUniqueTempFile    (QString);
	QString getToolByIndex       (uint);
	bool    isMandatory          (uint);
	QValueList<Utils::toolsPaths *> scanSystem ();
	QRgb    nearestColor (QRgb *, int, QRgb);

	QImage  convertStringToImage (QString &);
	QString convertImageToString (QImage  &);
	QString getVideoFormat       (int,  int);

	int      getMsFromString(QString);
	QString  getStringFromMs(int);

};

#endif  // UTILS_H
