%define dvd_slideshow dvd-slideshow_0.5.4

# platform defines
%define rh9 0
%{?build_rh9:%define rh9 1}
%define suse 0
%{?build_suse:%define suse 1}

Summary: QDVDAuthor, the GUI frontend for dvdauthor and other related tools.
Name: qdvdauthor
Version: 0.0.8a
Release: 1
Group: Applications/Multimedia
Copyright: GPL v2
Source0: %{name}-%{version}.tar.gz
Source1: %{dvd_slideshow}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
URL: http://qdvdauthor.sourceforge.net/
Packager: D. Scott Barninger <barninger at fairfieldcomputers dot com>
%define qdvdauthor_dir %{name}-%{version}

BuildRequires: ImageMagick-devel
%if %{rh9}
BuildRequires: ImageMagick-c++-devel
%endif
%if %{suse}
BuildRequires: ImageMagick-Magick++
%endif
%if %{rh9}
BuildRequires: bzip2-devel
%endif
%if %{suse}
BuildRequires: bzip2
%endif
%if %{rh9}
BuildRequires: qt-devel
%endif
%if %{suse}
BuildRequires: qt3-devel
%endif
BuildRequires: glibc-devel
%if %{rh9}
BuildRequires: freetype-devel
%endif
%if %{suse}
BuildRequires: freetype2-devel
%endif
%if %{rh9}
BuildRequires: libjpeg-devel
%endif
%if %{suse}
BuildRequires: libjpeg
%endif
BuildRequires: libpng-devel
%if %{rh9}
BuildRequires: libtiff-devel
%endif
%if %{suse}
BuildRequires: libtiff
%endif
BuildRequires: libxml2-devel
BuildRequires: zlib-devel

Requires: ImageMagick
%if %{rh9}
Requires: ImageMagick-c++
%endif
%if %{suse}
Requires: ImageMagick-Magick++
%endif
Requires: bzip2
Requires: dvdauthor
Requires: mjpegtools
%if %{rh9}
Requires: qt >= 3.1
%endif
%if %{suse}
Requires: qt3 >= 3.2
%endif
Requires: glibc >= 2.3
Requires: libgcc >= 3.2
%if %{rh9}
Requires: freetype
%endif
%if %{suse}
Requires: freetype2
%endif
Requires: libjpeg
Requires: libpng
Requires: libtiff
Requires: libxml2
Requires: zlib
Requires: sox

%description

QDVDAuthor is a gui frontend for using dvdauthor and dvd-slideshow scripts to easily 
build DVD menus and assemble the DVD VOB files. This package includes %{dvd_slideshow} 
in the installation.

%prep

%setup -b 1

%build
export QDVDAUTHOR_ROOT=$RPM_BUILD_DIR/%{qdvdauthor_dir}
export IMAGE_LIB=imagemagicklib

cd $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor
qmake qdvdauthor.pro
make

cd qslideshow
qmake qslideshow.pro
make
cd ../../

%install

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
mkdir -p $RPM_BUILD_ROOT/usr/share/applications
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/qdvdauthor \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/qslideshow/qslideshow \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dvd-slideshow \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dvd-menu \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/gallery2slideshow \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/jigl2slideshow \
	$RPM_BUILD_ROOT/usr/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dir2slideshow \
	$RPM_BUILD_ROOT/usr/bin
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dvd-slideshow.1 \
	$RPM_BUILD_ROOT/usr/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dvd-menu.1 \
	$RPM_BUILD_ROOT/usr/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dir2slideshow.1 \
	$RPM_BUILD_ROOT/usr/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/gallery2slideshow.1 \
	$RPM_BUILD_ROOT/usr/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/jigl2slideshow.1 \
	$RPM_BUILD_ROOT/usr/man/man1
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.png \
	$RPM_BUILD_ROOT/usr/share/pixmaps
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.desktop \
	$RPM_BUILD_ROOT/usr/share/applications


%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

%files
%defattr(-,root,root)
/usr/bin/qdvdauthor
/usr/bin/qslideshow
/usr/bin/dvd-slideshow
/usr/bin/dvd-menu
/usr/bin/gallery2slideshow
/usr/bin/jigl2slideshow
/usr/bin/dir2slideshow
/usr/man/man1/dvd-slideshow.1.gz
/usr/man/man1/dvd-menu.1.gz
/usr/man/man1/dir2slideshow.1.gz
/usr/man/man1/gallery2slideshow.1.gz
/usr/man/man1/jigl2slideshow.1.gz
/usr/share/pixmaps/qdvdauthor.png
/usr/share/applications/qdvdauthor.desktop
%doc README TODO COPYING CHANGELOG test/*.xml

%post

%preun

%changelog
* Tue Mar 09 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- updated dvd-slideshow to 0.5.4
- add dir2slideshow script & man page
- add gallery2slideshow man page
- add jigl2slideshow man page
- added sox to prerequisites (required by dvd-slideshow)
- removed redundant permissions attributes in files section (also bad form per Michael K. Johnson)
- added additional clean of build_root to top of install section
- removed clean of build_dir
* Tue Feb 17 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- changed qt requirement to 3.1
- fixed location of description section; dependencies weren't working
* Sun Feb 15 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- initial spec file
