/****************************************************************************
** ButtonPreview class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ButtonPreview from the FileSelection
** Dialog.
**
****************************************************************************/

#include <qlabel.h>
#include <qpopupmenu.h>
#include <qtextedit.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qdom.h>

#include "dialogtextfont.h"
#include "dialogbutton.h"
#include "buttonpreview.h"

ButtonPreview::ButtonPreview(QWidget * parent, const char * name, WFlags f)
	: QLabel (parent, name, f)
{
	m_pActiveObject = NULL;
	m_bMouseEventDone = false;
	m_qsCurrentPath = QString ("./");
}

ButtonPreview::~ButtonPreview()
{

}

void ButtonPreview::setCurrentPath(QString &qsCurrentPath)
{
	m_qsCurrentPath = qsCurrentPath;
}

void ButtonPreview::slotDeleteObject(MenuObject *pTheObject)
{
	m_listMenuObjects.remove(pTheObject);
	delete pTheObject;
	update ();
}

void ButtonPreview::addMenuObject(MenuObject *pNewObject)
{
	// Adds the menuObject to the list of MenuObjects.
	m_listMenuObjects.append(pNewObject);
}

void ButtonPreview::setViewport(QRect &rectViewport)
{
	m_rectViewport = rectViewport;
}

MenuObject *ButtonPreview::childContains (QPoint &pos)
{
	// Here we check if the mouse click appeared withtin one of the MenuObjects,
	// in which case the object will take over ...
	uint t;
	QPoint theCorrectedPos = pos;
	if (m_rectViewport.width() > 10)	{
		theCorrectedPos.setX(pos.x()-m_rectViewport.x());
		theCorrectedPos.setY(pos.y()-m_rectViewport.y());
	}

	for (t=0;t<m_listMenuObjects.count();t++)	{
		if (m_listMenuObjects.at(t)->contains (theCorrectedPos))	{
			return m_listMenuObjects.at(t);
		}
	}
	return NULL;
}

MenuObject *ButtonPreview::menuObject (uint iNr)
{
	if (iNr < m_listMenuObjects.count())
		return m_listMenuObjects.at(iNr);
	else 
		return NULL;
}
uint ButtonPreview::objectCount()
{
	return m_listMenuObjects.count();
}

void ButtonPreview::toTop(MenuObject *pObject)
{
	// This function pushes the currently selected child to the top of the stack as to draw it last (on the top).
	m_listMenuObjects.remove (pObject);
	m_listMenuObjects.append (pObject);
}

void ButtonPreview::mousePressEvent (QMouseEvent *pEvent)
{
	// Here we check if the mouse click appeared withtin one of the MenuObjects,
	// in which case the Object will take over the mouse handling ...
	QPoint thePos = pEvent->pos();
	MenuObject *pObject = childContains(thePos);
	if (pObject != NULL)	{
		m_bMouseEventDone = pObject->mousePressEvent(pEvent);
		// Here we protect the action toTop for creation of Buttons, which delete the returned pObject
		if (!m_bMouseEventDone)
			toTop(pObject);
	}
	
}

void ButtonPreview::mouseReleaseEvent (QMouseEvent *pEvent)
{
	// Here we check if the mouse click appeared withtin one of the MenuObjects,
	// in which case the object will take over ...
	QPoint thePos = pEvent->pos();
	MenuObject *pObject = childContains(thePos);
	if (pObject != NULL)
		m_bMouseEventDone = pObject->mouseReleaseEvent(pEvent);
}

void ButtonPreview::mouseDoubleClickEvent	(QMouseEvent *pEvent)
{
	// Here we check if the mouse click appeared withtin one of the buttons,
	// in which case the button will take over ...
	QPoint thePos = pEvent->pos();
	MenuObject *pObject = childContains(thePos);
	if (pObject != NULL)
		m_bMouseEventDone = pObject->mouseDoubleClickEvent(pEvent);
}

void ButtonPreview::drawContents(QPainter *painter)
{
	QLabel::drawContents (painter);
	// We use the viewport to draw the Object in the Center for the ButtonDialog.
	// The Viewport is ot used in the MenuPreview for te main window, thus drawing the button
	// on the right location ...
	if (m_rectViewport.width() > 10)
		painter->setViewport(m_rectViewport);
	// In case the user has not yet defined a background Image, we want to show the Objects anyways ...
	if (m_backgroundPixmap.isNull())	{
		uint t;
		erase(5, 5, width()-10, height()-10);
		for (t=0;t<m_listMenuObjects.count();t++)	{
			m_listMenuObjects.at(t)->drawContents (painter);
		}
		return;
	}
	if (m_pActiveObject)
		m_pActiveObject->drawContents(painter);
}

void ButtonPreview::setPixmap (const QPixmap &pixmap)
{
	// This is an overloaded function from QLabel
	// We are going to handle the double buffer here ...
	m_backgroundPixmap = pixmap;
	updatePixmap ();
}

void ButtonPreview::updatePixmap()
{
	uint t;
	if (m_backgroundPixmap.isNull())
		return;
	// Set the waiting cursor ...
	QCursor myCursor (QCursor::WaitCursor);
	setCursor(myCursor);

	// This is the function, which updates the background Pixmap
	QPixmap thePixmap(m_backgroundPixmap);
	QPainter thePainter(&thePixmap);
	for (t=0;t<m_listMenuObjects.count();t++)	{
//printf ("ButtonPreview::updatePixmap(%d)<%d><%d>\n", t, m_backgroundPixmap.width(),m_backgroundPixmap.height() );
		m_listMenuObjects.at(t)->drawContents (&thePainter);
	}
	setFixedSize(thePixmap.width(), thePixmap.height());
	QLabel::setPixmap (thePixmap);
	
	// re-set the cursor ...
	myCursor = QCursor(QCursor::ArrowCursor);
	setCursor(myCursor);
}

