/****************************************************************************
** DialogTextFont class
**
** Created: Tue Feb 18 22:48:00 2004
**      by: Varol Okan using Kate
**
**
****************************************************************************/
#include <qradiobutton.h>
#include <qcolordialog.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qpen.h>
//#include <qgroupbox.h>


#include "global.h"
#include "dialogframe.h"
/*
FramePreview::FramePreview(QWidget * parent, const char * name, WFlags f)
	: QFrame (parent, name, f)
{
	m_pDialogFrame = NULL;
}

FramePreview::~FramePreview()
{
}


void FramePreview::setDialog(DialogFrame *pDialog)
{
	m_pDialogFrame = pDialog;
}

void FramePreview::paintEvent(QPaintEvent *pPaintEvent)
{
	QFrame::paintEvent(pPaintEvent);
	m_pDialogFrame->drawPreview();
}
*/
DialogFrame::DialogFrame(QWidget * parent, const char * name, WFlags f)
	: uiDialogFrame (parent, name, f)
{
	m_iFrameWidth = 4;
	m_iFrameStyle = Qt::SolidLine;
	m_iFrameJoin  = Qt::MiterJoin;
	m_colorFrame  = QColor (START_FRAME_COLOR);
}

DialogFrame::~DialogFrame()
{
}

void DialogFrame::initMe(FrameObject *pFrame)
{
	// Here we continue with the standard initialization.
	m_pFrameColor->setPaletteBackgroundColor (pFrame->color());
	m_colorFrame = pFrame->color();
	m_iFrameWidth = pFrame->width();

	m_pEditX->setText     (QString ("%1").arg(pFrame->rect().x()));
	m_pEditY->setText     (QString ("%1").arg(pFrame->rect().y()));
	m_pEditWidth->setText (QString ("%1").arg(pFrame->rect().width()));
	m_pEditHeight->setText(QString ("%1").arg(pFrame->rect().height()));

	m_pComboStyle->insertItem (QString ("SolidLine"));
	m_pComboStyle->insertItem (QString ("DashLine"));
	m_pComboStyle->insertItem (QString ("DashDotLine"));
	m_pComboStyle->insertItem (QString ("DashDotDotLine"));
	
	m_pComboJoin->insertItem (QString ("MiterJoin"));
	m_pComboJoin->insertItem (QString ("BevelJoin"));
	m_pComboJoin->insertItem (QString ("RoundJoin"));

	connect (m_pButtonColor,   SIGNAL(clicked()), this, SLOT(slotColor()));
	connect (m_pButtonImage,   SIGNAL(clicked()), this, SLOT(slotImage()));
	connect (m_pButtonPicture, SIGNAL(clicked()), this, SLOT(slotPicture()));
	connect (m_pRadioImage,    SIGNAL(toggled(bool)), this, SLOT(slotImage(bool)));
	connect (m_pRadioPicture,  SIGNAL(toggled(bool)), this, SLOT(slotPicture(bool)));
	connect (m_pSpinBoxWidth,  SIGNAL(valueChanged(int)), this, SLOT(slotWidth(int)));
	connect (m_pComboStyle,    SIGNAL(highlighted(int)),  this, SLOT(slotStyle(int)));
	connect (m_pComboJoin,     SIGNAL(highlighted(int)),  this, SLOT(slotJoin(int)));

	drawPreview();
}

void DialogFrame::slotColor ()
{
	QColor transparentColor = QColor(TRANSPARENT_COLOR);
	QColor newColor = QColorDialog::getColor(transparentColor, this);
	if (!newColor.isValid())
		return;
	m_pFrameColor->setPaletteBackgroundColor(newColor);
	m_colorFrame = newColor;
	drawPreview();
}

void DialogFrame::slotImage()
{

}

void DialogFrame::slotPicture()
{

}

void DialogFrame::slotImage(bool)
{

}

void DialogFrame::slotPicture (bool)
{

}

void DialogFrame::slotWidth(int iNewValue)
{
	m_iFrameWidth = iNewValue;
	drawPreview();
}

void DialogFrame::slotJoin(int iNewValue)
{
	switch (iNewValue)	{
	case 1:
		m_iFrameJoin = Qt::BevelJoin;
	break;
	case 2:
		m_iFrameJoin = Qt::RoundJoin;
	break;
	default:
		m_iFrameJoin = Qt::MiterJoin;
	}
	drawPreview();
}

void DialogFrame::slotStyle(int iNewValue)
{
	switch (iNewValue)	{
	case 1:
		m_iFrameStyle = Qt::DashLine;
	break;
	case 2:
		m_iFrameStyle = Qt::DashDotLine;
	break;
	case 3:
		m_iFrameStyle = Qt::DashDotDotLine;
	break;
	default:
		m_iFrameStyle = Qt::SolidLine;
	}
	drawPreview();
}

void DialogFrame::drawPreview()
{
	//m_pPreview => QFrame
	QPainter thePainter (m_pPreview);
	QPen thePen (color(), frameWidth(), (Qt::PenStyle)style(), Qt::FlatCap, (Qt::PenJoinStyle)join());
	thePainter.setPen (thePen);
	thePainter.setBrush(Qt::NoBrush);
	m_pPreview->repaint();
//	m_pPreview->update();
	
	// Note: the drawing range is 32 pixels
	QRect theRect (16, 16, m_pPreview->width()-32, m_pPreview->height()-32);
	thePainter.drawRect (theRect);	
}

void DialogFrame::paintEvent (QPaintEvent *)
{
//	uiDialogFrame::paintEvent(pPainter);
	drawPreview ();
}

QColor DialogFrame::color()
{
	return m_colorFrame;
}

int DialogFrame::style()
{
	return m_iFrameStyle;
}

int DialogFrame::join()
{
	return m_iFrameJoin;
}

int DialogFrame::frameWidth()
{
	return m_iFrameWidth;
}

