/****************************************************************************
** menu.h file.
**
** This file handles the user input to generate a DVD menu.
** Please note that this is work in progress and depends also oin the
** developement of dvdauthor, which is at the moment in version 0.67.
** Future versions of dvdauthort might need changes to this file.
**
*****************************************************************************/
#include <stdlib.h>	// for system ()

#include <qdesktopwidget.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qpainter.h>
#include <qmenubar.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qcolor.h>
#include <qdom.h>

#include "qimagehelper.h"
#include "qdvdauthor.h"
#include "dvdmenu.h"
#include "dialogresize.h"
#include "menupreview.h"
#include "xml_dvd.h"
#include "dvdinfo.h"
#include "buttonobject.h"
#include "sourcefileentry.h"

//////////////////////////////////////////////////////////////
//
// The Interface class ...
//
//////////////////////////////////////////////////////////////

CDVDMenuInterface::CDVDMenuInterface ()
{
	bModified = false;
	bIsSubMenu = false;
	qsBackgroundFileName = QString ("");
	qsMenuName = QString (VMGM_LABEL);
	qsResizeAlgo = QString (QT_RESIZE_ALGO);
	iFormat = FORMAT_NONE;
	iWidth = 0;
	iHeight = 0;
	pgcColors[0] = QColor (TRANSPARENT_COLOR);
	pgcColors[1] = QColor (START_HIGHLIGHTED_COLOR);
	pgcColors[2] = QColor (START_SELECTED_COLOR);
	pgcColors[3] = QColor (START_FRAME_COLOR);
}

CDVDMenuInterface::~CDVDMenuInterface ()
{

}

///////////////////////////////////////////////
//
// This function loads the xml project file
// specified by the  user.
//
// The file specs are defined in xml_dvd.h
//
////////////////////////////////////////////////
bool CDVDMenuInterface::readProjectFile (QDomNode &theNode)
{
	QDomElement theElement;// = theNode.toElement();
	QString tagName;// = theElement.tagName();
	QString nodeText;// = theElement.text ();

	listSoundEntries.clear();
	QDomNode xmlMenuVariables = theNode.firstChild();
	while ( !xmlMenuVariables.isNull () )	{
		// Okay, here we retain the stored data from the xml file.
		theElement = xmlMenuVariables.toElement();
		tagName = theElement.tagName();
		nodeText = theElement.text ();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (tagName == MENU_HIGHLIGHTED_MASK)
			qsHighlightedMaskFileName = nodeText;
		else if (tagName == MENU_SELECTED_MASK)
			qsSelectedMaskFileName = nodeText;
		else if (tagName == MENU_SOUND)
			listSoundEntries.append (nodeText);
		else if (tagName == MENU_MOVIE)
			qsMovieFileName = nodeText;
		else if (tagName == MENU_BACKGROUND)	{
			QDomAttr a = theElement.attributeNode ( MENU_RESIZE_ALGO );
			qsResizeAlgo = a.value();
			if (qsResizeAlgo.isEmpty())
				qsResizeAlgo = QString ( QT_RESIZE_ALGO );
			qsBackgroundFileName = nodeText;
		}
		else if (tagName == MENU_MASK_COLORS)	{
			QStringList listColors = QStringList::split (",", nodeText);
			for (uint t=0;t<listColors.count();t++)	{
				QColor theColor (listColors[t]);
				pgcColors[t] = theColor;
			}
		}
		else if (tagName == MENU_NAME)
			qsMenuName = nodeText;
		// So lets get the next sibling ... until we hit hte end of DVDMenu ...
		xmlMenuVariables = xmlMenuVariables.nextSibling();
	}
	bModified = false;
	return true;
}

bool CDVDMenuInterface::writeProjectFile (QDomElement &rootDVDMenu)
{
	QDomDocument xmlDoc = rootDVDMenu.ownerDocument();

	uint i;
	QDomElement tag;
	QDomText t;
	if (!qsHighlightedMaskFileName.isEmpty())	{
		tag = xmlDoc.createElement( MENU_HIGHLIGHTED_MASK );
		rootDVDMenu.appendChild( tag );
		t = xmlDoc.createTextNode(qsHighlightedMaskFileName);
		tag.appendChild( t );
	}
	if (!qsSelectedMaskFileName.isEmpty())	{
		tag = xmlDoc.createElement( MENU_SELECTED_MASK );
		rootDVDMenu.appendChild( tag );
		t = xmlDoc.createTextNode(qsSelectedMaskFileName);
		tag.appendChild( t );
	}
	if (listSoundEntries.count() != 0)	{
		for (i=0;i<listSoundEntries.count();i++)	{
			tag = xmlDoc.createElement( MENU_SOUND );
			rootDVDMenu.appendChild( tag );
			t = xmlDoc.createTextNode(listSoundEntries[i]);
			tag.appendChild( t );
		}
	}
	if (!qsMovieFileName.isEmpty())	{
		tag = xmlDoc.createElement( MENU_MOVIE );
		rootDVDMenu.appendChild( tag );
		t = xmlDoc.createTextNode(qsMovieFileName);
		tag.appendChild( t );
	}
	if (!qsBackgroundFileName.isEmpty())	{
		tag = xmlDoc.createElement( MENU_BACKGROUND );
		rootDVDMenu.appendChild( tag );
		t = xmlDoc.createTextNode(qsBackgroundFileName);
		tag.setAttribute( MENU_RESIZE_ALGO, qsResizeAlgo );
		tag.appendChild( t );
	}
	if (!qsMenuName.isEmpty())	{
		tag = xmlDoc.createElement( MENU_NAME );
		rootDVDMenu.appendChild( tag );
		t = xmlDoc.createTextNode(qsMenuName);
		tag.appendChild( t );
	}
	// Here we take care of the mask colors
	QString qsColors;
	for (int t=0;t<MAX_MASK_COLORS;t++)
		qsColors += pgcColors[t].name() + ",";
	
	tag = xmlDoc.createElement ( MENU_MASK_COLORS );
	rootDVDMenu.appendChild    ( tag );
	t = xmlDoc.createTextNode  ( qsColors );
	tag.appendChild ( t );

	return true;
}

//////////////////////////////////////////////////////////////
//
// The Main class
//
//////////////////////////////////////////////////////////////

VMGMenu::VMGMenu ()
{
}

VMGMenu::VMGMenu (QDVDAuthor *pDVDAuthor)
	: DVDMenu (pDVDAuthor)
{
	CreateToolBar	(pDVDAuthor);
	CreateMenuEntry	(pDVDAuthor);
	slotUpdateStructure();
}

VMGMenu::~VMGMenu ()
{
	delete m_pDVDMenuMenu;
	delete m_pToolBar;

	delete m_pActionCreateDVD;
	delete m_pActionCreateSVCD;
	delete m_pActionCreateVCD;
	delete m_pActionRenameMenu;
	delete m_pActionDeleteMenu;
	delete m_pActionAddFrame;
	delete m_pActionAddText;
	delete m_pActionAddImage;
	delete m_pActionAddMovie;
	delete m_pActionAddBackground;
	delete m_pActionAddSound;
	delete m_pActionAddHighlightedMask;
	delete m_pActionAddSelectedMask;
}

void VMGMenu::CreateToolBar (QDVDAuthor *pDVDAuthor)
{
	QIconSet iconToDVD  = QIconSet (QPixmap::fromMimeSource( "to_dvd.png" ));
	QIconSet iconToVCD  = QIconSet (QPixmap::fromMimeSource( "to_vcd.png" ));
	QIconSet iconToSVCD = QIconSet (QPixmap::fromMimeSource( "to_svcd.png" ));
//	iconSet.setIconSize (QIconSet::Large, QSize (70, 70));
	iconToDVD.setIconSize (QIconSet::Small, QSize (70, 70));
	iconToVCD.setIconSize (QIconSet::Small, QSize (70, 70));
	iconToSVCD.setIconSize(QIconSet::Small, QSize (70, 70));
	// Create some action ...
	m_pActionCreateDVD  = new QAction( pDVDAuthor, "createDVD" );
	m_pActionCreateSVCD = new QAction( pDVDAuthor, "createSVCD" );
	m_pActionCreateVCD  = new QAction( pDVDAuthor, "createVCD" );
	m_pActionRenameMenu = new QAction( pDVDAuthor, "renameMenu" );
	m_pActionDeleteMenu = new QAction( pDVDAuthor, "deleteMenu" );
	m_pActionAddFrame   = new QAction( pDVDAuthor, "addFrame" );
	m_pActionAddText    = new QAction( pDVDAuthor, "addText" );
	m_pActionAddImage   = new QAction( pDVDAuthor, "addImage" );
	m_pActionAddMovie   = new QAction( pDVDAuthor, "addMovie" );	
	m_pActionAddBackground      = new QAction( pDVDAuthor, "addbackground" );
	m_pActionAddSound           = new QAction( pDVDAuthor, "addbackground" );
	m_pActionAddHighlightedMask = new QAction( pDVDAuthor, "addHMask" );
	m_pActionAddSelectedMask    = new QAction( pDVDAuthor, "addSMask" );	
	
	m_pActionCreateDVD->setIconSet( iconToDVD );
	m_pActionCreateDVD->setMenuText( tr( "&Create DVD" ) );
	m_pActionCreateDVD->setAccel( QString::null );
	m_pActionCreateSVCD->setIconSet( iconToSVCD );
	m_pActionCreateSVCD->setMenuText( tr( "&Create SVCD" ) );
	m_pActionCreateSVCD->setAccel( QString::null );
	m_pActionCreateVCD->setIconSet( iconToVCD );
	m_pActionCreateVCD->setMenuText( tr( "&Create VCD" ) );
	m_pActionCreateVCD->setAccel( QString::null );

	m_pActionRenameMenu->setMenuText( tr( "&Rename Menu" ) );
	m_pActionRenameMenu->setAccel( QString::null );
	m_pActionDeleteMenu->setMenuText( tr( "&Delete Menu" ) );
	m_pActionDeleteMenu->setAccel( QString::null );

	m_pActionAddFrame->setMenuText( tr( "Add &Frame" ) );
	m_pActionAddFrame->setAccel( QString::null );
	m_pActionAddText ->setMenuText( tr( "Add &Text" ) );
	m_pActionAddText ->setAccel( QString::null );
	m_pActionAddImage->setMenuText( tr( "Add &Image" ) );
	m_pActionAddImage->setAccel( QString::null );
	m_pActionAddMovie->setMenuText( tr( "Add &Movie" ) );
	m_pActionAddMovie->setAccel( QString::null );
	m_pActionAddBackground->setMenuText( tr( "Add &Background" ) );
	m_pActionAddBackground->setAccel( QString::null );
	m_pActionAddSound->setMenuText( tr( "Add &Sound" ) );
	m_pActionAddSound->setAccel( QString::null );
	m_pActionAddHighlightedMask->setMenuText( tr( "Add &Highlighted Mask" ) );
	m_pActionAddHighlightedMask->setAccel( QString::null );
	m_pActionAddSelectedMask->setMenuText( tr( "Add &Selected Mask" ) );
	m_pActionAddSelectedMask->setAccel( QString::null );

	// Here we create the ToolBar
	m_pToolBar = new QToolBar( "", pDVDAuthor, DockTop );

	m_pActionCreateDVD ->addTo( m_pToolBar );
////	m_pActionCreateSVCD->addTo( m_pToolBar );
////	m_pActionCreateVCD ->addTo( m_pToolBar );
//	m_pActionRenameMenu->addTo( m_pToolBar );
//	m_pActionDeleteMenu->addTo( m_pToolBar );
//	m_pToolBar->addSeparator();
//	m_pActionAddFrame->addTo( m_pToolBar );
//	m_pActionAddText ->addTo( m_pToolBar );
//	m_pActionAddImage->addTo( m_pToolBar );
//	m_pActionAddMovie->addTo( m_pToolBar );
//	m_pToolBar->addSeparator();
//	m_pActionAddBackground->addTo( m_pToolBar );
//	m_pActionAddSound->addTo( m_pToolBar );
//	m_pActionAddHighlightedMask->addTo( m_pToolBar );
//	m_pActionAddSelectedMask->addTo( m_pToolBar );
}

void VMGMenu::CreateMenuEntry (QDVDAuthor *pDVDAuthor)
{
	// menubar
	m_pDVDMenuMenu = new QPopupMenu( pDVDAuthor );
	m_pActionRenameMenu->addTo( m_pDVDMenuMenu );
	m_pActionDeleteMenu->addTo( m_pDVDMenuMenu );
	m_pDVDMenuMenu->insertSeparator();
	m_pActionAddFrame->addTo( m_pDVDMenuMenu );
	m_pActionAddText ->addTo( m_pDVDMenuMenu );
	m_pActionAddImage->addTo( m_pDVDMenuMenu );
	m_pActionAddMovie->addTo( m_pDVDMenuMenu );
	m_pDVDMenuMenu->insertSeparator();
	m_pActionAddBackground->addTo( m_pDVDMenuMenu );
	m_pActionAddSound->addTo( m_pDVDMenuMenu );
	m_pActionAddHighlightedMask->addTo( m_pDVDMenuMenu );
	m_pActionAddSelectedMask->addTo( m_pDVDMenuMenu );

	pDVDAuthor->menubar->insertItem(tr( "&DVDMenu"), m_pDVDMenuMenu, 0, 3 );

	// signals and slots connections
	connect( m_pActionCreateDVD,		SIGNAL( activated() ), pDVDAuthor, SLOT( slotCreateDVD() ) );
	connect( m_pActionCreateSVCD,		SIGNAL( activated() ), pDVDAuthor, SLOT( slotCreateSVCD()) );
	connect( m_pActionCreateVCD,		SIGNAL( activated() ), pDVDAuthor, SLOT( slotCreateVCD() ) );
	connect( m_pActionRenameMenu,		SIGNAL( activated() ), pDVDAuthor, SLOT( slotRenameCurrentSubMenu() ) );
	connect( m_pActionDeleteMenu,		SIGNAL( activated() ), pDVDAuthor, SLOT( slotRemoveCurrentSubMenu() ) );
	connect( m_pActionAddFrame,			SIGNAL( activated() ), this, SLOT( slotAddFrameObject() ) );
	connect( m_pActionAddText,			SIGNAL( activated() ), this, SLOT( slotAddTextObject() ) );
	connect( m_pActionAddImage,			SIGNAL( activated() ), this, SLOT( slotAddImageObject() ) );
	connect( m_pActionAddMovie,			SIGNAL( activated() ), this, SLOT( slotAddMovieObject() ) );
	connect( m_pActionAddBackground,		SIGNAL( activated() ), this, SLOT( slotAddBackground() ) );
	connect( m_pActionAddSound,			SIGNAL( activated() ), this, SLOT( slotAddSound() ) );
	connect( m_pActionAddHighlightedMask,	SIGNAL( activated() ), this, SLOT( slotAddHighlightedMask() ) );
	connect( m_pActionAddSelectedMask,	SIGNAL( activated() ), this, SLOT( slotAddSelectedMask() ) );
}

QToolBar *VMGMenu::getToolBar()
{
	return m_pToolBar;
}

QPopupMenu *VMGMenu::getPopupMenu ()
{
	return m_pDVDMenuMenu;
}

DVDMenu::DVDMenu ()
{
}

DVDMenu::DVDMenu (QDVDAuthor *pDVDAuthor)
	: QObject ()
{
	m_pDVDAuthor = pDVDAuthor;
	m_pDVDInfo   = NULL;
	CreateTab 	(pDVDAuthor->m_pTabWidgetMain);
	slotUpdateStructure ();
}

DVDMenu::~DVDMenu ()
{
	delete m_pDVDMenuTab;
}

DVDInfo *DVDMenu::getDVDInfo ()
{
	return m_pDVDInfo;
}

bool DVDMenu::readProjectFile  (QDomNode &theNode)
{
	
	QDomElement theElement = theNode.toElement();
	QString tagName;
	QString nodeText;
	
	QDomAttr a = theElement.attributeNode ( MENU_FORMAT );
	m_DVDMenuInterface.iFormat = a.value().toInt();
	a = theElement.attributeNode ( MENU_WIDTH );
	m_DVDMenuInterface.iWidth = a.value().toInt();
	a = theElement.attributeNode ( MENU_HEIGHT );
	m_DVDMenuInterface.iHeight = a.value().toInt();
//printf ("DVDMenu::readProjectFile <%s> - <%d><%d><%d>\n", (const char *)theElement.tagName(), m_DVDMenuInterface.iFormat, m_DVDMenuInterface.iWidth, m_DVDMenuInterface.iHeight);
	
	QDomNode xmlMenu = theNode.firstChild();
	while (!xmlMenu.isNull())	{
		// Okay, here we retain the stored data from the xml file.
		theElement = xmlMenu.toElement();
		tagName    = theElement.tagName();
		nodeText   = theElement.text ();

		if (DVDAUTHOR_MENU == tagName)	{
			// Let us take care of the DVDMenus properties first
			if (!m_DVDMenuInterface.readProjectFile(xmlMenu))
				return false;
// Might be wrong. I get the info for the SourceToolbar already through the SourceEntry.
//			if (m_pDVDAuthor)
//				m_pDVDAuthor->addSound(m_DVDMenuInterface.listSoundFiles);
		}
		else if (DVDAUTHOR_PREVIEW == tagName)	{
			// before we read in the infos in ButtonPreview::readProjectFile
			m_pPixmapMenu->readProjectFile (xmlMenu);
		}
		else
			printf ("Warning: DVDMenu::readProjectFile -=> wrong XML Node <%s>\nContinuing ...\n", (const char *)tagName);
		// So lets get the next sibling ... until we hit hte end of DVDMenu ...
		xmlMenu = xmlMenu.nextSibling();
	}
	if (!m_DVDMenuInterface.qsBackgroundFileName.isEmpty())
		addBackground (m_DVDMenuInterface.qsBackgroundFileName, &m_DVDMenuInterface.qsResizeAlgo);
	// If it is the Main Menu we are loading, we won't need to set the name.
	if (m_DVDMenuInterface.qsMenuName != QString (VMGM_LABEL))
		setTabLabel(m_DVDMenuInterface.qsMenuName);
	return true;
}

bool DVDMenu::writeProjectFile (QDomElement &rootElement)
{
	QDomDocument xmlDoc = rootElement.ownerDocument();
	QDomElement rootDVDMenu;
	if (m_DVDMenuInterface.bIsSubMenu)
		rootDVDMenu = xmlDoc.createElement( DVDAUTHOR_ROOT_MENU );
	else
		rootDVDMenu = xmlDoc.createElement( DVDAUTHOR_ROOT_VMGM );
	
	QDomElement dvdMenu = xmlDoc.createElement( DVDAUTHOR_MENU );
	QDomElement dvdPreview = xmlDoc.createElement( DVDAUTHOR_PREVIEW );

	// We set the Main menu attributes here ...
	rootDVDMenu.setAttribute ( MENU_FORMAT, QString("%1").arg(m_DVDMenuInterface.iFormat) );
	rootDVDMenu.setAttribute ( MENU_WIDTH,  QString("%1").arg(m_DVDMenuInterface.iWidth)  );
	rootDVDMenu.setAttribute ( MENU_HEIGHT, QString("%1").arg(m_DVDMenuInterface.iHeight) );
	
	// We encapsulate the Previe, and the DVDMenu variables from each other so the reading is uniform.
	rootDVDMenu.appendChild ( dvdMenu );
	rootDVDMenu.appendChild ( dvdPreview );
	rootElement.appendChild ( rootDVDMenu );

	// Okay, the main Node is created, now all DVDAuthor related information belon under it.
	if (!m_DVDMenuInterface.writeProjectFile( dvdMenu ))
		return false;
	return m_pPixmapMenu->writeProjectFile( dvdPreview );
}

void DVDMenu::slotAddFrameObject (bool bFinalDestiny)
{
	// Tricky using the same function for two different calls
	if (bFinalDestiny)	{
		if (m_pPixmapMenu)
			m_pPixmapMenu->slotAddFrameObject();
	}
	else	{
		DVDMenu *pMenu = m_pDVDAuthor->getCurrentSubMenu();
		if (pMenu)
			pMenu->slotAddFrameObject(true);
	}
}

void DVDMenu::slotAddTextObject  (bool bFinalDestiny)
{
	// Tricky using the same function for two different calls
	if (bFinalDestiny)	{
		if (m_pPixmapMenu)
			m_pPixmapMenu->slotAddTextObject();
	}
	else	{
		DVDMenu *pMenu = m_pDVDAuthor->getCurrentSubMenu();
		if (pMenu)
			pMenu->slotAddTextObject(true);
	}
}

void DVDMenu::slotAddImageObject (bool bFinalDestiny)
{
	// Tricky using the same function for two different calls
	if (bFinalDestiny)	{
		if (m_pPixmapMenu)
			m_pPixmapMenu->slotAddImageObject();
	}
	else	{
		DVDMenu *pMenu = m_pDVDAuthor->getCurrentSubMenu();
		if (pMenu)
			pMenu->slotAddImageObject(true);
	}
}

void DVDMenu::slotAddMovieObject (bool bFinalDestiny)
{
	// Tricky using the same function for two different calls
	if (bFinalDestiny)	{
		if (m_pPixmapMenu)
			m_pPixmapMenu->slotAddMovieObject();
	}
	else	{
		DVDMenu *pMenu = m_pDVDAuthor->getCurrentSubMenu();
		if (pMenu)
			pMenu->slotAddMovieObject(true);
	}
}

QString DVDMenu::name()
{
	return m_pDVDAuthor->m_pTabWidgetMain->tabLabel(m_pDVDMenuTab);
}

void DVDMenu::setTabLabel(QString &qsNewLabel)
{
	m_pDVDAuthor->m_pTabWidgetMain->setTabLabel (m_pDVDMenuTab, qsNewLabel);
	// Okay since we can not change the name of the VMGM, this ought to be a sub menu
	// As such we should enable the user to rename, or delete it.
	// Note: Rename, Delete is done in the QDVDAuthor - class
	m_pPixmapMenu->setIsSubMenu (true);
	m_DVDMenuInterface.bIsSubMenu = true;
}

void DVDMenu::modifyColor(uint iWhichColor, QColor theColor, bool bCalledFromDialog)
{
// printf ("DVDMenu::modifyColor <%d> <%d> <%s>\n", iWhichColor, bCalledFromDialog, (const char *)theColor.name());
	uint t;
	// This function is called from ColorToolbar click mouse event or from a ButtonObject ...
	// This function changes the colors according to the following rules :
	// tHERE ARE 4 colors available :
	// -	1 = Transparent color
	// -	2 = Highlighted color
	// -	3 = Selected color
	// -	4 = -=> FREE <=-
	
	// 1)	The first color change is associated to the 4'th color but only if the change comes from the dialog
	//		After all if the user clicks on the ColorToolbar then he should know what he is doing.
	// 2)	The second color change will affect all Buttons (Selected or Highlighted)
	//		a)	If only one ButtonObject in menu, then don't care
	//		b)	Else ask user to confirm
	//			-NO  : return
	//			-YES :  Go through all ButtonObjects of this menu and change this color
	//		c)	Change ColorToolbar ...
	//		d)	Change all ButtonObjects colors ...
	static bool bFirstModification = true;
	QValueList <ButtonObject *> listButtons = getButtons();
	
	if (bFirstModification && bCalledFromDialog)	{
		iWhichColor = MAX_MASK_COLORS - 1;
//		theColor = m_DVDMenuInterface.pgcColors[MAX_MASK_COLORS - 1];
		bFirstModification = false;
	}
	else if (listButtons.count () > 1)	{
		// Double check if the user really wants to affect all ButtonObjects.
		// This is done when we have more then one ButtonObject int this Menu ...
		QString qsWhichColor ("Highlighted");
		if (iWhichColor == SELECTED_MASK)
			qsWhichColor = QString ("Selected");

		if (QMessageBox::question ( NULL, tr("Change all colors ?"), tr("This modification will change will affect all %1 colors.\n"
			"Do you want to proceed ?").arg(qsWhichColor), QMessageBox::Yes, QMessageBox::No ) == QMessageBox::No)
			return;
	}
	
	// The next check is to ensure that we have a unique color.
	// In order to give the User control, I will simply bump up one color (red) by one bit
	for (t=0;t<MAX_MASK_COLORS;t++)	{
		if (m_DVDMenuInterface.pgcColors[t] == theColor)	{
			if (theColor.red() > 0)
				theColor.setRgb(theColor.red()-1, theColor.green(), theColor.blue());
			else
				theColor.setRgb(theColor.red()+1, theColor.green(), theColor.blue());
		}
	}

	QColor oldColor = m_DVDMenuInterface.pgcColors[iWhichColor];
	// Here we propagate the color change through all ButtonObjects.
	for (t=0;t<listButtons.count();t++)
		listButtons[t]->replaceColor (theColor, oldColor);
	// Next we set the color in the DVDMeniInterface (The most important one)
	m_DVDMenuInterface.pgcColors[iWhichColor] = theColor;
	// And finally we set the color in the m_pColorToolbar of DVDAuthor
	m_pDVDAuthor->setColor(iWhichColor, theColor);
}

// Standard initialization Functions.
void DVDMenu::CreateTab (QTabWidget *pTabWidgetMain)
{
	QPixmap backgroundPixmap = QPixmap::fromMimeSource (QString ("checkered.png"));

	m_pDVDMenuTab = new QWidget( pTabWidgetMain, "m_pDVDMenuTab" );
	m_pTabLayout = new QGridLayout( m_pDVDMenuTab, 1, 1, 11, 6, "m_pTabLayout");

	m_pLayout1 = new QGridLayout( 0, 1, 1, 0, 6, "m_pLayout1");
	m_pLayout2 = new QHBoxLayout( 0, 0, 6, "m_pLayout2");

	// Here we get the available screen resolution (all screens)
	// We want to keep the old style for resolutions above 1024x768 
	// But for lower res we need to use a scrollview to be able to
	// use QDVDAuthor.
	int iScreenWidth, iScreenHeight, iScreens, t;
	bool bUseScrollView = false;
	QScrollView *m_pScrollView = NULL;
	QDesktopWidget desktop;
	iScreenWidth = iScreenHeight = 0;
	iScreens = desktop.numScreens();
	for (t=0;t<iScreens;t++)	{
		iScreenWidth  += desktop.screenGeometry(t).width();
		iScreenHeight += desktop.screenGeometry(t).height();
	}

	if ( (iScreenHeight <= 768) || (iScreenWidth <= 1024) )	{
		bUseScrollView = true;
		// Here we embed the MenuPreview into a ScrollView object ...
		m_pScrollView = new QScrollView( m_pDVDMenuTab, "m_pScrollView", Qt::WNoAutoErase | Qt::WStaticContents); //| Qt::WPaintClever);
		m_pPixmapMenu = new MenuPreview (m_pScrollView, "m_pPixmapMenu", Qt::WNoAutoErase | Qt::WStaticContents);
	}
	else
		m_pPixmapMenu = new MenuPreview (m_pDVDMenuTab, "m_pPixmapMenu", Qt::WNoAutoErase | Qt::WStaticContents);

	m_pPixmapMenu->setFrameShape( QLabel::Box );
	m_pPixmapMenu->setFrameShadow( QLabel::Raised );
	m_pPixmapMenu->setLineWidth( 2 );
	m_pPixmapMenu->setMargin( 0 );
	m_pPixmapMenu->setScaledContents( TRUE );
	m_pPixmapMenu->setPaletteBackgroundPixmap (backgroundPixmap);
	m_pPixmapMenu->setCurrentPath(m_pDVDAuthor->currentPath());
	m_pPixmapMenu->initMe (m_DVDMenuInterface.pgcColors);
	
	if (bUseScrollView)	{
		m_pScrollView->addChild (m_pPixmapMenu);
		m_pPixmapMenu->resize(720, 480);
		m_pLayout1->addWidget( m_pScrollView, 0, 0 );
	}
	else
		m_pLayout1->addWidget( m_pPixmapMenu, 0, 0 );

	m_pButtonAddBackground = new QPushButton( m_pDVDMenuTab, "m_pButtonAddBackground" );
	m_pLayout2->addWidget( m_pButtonAddBackground );

	m_pButtonAddSound = new QPushButton( m_pDVDMenuTab, "m_pButtonAddSound" );
	m_pLayout2->addWidget( m_pButtonAddSound );

	m_pButtonShowHighlightedMask = new QPushButton( m_pDVDMenuTab, "m_pButtonAddHighlightedMask" );
	m_pLayout2->addWidget( m_pButtonShowHighlightedMask );

	m_pButtonShowSelectedMask = new QPushButton( m_pDVDMenuTab, "m_pButtonAddSelectedMask" );
	m_pLayout2->addWidget( m_pButtonShowSelectedMask );

	m_pLayout1->addLayout( m_pLayout2, 1, 0 );

	m_pTabLayout->addLayout( m_pLayout1, 0, 0 );
	// Insert the tab as the third from the back (xml/preview/subpictures are last).
	pTabWidgetMain->insertTab( m_pDVDMenuTab, QString(VMGM_LABEL), pTabWidgetMain->count()-3);

	m_pButtonAddBackground->setText( tr( "Add Background" ) );
	m_pButtonAddSound->setText( tr( "Add Sound" ) );
	m_pButtonShowHighlightedMask->setText( tr( "Show H-Layer" ) );
	m_pButtonShowSelectedMask->setText( tr( "Show S-Layer" ) );
	pTabWidgetMain->setCurrentPage (pTabWidgetMain->count()-4);

	connect( m_pButtonAddBackground, SIGNAL( clicked() ),       this, SLOT( slotAddBackground() ) );
	connect( m_pButtonAddSound, SIGNAL( clicked() ),            this, SLOT( slotAddSound() ) );
	connect( m_pButtonShowHighlightedMask, SIGNAL( clicked() ), this, SLOT( slotShowHighlightedMask() ) );
	connect( m_pButtonShowSelectedMask, SIGNAL( clicked() ),    this, SLOT( slotShowSelectedMask() ) );
	connect( m_pPixmapMenu, SIGNAL(signalUpdateStructure()),    this, SLOT( slotUpdateStructure() ) );
	connect( m_pPixmapMenu, SIGNAL(signalRequestSourceFiles()), this, SLOT( slotRequestSourceFiles() ) );
	connect( m_pPixmapMenu, SIGNAL(signalRequestSubMenus()),    this, SLOT( slotRequestSubMenus() ) );
	connect( m_pPixmapMenu, SIGNAL(signalDeleteMe()),   m_pDVDAuthor, SLOT( slotRemoveCurrentSubMenu() ) );
	connect( m_pPixmapMenu, SIGNAL(signalRenameMe()),   m_pDVDAuthor, SLOT( slotRenameCurrentSubMenu() ) );
	connect( m_pPixmapMenu, SIGNAL(signalMaskColorChanged(QColor, QColor)),this, SLOT(slotMaskColorChanged(QColor, QColor)));
}

void DVDMenu::slotMaskColorChanged(QColor theColor, QColor oldColor)
{
// printf ("DVDMenu::slotMaskColorChanged <%s> <%s>\n", (const char *)theColor.name(), (const char *)oldColor.name());
	// This function is called when the user changes the color of the 
	// Selected, or the Highlighted Mask from within the ButtonDialog.
	uint t, iWhichColor = MAX_MASK_COLORS - 1;
	for (t=0;t<MAX_MASK_COLORS;t++)	{
		if (m_DVDMenuInterface.pgcColors[t] == oldColor)	{
			iWhichColor = t;
			break;
		}
	}
	// The rest is handled in this function.
	modifyColor (iWhichColor, theColor, true);
}

// Public slots. Here are the main actors from the GUI.
void DVDMenu::slotAddBackground()
{
	QString qsFilter = m_pDVDAuthor->getImageFilter ();
	qsFilter += m_pDVDAuthor->getMovieFilter ();
	QString fileName = QFileDialog::getOpenFileName ( m_pDVDAuthor->currentPath(), QString ("Images/Movies (") + qsFilter + QString (")"));
	if (fileName.isNull())
		return;
	// FIXME:
	// replace through Xine/MPlayer - preview.
	QFileInfo backgroundInfo (fileName);
	if ( (backgroundInfo.extension() == QString ("mpg"))  ||
		 (backgroundInfo.extension() == QString ("mpeg")) ||
		 (backgroundInfo.extension() == QString ("avi")) )	{
		 m_DVDMenuInterface.qsMovieFileName = fileName;
		// Okay let us get the first frame of the game as a screenshot ...

/*		This is the commandline version 
*/		QString qsCommand;
		qsCommand = QString("transcode -i \"%1\" -c 1-2 -J smartdeinter -y jpg -F 100 -o \"%2/%3\" -x mplayer" ).arg(fileName).arg("/tmp/").arg(name());
		fileName = QString ("\"%1/%2000000.jpg\"").arg("/tmp/").arg(name());
printf ("<%s>\n<%s>\n\n", (const char *)qsCommand, (const char *)fileName);

		// transcode -i board.avi -c 110-111 -J smartdeinter -y jpg -F 100 -o board
		// puts frame No. 110 from DV board.avi into board0000.jpg
		// from transcode 0.6.12 www.transcoding.org
	}
	addBackground(fileName);
}

void DVDMenu::addBackground (QString &fileName, QString *pResizeAlgo)
{
	QString qsResizeAlgo(QT_RESIZE_ALGO);
	QFileInfo fileInfo  (fileName);
	QString qsPath = fileInfo.dirPath( TRUE );
	setCurrentPath( qsPath );

	QPixmap theBackground = QPixmap (fileName);
	// Now we check if the image has already the right format for PAL / NTSC / SECAM
	int iHeight = theBackground.height();
	int iWidth  = theBackground.width();
	int iFormat = getFormat (iWidth, iHeight);
	
	if ( (pResizeAlgo) && (iFormat == FORMAT_NONE) )	{
		// save some memory while doing all the resize work etc.
		theBackground = QPixmap (1,1);
		// Open the file to be resized ...
		int iResizeAlgorithm = 0;
		QImageHelper theFile (fileName, 0);
		// determine the algo ID which was stored as the name of the Algo ...
		QStringList listAvailAlgos = theFile.getAvailableResizeAlgorithms();
		for (uint t=0;t<listAvailAlgos.count();t++)	{
			if (listAvailAlgos[t] == *pResizeAlgo)
				iResizeAlgorithm = t;
		}
		// Set the vars. Note that we are sure at this point we have the vars in m_DVDMenuInterface
		// since we get here only from the readProjectFile () function.
		iWidth  = m_DVDMenuInterface.iWidth;
		iHeight = m_DVDMenuInterface.iHeight;
		// resize
		theFile.resize (iWidth, iHeight, iResizeAlgorithm);
		// and copy over ...
		theBackground = QPixmap (iWidth, iHeight);
		theBackground.convertFromImage (theFile);
	}
	else if (iFormat == FORMAT_NONE)	{
		int iReturn = QMessageBox::warning (NULL, tr ("Wrong IMAGE size"),
			tr ("This image is neither PAL, nor NTSC. For a DVD the size has to fit either :\n"
			"NTSC -> 720x480, 704x480, 352x480, 352x240 (29.97 Hz)\n"
			"PAL    -> 720x576, 704x576, 352x576, 352x288 (25 Hz)\n"
			"You need to resize this image sooner or later. Do you want to resize now ?"
			), QMessageBox::Yes ,  QMessageBox::No);
			if (iReturn == QMessageBox::Yes)	{
				// save some memory while doing all the resize work etc.
				theBackground = QPixmap (1,1);
				CResizeDialog *pResizeDialog = new CResizeDialog ();
				pResizeDialog->setFilename(fileName);
				pResizeDialog->exec ();
				iWidth  = pResizeDialog->m_pEditWidth ->text().toInt();
				iHeight = pResizeDialog->m_pEditHeight->text().toInt();
				iFormat = pResizeDialog->m_iFormat;
				if (iWidth < 1)
					iWidth = 720;
				if (iHeight < 1)
					iHeight = 480;
				qsResizeAlgo = pResizeDialog->comboResizeAlgorithm->currentText();
				theBackground = *pResizeDialog->m_pPixmapPreview->pixmap ();
			}
	}

	m_DVDMenuInterface.backgroundImage = theBackground;
	m_pPixmapMenu->setPixmap ( (const QPixmap &) theBackground);
//	m_pPixmapMenu->setPaletteBackgroundPixmap ( (const QPixmap &) theBackground);
	// And finally we set the interface (to store the dvd project file in DVDAuthor class)
	m_DVDMenuInterface.qsBackgroundFileName = fileName;
	m_DVDMenuInterface.iFormat              = iFormat;
	m_DVDMenuInterface.iWidth               = iWidth;
	m_DVDMenuInterface.iHeight              = iHeight;
	m_DVDMenuInterface.qsResizeAlgo         = qsResizeAlgo;
	m_DVDMenuInterface.bModified            = true;
	// Okay we should also add something to the QListView
//	if (! item exist deja ...) m_pListViewStructure
	if (!m_selectedMask.isNull())
		setMask (m_DVDMenuInterface.qsSelectedMaskFileName, SELECTED_MASK );
	if (!m_highlightedMask.isNull())
		setMask (m_DVDMenuInterface.qsHighlightedMaskFileName, HIGHLIGHTED_MASK );
	slotUpdateStructure ();

// Currently not what I wanted, so maybe later ...
//	QRect rectViewport (0, 0, iWidth, iHeight);
//	m_pPixmapMenu->setViewport(rectViewport);
}

void DVDMenu::slotAddSound()
{
	uint t, iCounter=0;
	SourceFileEntry *pEntry;
	for (t=0;t<m_DVDMenuInterface.listSoundEntries.count ();t++)	{
		if (m_pDVDAuthor)	{
			pEntry = m_pDVDAuthor->getSourceEntryByDisplayName(m_DVDMenuInterface.listSoundEntries[t]);
			if (!pEntry)
				break;
			iCounter += pEntry->listFileInfos.count();
		}
	}
	if (iCounter > 7)	{
		QMessageBox::warning (NULL, tr ("Too many sound files"),
			tr ("A DVD can at a maximum take 8 soundtracks.\n"), QMessageBox::Ok,  QMessageBox::NoButton);
		return;
	}
	QString qsFilter = m_pDVDAuthor->getSoundFilter ();

	QStringList listFileNames = QFileDialog::getOpenFileNames ( tr ("Sound Files (")+qsFilter+QString(")"), m_pDVDAuthor->currentPath());
	if (listFileNames.count() < 1)
		return;
	if (iCounter+listFileNames.count() > 7)	{
		QMessageBox::warning (NULL, tr ("Too many sound files"),
			tr ("A DVD can at a maximum take 8 soundtracks.\nI will only use the first %1 files.").arg(8-iCounter), QMessageBox::Ok,  QMessageBox::NoButton);
		QStringList listFileNames2 = listFileNames;
		listFileNames.clear ();
		for (t=0;t<8-iCounter;t++)
			listFileNames.append (listFileNames2[t]);
	}

	QFileInfo fileInfo  (listFileNames[0]);
	QString qsPath = fileInfo.dirPath ( TRUE );
	setCurrentPath( qsPath );

//	for (t=0;t<listFileNames.count();t++)
//		m_DVDMenuInterface.listSoundFiles.append (listFileNames[t]);
//	slotUpdateStructure ();
	if (m_pDVDAuthor)	{
		m_pDVDAuthor->addSound(listFileNames);
		// After we added the sound to the SourceToolBar I would like to add this here ...
		// The last one is the one just created.
		SourceFileEntry *pNewEntry = m_pDVDAuthor->sourceFileEntry(m_pDVDAuthor->sourceFileCount()-1);
		if (!pNewEntry)
			return;
		m_DVDMenuInterface.listSoundEntries.append (pNewEntry->qsDisplayName);
	}
	slotUpdateStructure ();
}

void DVDMenu::removeSourceEntry (QString &qsRemoveName)
{
	uint t, iRemoved;
	QStringList listButtonAction;
	QString qsTemp;
	QValueList<ButtonObject *> listButtons = getButtons();
	iRemoved = 0;
	// the first step is to remove all entries from the Interface (which
	// holds the list of the sound files).
	for (t=0;t<m_DVDMenuInterface.listSoundEntries.count();t++)	{
		qsTemp = m_DVDMenuInterface.listSoundEntries[t];
		if (qsTemp == qsRemoveName)
			iRemoved += m_DVDMenuInterface.listSoundEntries.remove (qsTemp);
	}

	// The second step is to check all button objects...
	qsTemp = QString ();
	for (t=0;t<listButtons.count();t++)	{
		// here we dwell into the buttons supposed action ...
		listButtonAction = QStringList::split(STRING_SEPARATOR,  listButtons[t]->action());
		if ( (listButtonAction.count() == 3) || (listButtonAction.count() == 4) )	{
			// Here we got ourself a button connected to something ...
			if (listButtonAction[1] == qsRemoveName)	{
				listButtons[t]->setAction(qsTemp);
				listButtons[t]->setSourceFileEntry(NULL);
				iRemoved ++;
			}
		}
	}

	if (iRemoved > 0)
		slotUpdateStructure ();
}

bool DVDMenu::isSourceEntryUsed (QString &qsInquireEntry)
{
	uint t;
	QString qsAction;
	QStringList listButtonAction;
	// This function is called when the user wants to delete a SourceFileEntry
	// it returns true if the entry is in use.

	// Two steps : The first is to check all entries in the DVDMenu->interface
	CDVDMenuInterface *pInterface = getInterface();
	for (t=0;t<pInterface->listSoundEntries.count();t++)	{
		if (pInterface->listSoundEntries[t] == qsInquireEntry)
			return true;
	}

	// The second step is to check all button objects...
	QValueList<ButtonObject *> listButtons = getButtons();
	for (t=0;t<listButtons.count();t++)	{
		// here we dwell into the buttons supposed action ...
		listButtonAction = QStringList::split(STRING_SEPARATOR,  listButtons[t]->action());
		if ( (listButtonAction.count() == 3) || (listButtonAction.count() == 4) )	{
			// Here we got ourself a button connected to something ...
			if (listButtonAction[1] == qsInquireEntry)
				return true;
		}
	}
	return false;
}

void DVDMenu::replaceSourceDisplayName (QString &qsOriginalDisplayName, QString &qsNewDisplayName)
{
	uint t;
	QString qsAction;
	// This function is called when the user changed the DisplayName of a SourceFileEntry
	// DialogMovie::accept()->SourceToolBar::slotEditMovie->QDVDAuthor::replaceSourceDisplayName()

	// Two steps : The first is to change all entries from the Interface ...
	CDVDMenuInterface *pInterface = getInterface();
	for (t=0;t<pInterface->listSoundEntries.count();t++)	{
		if (pInterface->listSoundEntries[t] == qsOriginalDisplayName)
			pInterface->listSoundEntries[t] = qsNewDisplayName;
	}

	// The second step is to go through all buttons and see what they are up to ...
	QValueList<ButtonObject *> listButtons = getButtons();
	QStringList listButtonAction;
	for (t=0;t<listButtons.count();t++)	{
		// here we dwell into the buttons supposed action ...
		listButtonAction = QStringList::split(STRING_SEPARATOR,  listButtons[t]->action());
		if ( (listButtonAction.count() == 3) || (listButtonAction.count() == 4) )	{
			// Here we got ourself a button connected to something ...
			if (listButtonAction[1] == qsOriginalDisplayName)	{
				listButtonAction[1] = qsNewDisplayName;
				qsAction = listButtonAction.join(STRING_SEPARATOR);
				listButtons[t]->setAction (qsAction);
			}
		}
	}
}

void DVDMenu::slotShowHighlightedMask()
{
	QMessageBox::warning (NULL, tr ("Feature missing"),
			tr ("This feature is not yet implemented.\n"), QMessageBox::Ok,  QMessageBox::NoButton);
}

void DVDMenu::slotShowSelectedMask()
{
	QMessageBox::warning (NULL, tr ("Feature missing"),
			tr ("This feature is not yet implemented.\n"), QMessageBox::Ok,  QMessageBox::NoButton);
}

void DVDMenu::slotAddHighlightedMask()
{
	QString qsFilter = m_pDVDAuthor->getImageFilter ();
	QString fileName = QFileDialog::getOpenFileName ( m_pDVDAuthor->currentPath(), tr ("Images (")+qsFilter+QString(")"));
	if (fileName.isNull())
		return;

	QFileInfo fileInfo  (fileName);
	QString qsPath = fileInfo.dirPath ( TRUE );
	setCurrentPath( qsPath );

	m_DVDMenuInterface.qsHighlightedMaskFileName = fileName;
	setMask(fileName, HIGHLIGHTED_MASK);
}

void DVDMenu::slotAddSelectedMask()
{
	QString qsFilter = m_pDVDAuthor->getImageFilter ();
	QString fileName = QFileDialog::getOpenFileName ( m_pDVDAuthor->currentPath(), tr ("Images (")+qsFilter+QString(")"));
	if (fileName.isNull())
		return;

	QFileInfo fileInfo  (fileName);
	QString qsPath = fileInfo.dirPath ( TRUE );
	setCurrentPath ( qsPath );
	
	m_DVDMenuInterface.qsSelectedMaskFileName = fileName;
	setMask(fileName, SELECTED_MASK);
}

void DVDMenu::setCurrentPath (QString &qsPath, bool bComesFromDVDAuthor)
{
	// This check is necessary otherwise we would be in a infinite loop ...
	// Meaning if it comes from QDVDAuthor::setCurrentPath, we wont go back there ...
	if (!bComesFromDVDAuthor)
		m_pDVDAuthor->setCurrentPath( qsPath );
	m_pPixmapMenu->setCurrentPath( qsPath );
}

void DVDMenu::setMask (QString & fileName, uint iWhichMask)
{
//	QImage theImage = QImage (fileName, 0);
	QImageHelper theMask (fileName, 0);
	// Sanity check ...
	uint iColorCount = theMask.countColors (); //theMask);
//printf ("iColorCount=%d\n", iColorCount);
	if ( iColorCount > MAX_MASK_COLORS )	{
		int iReturn = QMessageBox::warning (NULL, tr ("Image has too many colors"),
			tr ("This mask has too many colors. Only 4 colors are allowed for the mask.\n\n"
			"Do you want to decrease the number of colors to 4 ?"
			), QMessageBox::Yes ,  QMessageBox::No);
			if (iReturn == QMessageBox::Yes)
				theMask.dither (MAX_MASK_COLORS);
	}
	//

	// Dialog to choose the transparent color from ...

	//

	// Here we ensure that there is a background Image present.
	if (m_DVDMenuInterface.backgroundImage.isNull())	{
		displayMask(iWhichMask);
		slotUpdateStructure();
		return;
	}

	QImage theBackground = m_DVDMenuInterface.backgroundImage.convertToImage();
	int x, y, xMax, yMax;
	QRgb thePixel, theMaskColor = 0x00000000;
	// Here is the algol, to filter out the transparent background color of the mask
	// and overlay the remaining pixel to the background.

	// This test is to ensure that the smallest dimensions are taken from both images.
	xMax = (theMask.width () < theBackground.width ()) ? theMask.width () : theBackground.width ();
	yMax = (theMask.height() < theBackground.height()) ? theMask.height() : theBackground.height();

	theMaskColor = theMask.getMaskColor ();

	for (y=0;y<yMax;y++)	{
		for (x=0;x<xMax;x++)	{
			thePixel = theMask.pixel(x, y);
//			if ( (thePixel != theMaskColor) && (thePixel != 0xff000000) )
			if (thePixel != theMaskColor)
				theBackground.setPixel (x, y, thePixel);
		}
	}

	if (iWhichMask == SELECTED_MASK)	{
		m_selectedMask.convertFromImage ( theBackground );
		// and then we should keep the mask itself as well (remember we might have changed the color depth).
		m_DVDMenuInterface.selectedMask = theMask;
	}
	else if (iWhichMask == HIGHLIGHTED_MASK)	{
		m_highlightedMask.convertFromImage ( theBackground );
		m_DVDMenuInterface.highlightedMask = theMask;
	}

	displayMask (iWhichMask);
	slotUpdateStructure ();
}

void DVDMenu::createMask(QString &qsFileName, int iWhichMask)
{
	// Called from QDVDAuthor::createDVD()
	uint t;
	// This function is called from QDVDAuthor::createMenuXml() and will first create the
	// 4 colored mask and then store it to a file.
	QPixmap theMask;
	QPainter thePainter;
	ButtonObject *pButton, tempButton;

	switch (iWhichMask)	{
	case BACKGROUND_IMG:
		// The background image is generated by using the background and overlaying all MenuObject
		theMask = QPixmap (m_DVDMenuInterface.backgroundImage);
	break;
	case HIGHLIGHTED_MASK:
		theMask = QPixmap (m_DVDMenuInterface.backgroundImage.width(), m_DVDMenuInterface.backgroundImage.height());
		theMask.fill (QColor (TRANSPARENT_COLOR));
	break;
	case SELECTED_MASK:
		theMask = QPixmap (m_DVDMenuInterface.backgroundImage.width(), m_DVDMenuInterface.backgroundImage.height());
		theMask.fill (QColor (TRANSPARENT_COLOR));
	break;
	}
	// Here we draw the appropriate mask.
	thePainter.begin(&theMask);
	for (t=0;t<m_pPixmapMenu->objectCount();t++)	{
		if (iWhichMask == BACKGROUND_IMG)
			m_pPixmapMenu->menuObject(t)->drawContents(&thePainter);
		else if (m_pPixmapMenu->menuObject(t)->objectType() == tempButton.objectType())	{
			pButton = (ButtonObject *)m_pPixmapMenu->menuObject(t);
			pButton->drawContents(&thePainter, iWhichMask);
		}
	}
	// Okay all's in, so we should be good to write to the temp drive ...
	thePainter.end();
	if (iWhichMask == BACKGROUND_IMG)	{
		theMask.save(qsFileName, "JPEG", 100);
		return;
	}
	QImageHelper theImage((const QImageHelper &)theMask.convertToImage());
/*	This is no longer necessarfy due to the new color handling, the Mask automgically possess the correct colors ...
	switch (iWhichMask)	{
	case HIGHLIGHTED_MASK:
		m_DVDMenuInterface.pgcColors[1] = theImage.getMaskColor();
	break;
	case SELECTED_MASK:
		m_DVDMenuInterface.pgcColors[2] = theImage.getMaskColor();
	break;
	}
*/
	theImage.dither (MAX_MASK_COLORS, m_DVDMenuInterface.pgcColors);
//	theImage.dither (2, false);

	theImage.save (qsFileName, "PNG", 100);
}

QColor DVDMenu::getColor (int iNumber)
{
	return m_DVDMenuInterface.pgcColors[iNumber];
}

QValueList<ButtonObject *> &DVDMenu::getButtons()
{
	static QValueList<ButtonObject *> listReturn;
	listReturn.clear();
	ButtonObject tempButton;
	uint t;
	for (t=0;t<m_pPixmapMenu->objectCount();t++)	{
		if (m_pPixmapMenu->menuObject(t)->objectType() == tempButton.objectType())	{
			listReturn.append((ButtonObject *)m_pPixmapMenu->menuObject(t));
		}
	}
	return listReturn;
}

QValueList<SourceFileEntry *> &DVDMenu::getSourceFileEntries()
{
	static QValueList<SourceFileEntry *> listReturn;
	listReturn.clear();
	ButtonObject tempButton;
	ButtonObject *pButton;
	uint t;
	for (t=0;t<m_pPixmapMenu->objectCount();t++)	{
		if (m_pPixmapMenu->menuObject(t)->objectType() == tempButton.objectType())	{
			pButton = (ButtonObject *)m_pPixmapMenu->menuObject(t);
			listReturn.append(pButton->sourceFileEntry());
		}
	}
	return listReturn;
}

void DVDMenu::displayMask (uint iWhichMask)
{
	QPixmap *pMask;
	pMask = &m_highlightedMask;
	if (iWhichMask == SELECTED_MASK)
		pMask = &m_selectedMask;
	else if (iWhichMask == BACKGROUND_IMG)
		pMask = &m_DVDMenuInterface.backgroundImage;
	if (pMask->isNull())
		return;
	// And finally set the pixmap back again ...
	m_pPixmapMenu->setPixmap(*pMask);
}
/*
void DVDMenu::displayMask (uint iWhichMask)
{
printf ("DisplayMask <%d>\n", iWhichMask);
	// Here is the algol, to filter out the transparent background color of the mask
	// and overlay the remaining pixel to the background.
	QImage theBackground = QImage (m_DVDMenuInterface.qsBackgroundFileName);
	int x, y, xMax, yMax;
	QRgb thePixel, theMaskColor = 0x00000000;
	QPixmap oldPixmap;
	QImage *pMask;

	pMask = &m_DVDMenuInterface.highlightedMask;
	if (iWhichMask == SELECTED_MASK)
		pMask = &m_DVDMenuInterface.selectedMask;
	else if (iWhichMask == BACKGROUND_IMG)	{
		oldPixmap.convertFromImage ( theBackground );
		// And finally set the pixmap back again ...
		m_pPixmapMenu->setPixmap(oldPixmap);
		return;
	}

	// This test is to ensure that the smallest dimensions are taken from both images.
	xMax = (pMask->width () < theBackground.width ()) ? pMask->width () : theBackground.width ();
	yMax = (pMask->height() < theBackground.height()) ? pMask->height() : theBackground.height();

	// Here we set all pixels accordingly. If the mask's background color
	QImageHelper theImage (*pMask);
	QColor colorBackground = theImage.getBackgroundColor ();
	// Sanity check ...
	uint iColorCount = theImage.countColors (theImage);

	for (y=0;y<yMax;y++)	{
		for (x=0;x<xMax;x++)	{
			thePixel = pMask->pixel(x, y);
			if ( (thePixel != theMaskColor) && (thePixel != 0xff000000) )
				theBackground.setPixel (x, y, thePixel);
		}
	}
	oldPixmap.convertFromImage ( theBackground );
	// And finally set the pixmap back again ...
	m_pPixmapMenu->setPixmap(oldPixmap);
}

*/
void DVDMenu::slotStructureClicked(QListViewItem *pItem)
{
	if (!pItem)
		return;
	// Next we check if the user actually clicked on a BACKGROUND,HIGHLIGHTED, or SELECTED Mask of this Menu
	// Note: the Name of the Menu ought to be unique !!!
	if (pItem->text(0) == tr ("Background"))	{
		if (pItem->parent()->text(1) == m_DVDMenuInterface.qsMenuName)
			displayMask (BACKGROUND_IMG);	
	}
	else if (pItem->text(0) == tr (" Highlighted"))	{
		if (pItem->parent()->parent()->text(1)  == m_DVDMenuInterface.qsMenuName)
			displayMask (HIGHLIGHTED_MASK);
	}
	else if (pItem->text(0) == tr (" Selected"))	{
		if (pItem->parent()->parent()->text(1)  == m_DVDMenuInterface.qsMenuName)
			displayMask (SELECTED_MASK);
	}
}

/*
void DVDMenu::slotCreateMenu()
{
	// This function is invoked when the user wants to create the menu structure.
	// THus this function does the following
	// create /tmp/spumux.xml
	// create /tmp/dvdauthor.xml
	// invoke spumux -> output to dialog
	// invoke dvdauthor, but use dummy vob files rather then the original (hiuge) ones.
	createMenuXml ();		// /tmp/spumux.xml
	createDvdauthorXml ();	// /tmp/dvdauthor.xml
	// And then we create the script to generate all those funcky files ...
	createDVD ();
}
*/
int DVDMenu::getFormat (int iWidth, int iHeight)
{
	int iFormat = FORMAT_NONE;
	if ((iWidth == 720) && (iHeight == 480) )
		iFormat = FORMAT_NTSC1;
	else if  ((iWidth == 704) && (iHeight == 480) )
		iFormat = FORMAT_NTSC2;
	else if  ((iWidth == 352) && (iHeight == 480) )
		iFormat = FORMAT_NTSC3;
	else if  ((iWidth == 352) && (iHeight == 240) )
		iFormat = FORMAT_NTSC4;
	else if  ((iWidth == 720) && (iHeight == 576) )
		iFormat = FORMAT_PAL1;
	else if ((iWidth == 704) && (iHeight == 576) )
		iFormat = FORMAT_PAL2;
	else if  ((iWidth == 352) && (iHeight == 576) )
		iFormat = FORMAT_PAL3;
	else if  ((iWidth == 352) && (iHeight == 288) )
		iFormat = FORMAT_PAL4;
	return iFormat;
}

CDVDMenuInterface * DVDMenu::getInterface ()
{
	return &m_DVDMenuInterface;
}

QDVDAuthor *DVDMenu::getDVDAuthor ()
{
	return m_pDVDAuthor;
}

// This slot is called when the DialogButton is created (in MenuPreview, or ButtonObject)
void DVDMenu::slotRequestSourceFiles()
{
	int t;
	int iSourceFileCount = m_pDVDAuthor->sourceFileCount();
	// Let us get the actual list of Source files ...
	QValueList<SourceFileEntry *> listSourceFileEntries;
	for (t=0;t<iSourceFileCount;t++)
		listSourceFileEntries.append(m_pDVDAuthor->sourceFileEntry(t));
	m_pPixmapMenu->respondSourceFiles (listSourceFileEntries);
}

// This slot is called when the DialogButton is created (in MenuPreview, or ButtonObject)
void DVDMenu::slotRequestSubMenus()
{
	uint t;
	static QStringList listSubMenus;
	listSubMenus.clear();
	QValueList<DVDMenu *> listDVDMenus = m_pDVDAuthor->getSubMenus();
	
	for (t=0;t<listDVDMenus.count();t++)	{
		listSubMenus.append (listDVDMenus[t]->name());
	}
	m_pPixmapMenu->respondSubMenus(listSubMenus);
}

// This function is called when the user loads a new project file
void DVDMenu::updateDVDMenu ()
{
	// Check if we already have background specified ...
	if (m_DVDMenuInterface.qsBackgroundFileName.isEmpty())
		return;
	// If we have, then lets check if the file exists.
	QFileInfo fileInfo (m_DVDMenuInterface.qsBackgroundFileName);
	if (!fileInfo.exists())	{
		QMessageBox::warning (NULL, tr ("File not found !"),
			tr ("Warning, could not find file %1.").arg(m_DVDMenuInterface.qsBackgroundFileName), QMessageBox::Ok ,  QMessageBox::Cancel);
		return;
	}
	// Create empty pixmap.
	QPixmap theBackground (m_DVDMenuInterface.iWidth, m_DVDMenuInterface.iHeight);
	// Load the image
	QImage theFile = QImage (m_DVDMenuInterface.qsBackgroundFileName, 0);
	theBackground.convertFromImage (theFile.smoothScale(m_DVDMenuInterface.iWidth, m_DVDMenuInterface.iHeight));

	m_pPixmapMenu->setFixedSize (m_DVDMenuInterface.iWidth, m_DVDMenuInterface.iHeight);
	m_pPixmapMenu->setPixmap ( (const QPixmap &) theBackground);
}

void DVDMenu::slotUpdateStructure ()
{
	if (m_pDVDAuthor)
		m_pDVDAuthor->slotUpdateStructure();
}

QListViewItem *DVDMenu::createStructure (QListViewItem *pMainItem)
{
	QListViewItem *pMainMenuItem;
	QListViewItem *pMenuItem;
	QListViewItem *pMaskItem;
	QListViewItem *pButtonItem;

	pMainMenuItem = new QListViewItem(pMainItem, m_DVDMenuInterface.qsMenuName);
	pMainMenuItem->setExpandable (TRUE);
	pMainMenuItem->setOpen (TRUE);

	// Last things first ...
	pMenuItem = new QListViewItem(pMainMenuItem, tr ("Specified Buttons"));
	pMenuItem->setExpandable (TRUE);
	pMenuItem->setOpen (TRUE);

	uint t, iCountButtons = 0;
	ButtonObject tempButton;
	MenuObject *pObject;
	// Duh, the last Button's first ... how strangely dumb ...
	for (t=m_pPixmapMenu->objectCount();t>0;t--)	{
		pObject = m_pPixmapMenu->menuObject(t-1);
		if (pObject->objectType() == tempButton.objectType())	{
			pObject->createStructure (pMenuItem);
			iCountButtons ++;
		}
	}
	// If there were no buttons, then we don't need to show this in the structure ...
	if (!iCountButtons)
		delete pMenuItem;

	// The second time we go through the list of menuObjects we take everything in the order we receive it ...
	for (t=m_pPixmapMenu->objectCount();t>0;t--)	{
		pObject = m_pPixmapMenu->menuObject(t-1);
		if (pObject->objectType() != tempButton.objectType())	{
			pObject->createStructure (pMainMenuItem);
		}
	}

	// Here is the rest of the Main Menu ...
	QString qsFileName, qsName;
	if ( (!m_DVDMenuInterface.qsHighlightedMaskFileName.isEmpty()) || (!m_DVDMenuInterface.qsSelectedMaskFileName.isEmpty()) )	{
		qsFileName = QFileInfo (m_DVDMenuInterface.qsHighlightedMaskFileName).fileName ();
		pMaskItem = new QListViewItem(pMainMenuItem, tr ("Button Masks"), qsFileName);
		pMaskItem->setExpandable (TRUE);

			qsFileName = QFileInfo (m_DVDMenuInterface.qsHighlightedMaskFileName).fileName ();
			pMenuItem = new QListViewItem(pMaskItem, tr (" Highlighted"), qsFileName);
			pMenuItem->setExpandable (TRUE);
			qsName = tr ("to images");
			pButtonItem = new QListViewItem(pMenuItem, tr ("Button 1"), qsName);
			pButtonItem->setExpandable (TRUE);
				new QListViewItem(pButtonItem, tr ("Geometry"), QString ("22, 23, 50, 100"));


// Here is the info for the Selected Mask
			qsFileName = QFileInfo (m_DVDMenuInterface.qsSelectedMaskFileName).fileName ();
			pMenuItem = new QListViewItem(pMaskItem, tr (" Selected"), qsFileName);
			pMenuItem->setExpandable (TRUE);
			qsName = tr ("to images");
			pButtonItem = new QListViewItem(pMenuItem, tr ("Button 1"), qsName);
			pButtonItem->setExpandable (TRUE);
				new QListViewItem(pButtonItem, tr ("Geometry"), QString ("22, 23, 50, 100"));
	}
//printf ("<%d>\n", m_DVDMenuInterface.listSoundFiles.count());
	for (t=m_DVDMenuInterface.listSoundEntries.count();t>0;t--)	{
		qsFileName = QFileInfo (m_DVDMenuInterface.listSoundEntries[t-1]).fileName ();
		new QListViewItem(pMainMenuItem, tr ("Sound file(s) %1").arg(t-1), qsFileName);
	}
	if (!m_DVDMenuInterface.qsBackgroundFileName.isEmpty())	{
		qsFileName = QFileInfo (m_DVDMenuInterface.qsBackgroundFileName).fileName ();
		new QListViewItem(pMainMenuItem, tr ("Background"), qsFileName);
	}
	return pMainMenuItem;
}

