/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef MENU_H
#define MENU_H

#include <qobject.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtoolbar.h>
#include <qpopupmenu.h>
#include <qaction.h>
#include <qimage.h>
#include <qdom.h>

#include "global.h"
#include "qdvdauthor.h"

#define VMGM_LABEL "Main Menu VMGM"

class MenuPreview;
class ButtonObject;
class SubMenus;
class DVDInfo;

// Container class to encapsulate all variables for the DVDMenu - class
class CDVDMenuInterface
{
public:
	 CDVDMenuInterface ();
	~CDVDMenuInterface ();

	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	// variables.
	bool bModified;
	bool bIsSubMenu;
	QString qsMenuName;
//	QStringList listSoundFiles;
	QStringList listSoundEntries;
	QString qsMovieFileName;
	QString qsBackgroundFileName;
	QString qsSelectedMaskFileName;
	QString qsHighlightedMaskFileName;
	QString qsResizeAlgo;
	int iFormat;
	int iWidth;
	int iHeight;

	QPixmap backgroundImage;
	QPixmap highlightedMask;
	QPixmap selectedMask;
	QColor  pgcColors[MAX_MASK_COLORS];
};

class DVDMenu : public QObject
{
	Q_OBJECT
protected:
	 DVDMenu ();
public:
	// Constructor / destructor
	 DVDMenu (QDVDAuthor *pDVDAuthor);
	~DVDMenu ();

public slots:
	virtual void slotAddBackground      ();
	virtual void slotAddSound           ();
	virtual void slotShowHighlightedMask();
	virtual void slotShowSelectedMask   ();
	virtual void slotAddHighlightedMask ();
	virtual void slotAddSelectedMask    ();
	virtual void slotStructureClicked   (QListViewItem *);
	virtual void slotUpdateStructure    ();
	virtual void slotRequestSourceFiles ();
	virtual void slotRequestSubMenus    ();
	virtual void slotMaskColorChanged   (QColor, QColor);
	// The following functions will only reach the request through from the QDVDAuthor - class
	// to m_pPixmapMenu. Neccessary bc in mainMenubar the entries are valid for all SubMenus !!!
	virtual void slotAddFrameObject (bool b=false);
	virtual void slotAddTextObject  (bool b=false);
	virtual void slotAddImageObject (bool b=false);
	virtual void slotAddMovieObject (bool b=false);

public:	// public functions
	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	CDVDMenuInterface * getInterface ();
	void updateDVDMenu();
	QDVDAuthor *getDVDAuthor ();
	void createMask(QString &, int);
	QValueList<ButtonObject *> &getButtons();
	void setTabLabel(QString &);
	QListViewItem *createStructure (QListViewItem *);
	QString name ();
	QValueList<SourceFileEntry *> &getSourceFileEntries();
	void setCurrentPath (QString &, bool b=false);
	DVDInfo *getDVDInfo();
	int getFormat (int iWidth, int iHeight);
	QColor getColor (int);
	void removeSourceEntry (QString &);
	bool isSourceEntryUsed (QString &);
	void replaceSourceDisplayName (QString &, QString &);
	void modifyColor(uint , QColor, bool = false);


protected: // Private functions ...
	void CreateTab (QTabWidget *pTabWidgetMain);
	void addBackground(QString &, QString *p=NULL);

protected:
	// helper functions ...
	void setMask (QString &, uint);
	void displayMask (uint);

protected:
	QWidget		*m_pDVDMenuTab;
	QGridLayout	*m_pTabLayout;
	QGridLayout	*m_pLayout1;
	QHBoxLayout	*m_pLayout2;
	MenuPreview	*m_pPixmapMenu;

	QPushButton	*m_pButtonAddBackground;
	QPushButton	*m_pButtonAddSound;
	QPushButton	*m_pButtonShowHighlightedMask;
	QPushButton	*m_pButtonShowSelectedMask;

	CDVDMenuInterface m_DVDMenuInterface;
	QDVDAuthor	*m_pDVDAuthor;
	DVDInfo		*m_pDVDInfo;

	QPixmap m_highlightedMask;
	QPixmap m_selectedMask;
};

class VMGMenu : public DVDMenu
{
	Q_OBJECT
	 VMGMenu ();
public:
	 VMGMenu (QDVDAuthor *pDVDAuthor);
	~VMGMenu ();

	QToolBar   *getToolBar   ();
	QPopupMenu *getPopupMenu ();

private:	// Private member functions ...
	void CreateToolBar (QDVDAuthor *pDVDAuthor);
	void CreateMenuEntry (QDVDAuthor *pDVDAuthor);

private:
	// Here are the private member actions ...
	QAction *m_pActionCreateDVD;
	QAction *m_pActionCreateSVCD;
	QAction *m_pActionCreateVCD;
	QAction *m_pActionRenameMenu;
	QAction *m_pActionDeleteMenu;
	QAction *m_pActionAddFrame;
	QAction *m_pActionAddText;
	QAction *m_pActionAddImage;
	QAction *m_pActionAddMovie;
	QAction *m_pActionAddBackground;
	QAction *m_pActionAddSound;
	QAction *m_pActionAddHighlightedMask;
	QAction *m_pActionAddSelectedMask;

	QToolBar *m_pToolBar;
	QPopupMenu *m_pDVDMenuMenu;
};

#endif // MENU_H
