/****************************************************************************
** menu.h file.
**
** This file handles the user input to generate a DVD menu.
** Please note that this is work in progress and depends also on the
** developement of dvdauthor, which is at the moment in version 0.67.
** Future versions of dvdauthor might need changes to this file.
**
*****************************************************************************/

#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "execute.h"
#include "global.h"

#include <qthread.h>
#include <qvariant.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qtimer.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qsplitter.h>
#include <qfiledialog.h>


// Add another button, to keep the GUI open, rather then close it.
// Add another text line with the command executed on the top
// Add text, close ins x seconds ...


Execute::Execute ( QObject * parent, const char * name)
	: QProcess (parent, name)
{
	initMe();
}

Execute::Execute ( const QString & arg0, QObject * parent, const char * name)
	: QProcess (arg0, parent, name)
{
	initMe ();
}

Execute::Execute ( const QStringList & args, QObject * parent, const char * name)
	: QProcess (args, parent, name)
{
	initMe ();
}

Execute::~Execute ()
{

}

void Execute::setPaths(QString qsProjectPath, QString qsTempPath)
{
	if (!qsProjectPath.isEmpty())
		m_qsProjectPath = qsProjectPath;
	if (!qsTempPath.isEmpty())
		m_qsTempPath = qsTempPath;
}

void Execute::initMe ()
{
	m_iMaxWait = 10;
	m_iSeconds = 15;
	m_iCurrentCommand = 0;
	m_pDialog = NULL;
	m_qsTempPath=QString ("/tmp");
}

void Execute::createDialog(bool bKeep)
{
	// if the dialog ought to remain, then don't do nothin'
//printf ("bKeep=<%d> dialog=<%X>\n", bKeep, m_pDialog);
	if ( (bKeep) && (m_pDialog) )
		return;
	// else remove the current dialog, and proceed ...
	if (m_pDialog)
		delete m_pDialog;

	m_pDialog = new MyDialog ();
	m_pDialog->setProjectPath(m_qsProjectPath);
	m_pDialog->show();
	m_pDialog->editCommandText->clear ();
	m_pDialog->setCloseDelay(m_iSeconds);
	connect ( m_pDialog, SIGNAL(destroyed()), this, SLOT(slotDialogClosed()));
	connect( this, SIGNAL(readyReadStderr()), this, SLOT(slotReadFromStderr()) );
	connect( this, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( this, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );
}

int Execute::system( QStringList &commandList, QStringList *pListEnv)
{
//	if (isRunning ())
//		return -1;
	createDialog();

	m_environmentList.clear();
	m_commandList = commandList;
	if (m_commandList.count() == 0)
		m_commandList.append (QString (""));
	if (pListEnv)
		m_environmentList = *pListEnv;
	m_iCurrentCommand = 0;
	return startCommand ();
}

int Execute::system( QString &commandString, QStringList *pListEnv)
{
//	if (isRunning ())
//		return -1;
	// Should work just as the system () call.
	// The only difference is that this call is non blocking ...
	// NOTE : commandString could hold multiple commands.
	createDialog ();

	m_environmentList.clear();
	m_commandList.clear ();
	m_commandList.append (commandString);
	if (pListEnv)
		m_environmentList = *pListEnv;
	m_iCurrentCommand = 0;
	return startCommand ();
}

int Execute::startCommand ()
{
	QStringList *pListEnv = NULL;
	// This function is called from system, and from slotProcessExited ();
	
	// First we check if there are any commands left in the QStringList.
	if (m_iCurrentCommand > m_commandList.count()-1)	{
		// Do some cleaning up. Not needed but better to be done ...
		m_commandList.clear ();
		m_iCurrentCommand = 0;
		return 0;
	}
	// second we take care of the environment.
	if (!m_environmentList.isEmpty())
		pListEnv = &m_environmentList;
	// Here we add the command to the top (command line) in the GUI.
	m_pDialog->editCommandText->append (QString ("cmd> ") + m_commandList[m_iCurrentCommand]);

	// Here we generate a simple shell script to execute the commands under the shell.
	// QProcess is currently not flexible enough to handle this internal.
	QFile file(m_qsTempPath + QString("/execute.sh"));
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << BASH_STRING << m_commandList[m_iCurrentCommand];
		file.close();
	}
	// And here we grant read/write/execute permission.
	chmod ((const char *)QString(m_qsTempPath + QString("/execute.sh")), S_IEXEC | S_IRUSR | S_IWRITE);
	// Increase the command counter ...
	m_iCurrentCommand ++;
	// Set the script to execute ...
	clearArguments ();
	addArgument (QString (m_qsTempPath + QString("/execute.sh")));
	// And eh voila, ici on executer les commands.
	start (pListEnv);
	// return to the calling process (thread)
	return 1;
}
// How about adding another timer, which verifies that the process did not die for what reasons ever ?
// Also the tatus could indicate <Running>...<blank>...<Running>...<blank>...
// I have to think about it since a avi->mpeg2 conversion would def. take longer then a few seconds ...

void Execute::slotProcessExited ()
{
	if (m_pDialog)	{
		slotReadFromStdout();
		slotReadFromStderr();
	}
	else
		printf ("<%s><%s>\n", (const char *)readStdout(), (const char *)readStderr());
	// Start the next process, or start the timer to terminate the whole thing ...
	if (startCommand() == 0)
               m_pDialog->processingFinished (m_iSeconds);
}

void Execute::slotDialogClosed()
{
	m_pDialog = NULL;
//printf (" Execute::slotDialogClosed Dialog was closed ...\n");
}
	
void Execute::setCloseDelay (uint iSeconds)
{
	// This function sets the number of seconds the GUI should wait
	// AFTER the process has terminated before auto closing the GUI.
	// range can be [0 - int]
	m_iSeconds = iSeconds;
}

uint Execute::getCloseDelay ()
{
	return m_iSeconds;
}

void Execute::setMaxWait (uint iSeconds)
{
	// This function sets the number of seconds that the system - call
	// will wait for the termination of the process. If the process
	// does not termintate within this time period, a error message
	// is send to the GUI interface and
	// range can be [0 - int]
	m_iMaxWait = iSeconds;
}

uint Execute::getMaxWait ()
{
	return m_iMaxWait;
}

void Execute::slotReadFromStderr()
{
	static QColor errorColor = QColor (255, 0, 0);
	if (m_pDialog)	{
		// Okay, errors red, warnings yellow please ...
		QColor stdColor = m_pDialog->textOutput->color();
		QString strError = readStderr ();
		if (strError.lower().find ("err") > -1)
			errorColor = QColor(255, 0, 0);
		else
			errorColor = QColor (220,220,0);
		m_pDialog->textOutput->setColor (errorColor);
		m_pDialog->textOutput->append (strError);
		m_pDialog->textOutput->setColor (stdColor);
	}
	else
		printf ("<%s>\n", (const char *)readStderr());
}

void Execute::slotReadFromStdout()
{
	if (m_pDialog)	{
		m_pDialog->textOutput->setColor (QColor( 27, 212, 7 ) );
		m_pDialog->textOutput->append (readStdout ());
	}
	else
		printf ("<%s>\n", (const char *)readStdout());
}

MyDialog::MyDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "ExecuteDialog" );
	setSizeGripEnabled( TRUE );
	MyDialogLayout = new QGridLayout( this, 1, 1, 11, 6, "MyDialogLayout"); 

	layout2 = new QHBoxLayout( 0, 0, 6, "layout2"); 

	buttonHelp = new QPushButton( this, "buttonHelp" );
	buttonHelp->setAutoDefault( TRUE );
	layout2->addWidget( buttonHelp );

	checkKeepOpen = new QCheckBox( this, "checkKeepOpen" );
	layout2->addWidget( checkKeepOpen );
	QSpacerItem* spacer = new QSpacerItem( 310, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout2->addItem( spacer );

	buttonExport = new QPushButton( this, "buttonExport" );
	buttonExport->setAutoDefault( TRUE );
	layout2->addWidget( buttonExport );

	buttonPlay = new QPushButton( this, "buttonPlay" );
	buttonPlay->setAutoDefault( TRUE );
	buttonPlay->setEnabled(false);
	layout2->addWidget( buttonPlay );

	buttonOk = new QPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	layout2->addWidget( buttonOk );

	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	layout2->addWidget( buttonCancel );

	MyDialogLayout->addLayout( layout2, 2, 0 );

	editCloseText = new QLineEdit( this, "editCloseText" );
	editCloseText->setPaletteForegroundColor( QColor( 170, 0, 255 ) );
	editCloseText->setPaletteBackgroundColor( QColor( 170, 170, 255 ) );
	editCloseText->setFrameShape( QLineEdit::NoFrame );
	editCloseText->setFrameShadow( QLineEdit::Plain );
	editCloseText->setReadOnly( TRUE );

	MyDialogLayout->addWidget( editCloseText, 1, 0 );

	splitter1 = new QSplitter( this, "splitter1" );
	splitter1->setOrientation( QSplitter::Vertical );

	editCommandText = new QTextEdit( splitter1, "editCommandText" );
	editCommandText->setMinimumSize( QSize( 0, 50 ) );
	editCommandText->setMaximumSize( QSize( 32767, 32767 ) );
	editCommandText->setBaseSize (QSize (editCommandText->width(), 50));
	editCommandText->setPaletteForegroundColor( QColor( 255, 85, 0 ) );
	editCommandText->setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
	editCommandText->setWordWrap( QTextEdit::WidgetWidth );

	textOutput = new QTextEdit( splitter1, "textOutput" );
	textOutput->setPaletteForegroundColor( QColor( 27, 212, 7 ) );
//	textOutput->setMinimumSize( QSize( 0, 250 ) );
//	textOutput->setMaximumSize( QSize( 32767, 32767 ) );
	textOutput->setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
	textOutput->setWordWrap( QTextEdit::WidgetWidth );

	MyDialogLayout->addWidget( splitter1, 0, 0 );
	languageChange();
	resize( QSize(740, 471).expandedTo(minimumSizeHint()) );
	clearWState( WState_Polished );

	// signals and slots connections
	connect( buttonExport, SIGNAL( clicked() ), this, SLOT( slotExport() ) );
	connect( buttonPlay, SIGNAL( clicked() ), this, SLOT( slotPlay() ) );
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( checkKeepOpen, SIGNAL( toggled(bool) ), this, SLOT( slotKeepOpen(bool) ) );

	m_bDoneProcessing = false;
	m_pTimer = NULL;
	QValueList<int> listSizes;
	listSizes.append (50);
	listSizes.append (1000);
	splitter1->setSizes (listSizes);
}

MyDialog::~MyDialog()
{
	// I know Qt does this but it is good programming style, 
	// to take care of all allocated objects.
	if (m_pTimer)
		delete m_pTimer;
}

void MyDialog::setCloseDelay (uint iSeconds)
{
	// This function sets the number of seconds the GUI should wait
	// AFTER the process has terminated before auto closing the GUI.
	// range can be [0 - int]
	m_iSeconds = iSeconds;
}

uint MyDialog::getCloseDelay ()
{
	return m_iSeconds;
}
void MyDialog::setProjectPath(QString qsProjectPath)
{
	m_qsProjectPath = qsProjectPath;
}

void MyDialog::languageChange()
{
	setCaption( tr( "Execution Dialog" ) );
	buttonHelp->setText( tr( "&Help" ) );
	buttonHelp->setAccel( QKeySequence( tr( "F1" ) ) );
	checkKeepOpen->setText( tr( "Keep Open" ) );
	buttonExport->setText( tr( "&Export" ) );
	buttonExport->setAccel( QKeySequence( QString::null ) );
	buttonPlay->setText( tr( "&Play" ) );
	buttonPlay->setAccel( QKeySequence( QString::null ) );
	buttonOk->setText( tr( "&OK" ) );
	buttonOk->setAccel( QKeySequence( QString::null ) );
	buttonCancel->setText( tr( "&Cancel" ) );
	buttonCancel->setAccel( QKeySequence( QString::null ) );
	editCloseText->setText( tr( "Status : " ) );
}

void MyDialog::slotTimerDone ()
{
	static uint iCounter = 0;
//	static bool bShowRunning = true;
	iCounter ++;
	if (iCounter > m_iSeconds)	{
		m_pTimer->stop();
		iCounter = 0;
		editCloseText->setText (tr ("Status : Done."));
		accept ();
	}
//	if (bShowRunning)
//		editCloseText->setText (QString ("Status : Running."));
//	else
//		editCloseText->setText (QString ("Status : "));
//	bShowRunning = bShowRunning ? false : true;
	editCloseText->setText (tr ("Status : Close dialog in %1 seconds.").arg (m_iSeconds - iCounter + 1));
}

void MyDialog::processingFinished (int iSeconds)
{
	// We're done, timer stuff now ok
	m_bDoneProcessing = true;

	// Start the timer if the checkbox is clear
	if (!checkKeepOpen->isChecked())        {
		startTimer(iSeconds);
	}
	// First we check if qplayer is there and executable ...
	QFileInfo fileInfo ("qplayer");
	if (!fileInfo.exists())
		return;
	// next we check if it is executable ...
	if (!fileInfo.isExecutable())
		return;
	// last we check if there has been something clreated to play at all ...
	fileInfo.setFile(m_qsProjectPath + QString ("/VIDEO_TS/VIDEO_TS.BUP"));
	if (!fileInfo.exists())
		return;
	fileInfo.setFile(m_qsProjectPath + QString ("/VIDEO_TS/VIDEO_TS.IFO"));
	if (!fileInfo.exists())
		return;
	fileInfo.setFile(m_qsProjectPath + QString ("/VIDEO_TS/VIDEO_TS.VOB"));
	if (!fileInfo.exists())
		return;
	buttonPlay->setEnabled(true);
}

// The next three are related to the Keep Open countdown
void MyDialog::startTimer (int iSeconds)
{
	m_iSeconds = iSeconds;
	if (m_iSeconds > 0)     {
		if (m_pTimer)
			delete m_pTimer;
		m_pTimer = new QTimer ( this );
		connect( m_pTimer, SIGNAL(timeout()), this, SLOT(slotTimerDone()) );
		m_pTimer->start (1000);
	}
}

void MyDialog::stopTimer ()
{
	if (m_pTimer)	{
		if (m_pTimer->isActive())	{
			m_pTimer->stop ();
		}
	}
}

void MyDialog::slotKeepOpen (bool bKeepOpen)
{
	// This could be called before processingFinished()
	if (! m_bDoneProcessing)
		return;
	if (bKeepOpen)	{
		stopTimer ();
		editCloseText->setText (tr ("Status : "));
	}
	else
		startTimer (m_iSeconds);
}

void MyDialog::slotPlay ()
{
printf ("execute.cpp ::: slotPlay <%s>\n", (const char *)m_qsProjectPath);
	system (QString ("qplayer dvd:/%1/VIDEO_TS/").arg(m_qsProjectPath));	//dvd:/home/varol/dvdproject/dvd/VIDEO_TS/");
}

void MyDialog::slotExport ()
{
	QString qsSaveFileName = QFileDialog::getSaveFileName( m_qsProjectPath, tr("Text files (*.txt *.TXT)"),
		this, tr("Save file dialog. Choose a filename to save under"));
  	if (qsSaveFileName.isEmpty())
		return;

	QFile file( qsSaveFileName );
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << editCommandText->text() << "\n";
		stream << "\n+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-\n\n";
		stream << textOutput->text() << "\n";
		file.close();
	}
}

/*
this implementation was complicated, and used a script anyhow and would not handle E.g.:
cd ../configurator; make. The make command would be executed in the current path not under ../configurator.
int Execute::system( QString &commandString, QStringList *pListEnv)
{
	// Should work just as the system () call. 
	// The only difference is that this call is non blocking ...
	// NOTE : commandString could hold multiple commands.
	if (m_pDialog)
		delete m_pDialog;
	m_pDialog = new MyDialog ();
	m_pDialog->show();
	connect( this, SIGNAL(readyReadStderr()), this, SLOT(slotReadFromStderr()) );
	connect( this, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( this, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );
	m_pDialog->editCommandText->setText (QString ("cmd> ") + commandString);
	// Okay first we get the number of commands in this string.
	m_commandList = QStringList::split(";", commandString);
	m_iCurrentCommand = 0;
	if (pListEnv)
		m_listEnvironment = *pListEnv;
	
	// Here we generate a simple shell script to execute the commands under the shell. 
	// QProcess is currently not flexible enough.
	QFile file("/tmp/execute.sh");
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << "#!/bin/bash\n\n" << "$*\n" << "echo $* > /tmp/out.txt";
		file.close();
	}
	chmod ("/tmp/execute.sh", S_IEXEC | S_IRUSR | S_IWRITE);
	// slotProcessExited handles the the command list.
	slotProcessExited ();
	// return to the calling process (thread)
	return 0;
}
void Execute::slotProcessExited ()
{
	if (m_pDialog)	{
		slotReadFromStdout();
		slotReadFromStderr();
	}
	else
		printf ("<%s><%s>\n", (const char *)readStdout(), (const char *)readStderr());
	
	m_bHasFinished = false;
	// Get the current command to be executed, and split the single commands into their arguments.
	clearArguments ();
	if (m_iCurrentCommand < (int) m_commandList.count ())	{
		addArgument (QString ("/tmp/execute.sh"));
		QStringList argumentList = QStringList::split(" ", m_commandList[m_iCurrentCommand++]);
		// Here we add all arguments ...
		for (uint i=0;i<argumentList.count();i++)
			addArgument (argumentList[i]);
		// and here we execute the sub-command.
		start (&m_listEnvironment);
	}
	else	{ // and here we start the timer to close the GUI after set amount of seconds.
               m_pDialog->processingFinished (m_iSeconds);
		m_bHasFinished = true;
	}
}
*/



/*
the following implementation would block the whole process until the execution was terminated.
void Execute::slotProcessExited ()
{
	if (m_pDialog)	{
		slotReadFromStdout();
		slotReadFromStderr();
	}
	else
		printf ("<%s><%s>\n", (const char *)readStdout(), (const char *)readStderr());
	// and here we start the timer to close the GUI after set amount of seconds.
       m_pDialog->processingFinished (m_iSeconds);
}
int Execute::system( QString &commandString, QStringList *listEnv)
{
	int iReturn=0;
	// Should work just as the system () call. After calling this function,
	// it will only return, when the process has terminated.
	// NOTE : commandString could hold multiple commands.
	if (m_pDialog)
		delete m_pDialog;

	m_pDialog = new MyDialog ();
	m_pDialog->show();
	connect( this, SIGNAL(readyReadStderr()), this, SLOT(slotReadFromStderr()) );
	connect( this, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( this, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );
	m_pDialog->editCommandText->setText (QString ("cmd> ") + commandString);
	// Okay first we get the number of commands in this string.
	QStringList commandList = QStringList::split(";", commandString);
	for (uint t=0;t<commandList.count();t++)	{
		// And here we split the single commands into their arguments.
		clearArguments ();
		QStringList argumentList = QStringList::split(" ", commandList[t]);
		// Here we add all arguments ...
		for (uint i=0;i<argumentList.count();i++)
			addArgument (argumentList[i]);
		// and here we execute the sub-command.
		iReturn = execute (listEnv);
		if (iReturn < 0)
			return iReturn;
	}
	return iReturn;
}

	
int Execute::execute (QStringList *listEnv)
{
	m_pDialog->stopTimer ();
	uint iWaitedAlready = 0;
	// This call is internal only. All arguments have already been set.
	// Here we start the action.
	start (listEnv);
	int iTest;
	while (isRunning () && (m_iMaxWait > iWaitedAlready) )	{
		sleep (1);
		iWaitedAlready ++;
	}
	return exitStatus ();
}
*/
