/****************************************************************************
** Execute class
**
** Created: Tue Jan 20 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class is an enhaced version of QProcess. It will display the 
** output and the error messages (if any) in a graphical GUI.
**
** 5 seconds after the termination of the process the GUI will terminate.
**
****************************************************************************/

#ifndef EXECUTE_H
#define EXECUTE_H

#include <qprocess.h>

#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPushButton;
class QTextEdit;
class QLineEdit;
class QCheckBox;
class QTimer;
class QSplitter;

class MyDialog : public QDialog
{
    Q_OBJECT

public:
    MyDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~MyDialog();

    void processingFinished (int);
    void startTimer (int);
    void stopTimer ();
    
    void setProjectPath(QString);

    // This function sets the number of seconds the GUI should wait
    // AFTER the process has terminated before auto closing the GUI.
    // range can be [0 - int]
    void setCloseDelay (uint iSeconds);
    uint getCloseDelay ();
    
    QPushButton* buttonHelp;
    QCheckBox* checkKeepOpen;
    QPushButton* buttonExport;
    QPushButton* buttonPlay;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QLineEdit* editCloseText;
    QSplitter* splitter1;
    QTextEdit* editCommandText;
    QTextEdit* textOutput;

protected:
    QGridLayout* MyDialogLayout;
    QHBoxLayout* layout2;

protected slots:
    virtual void languageChange();
    virtual void slotTimerDone();
    virtual void slotKeepOpen(bool);
    virtual void slotExport ();
    virtual void slotPlay ();

protected:
	QTimer	*m_pTimer;
	uint 	 m_iSeconds;
	QString m_qsProjectPath;
       bool m_bDoneProcessing;
};

class Execute : public QProcess
{
	Q_OBJECT
public:
	 Execute ( QObject * parent = 0, const char * name = 0 );
	 Execute ( const QString & arg0, QObject * parent = 0, const char * name = 0 );
	 Execute ( const QStringList & args, QObject * parent = 0, const char * name = 0 );
	~Execute ();

	// The main new function added. simply call something, like
	// system ("cd hallo; touch base; more of_this", &env);
	// This function will return after all has been executed.
	int system( QString &commandString, QStringList *listEnv=NULL);
	// Same as above but executes line of commands after each other.
	int system( QStringList &commandString, QStringList *listEnv=NULL);

	// This function sets the number of seconds the GUI should wait
	// AFTER the process has terminated before auto closing the GUI.
	// range can be [0 - int]
	void setCloseDelay (uint iSeconds);
	uint getCloseDelay ();

	// This function sets the number of seconds that the system - call
	// will wait for the termination of the process. If the process
	// does not termintae within this time period, a error message
	// is send to the GUI interface and
	// range can be [0 - int]
	void setMaxWait (uint iSeconds);
	uint getMaxWait ();
	
	// This returns true if all commands from the Execute::system call have returned.
	bool hasFinished ();

	// This function sets the Project Path., and the Temp Path This is needed to enable the <play> button 
	// in the Dialog, after the DVD has been created.
	void setPaths(QString, QString);

public slots:
	virtual void slotReadFromStderr();
	virtual void slotReadFromStdout();
	virtual void slotProcessExited ();
	virtual void slotDialogClosed  ();

private:
	void	initMe();
	int 	startCommand ();
	void 	createDialog(bool bKeep=false);
	
	MyDialog	*m_pDialog;

	uint m_iMaxWait;
	uint m_iSeconds;
	uint m_iCurrentCommand;
	QStringList m_commandList;
	QStringList m_environmentList;
	QString     m_qsProjectPath;
	QString	m_qsTempPath;
};

#endif // EXECUTE_H
