#ifndef GLOBAL_H
#define GLOBAL_H

#define DEBUG_INFO 1

// Here we define all external tools neccesary
// Format = executable, Display Name, Explanation of function
#define EXTERNAL_TOOLS \
		'"dvdauthor",    "DVDAuthor",      "Desc", \
		"spumux",        "Spumux",         "Desc", \
		"mplex",         "MPlex",          "Desc", \
		"dvd-slideshow", "DVD-Slideshow",  "Desc", \
		"arecord",       "ARecord",        "Desc", \
		"transcode",     "Transcode",      "Desc", \
		"oggdec",        "Ogg Dec",        "Desc", \
		"mp2enc",        "mp2 Enc",        "Desc", \
		"lame",          "Lame",           "Desc", \
		"mplayer",       "MPlayer",        "Desc", \
		"jpegtopnm",     "JPG To PNM",     "Desc", \
		"ppmto4ym",      "PPM To 4YM",     "Desc", \
		"mpeg2enc",      "MPEG2 Enc",      "Desc", \
		"jpegtoyuv",     "JPG To YUV",     "Desc", \
		"pcm2aiff",      "PCM To AIFF",    "Desc", \
		"mctoolame",     "MC TooLame",     "Desc", \
		"sox",           "SOund eXchange", "Desc", \
		"dd",            "dd",             "Desc", \
		"toolame",       "TooLame",        "Desc", \
		"growisofs",     "Grow ISO FS",    "Desc", \
		"dvd+rw-format", "DVD+RW Format",  "Desc", \
		"mkisofs",       "Make ISO FS",    "Desc", \
		"dvdrecord",     "DVD Record",     "Desc"'


#define STRING_SEPARATOR "+-+"
// here we define the file name of the ini file.
#define INI_FILE_NAME "~/.qdvdauthorrc"

// The initial project file name for a new project. Need to get changed manually
#define PROJECT_FILENAME "Unnamed.xml"
#define PROJECT_NAME     "Unnamed"

// This variable tells us where the bash shell is located. Needed for the generated scripts
#define BASH_STRING "#!/bin/bash\n\n" 

// Here are the defines for the different video modes
#define FORMAT_NONE		0
#define FORMAT_NTSC1	1
#define FORMAT_NTSC2	2
#define FORMAT_NTSC3	3
#define FORMAT_NTSC4	4
#define FORMAT_PAL1		5
#define FORMAT_PAL2		6
#define FORMAT_PAL3		7
#define FORMAT_PAL4		8


#define BACKGROUND_IMG		0
#define SELECTED_MASK		1
#define HIGHLIGHTED_MASK	2

#define BACKGROUND_NAME		"background.jpg"
#define SELECTED_NAME		"selected.png"
#define HIGHLIGHTED_NAME	"highlighted.png"

// The max colors a mask (button) can have. Either 4 or 16, not sure.
#define MAX_MASK_COLORS 4

// Here we define the color which is to be interpreted as transparent (only used as a type of flag)
#define TRANSPARENT_COLOR        254, 255, 254

// These are the standard colors for the SELECTED, and HIGHLIGHTED layer.
// Note: max of 4 colors are allowed, so colorspace is sparse.
#define START_HIGHLIGHTED_COLOR  250,150,50
#define START_SELECTED_COLOR     255, 20, 20

// This color is applied to the background, thus it can be different unless the user 
// decides to put it onto a Selected / highlighted layer.
#define START_FRAME_COLOR        255, 255, 20

// These defines specify the color to use in the SourceFileToolbar
//#define COLOR_MOVIE_FILES 110, 160, 210
#define COLOR_MOVIE_FILES_OK  140, 200, 250
#define COLOR_MOVIE_FILES_BAD 140,  20,  50
#define COLOR_SOUND_FILES_OK   80,  80, 220
#define COLOR_SOUND_FILES_BAD  16,  16,  44
#define COLOR_SLIDE_FILES_OK  210, 130, 170
#define COLOR_SLIDE_FILES_BAD  42,  26,  34

// PI is always good to have
#ifndef PI
#define PI 3.14
#endif

// Here the user chose to compile with xine support.
#define USE_XINE_LIB 1

// here the user chose to compile with mplayer support
//#define USE_MPLAYER_LIB 1

#endif // GLOBAL_H
