/****************************************************************************
** ImagePreview class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ImagePreview from the FileSelection
** Dialog.
** It is also used in the ImageDialog.
**
****************************************************************************/
#include <qpainter.h>
#include <qwmatrix.h>
#include <qpixmap.h>
#include <qpopupmenu.h>

#include "xml_dvd.h"
#include "menuobject.h"
#include "objectcollection.h"

ObjectCollection::ObjectCollection (QWidget *pParent)
	: MenuObject (pParent)
{
	m_qsObjectType = QString (OBJECT_COLLECTION);
}

ObjectCollection::~ObjectCollection ()
{

}

void ObjectCollection::drawContents (QPainter *)
{
}

bool ObjectCollection::mouseMoveEvent (QMouseEvent *pEvent)
{
	// This will move the textObject around and around and around we go ...
	QRect theRect = rect();
	int iX, iY, iWidth, iHeight;
	iWidth  = rect().width ();
	iHeight = rect().height();
	iX = rect().x() - (m_currentMousePos.x() - pEvent->pos().x());
	iY = rect().y() - (m_currentMousePos.y() - pEvent->pos().y());
	theRect.setX(iX);
	theRect.setY(iY);
	theRect.setWidth(iWidth);
	theRect.setHeight(iHeight);

	setRect(theRect);
	m_currentMousePos = pEvent->pos();
	return false;
}

bool ObjectCollection::mousePressEvent (QMouseEvent *pEvent)
{
	m_currentMousePos = pEvent->pos();
	if (pEvent->button() == Qt::RightButton)	{
		QPopupMenu *pMenu = new QPopupMenu(m_pParent);
		pMenu->insertItem ( tr ("Modify ..."), this, SLOT(slotEdit()));
		pMenu->insertItem ( tr ("Delete")    , this, SLOT(slotDelete()));
		pMenu->insertSeparator();
		pMenu->insertItem ( tr ("Add Frame") , this, SLOT(slotAddFrame()));
		pMenu->insertItem ( tr ("Add Text")  , this, SLOT(slotAddImage()));
		pMenu->insertItem ( tr ("Add Image") , this, SLOT(slotAddImage()));
		pMenu->insertItem ( tr ("Add Movie") , this, SLOT(slotAddImage()));
		pMenu->insertSeparator();
		pMenu->insertItem ( tr ("Define as Button") , this, SLOT(slotDefineAsButton()));
		int iReturn = pMenu->exec(pEvent->globalPos());
		// Here we mark that the user called a menu item thus we don't want the
		// base classes to continue with the mouse event
		if (iReturn != -1)
			return true;
	}
	else
		m_bDrawRect = true;
	return false;
}

bool ObjectCollection::mouseReleaseEvent (QMouseEvent *)
{
	m_bDrawRect = false;
	return false;
}

bool ObjectCollection::mouseDoubleClickEvent (QMouseEvent *)
{
	return false;
}

bool ObjectCollection::readProjectFile  (QDomNode &)
{
	return false;
}

bool ObjectCollection::writeProjectFile (QDomElement &)
{
	return false;
}

void ObjectCollection::createStructure (QListViewItem *)
{

}

void ObjectCollection::slotEdit()
{
	mouseDoubleClickEvent(NULL);
}

void ObjectCollection::slotDelete()
{
	emit (signalDeleteMe(this));
}

void ObjectCollection::slotAddFrame()
{

}

void ObjectCollection::slotAddText()
{

}

void ObjectCollection::slotAddImage()
{

}

void ObjectCollection::slotAddMovie()
{

}

void ObjectCollection::slotDefineAsButton()
{
	emit (signalDefineAsButton(this));
}


