/****************************************************************************
** Implementation of class QDVDAuthorInit
**
** Created: Wed Jun 02 07:53:05 2004
**      by: Varol Okan using the kate editor
**
** This class initialises the QDVDAuthor application with the
** last used settings.
**
** It is mainly used, to handle the CommandQueueDialogs options
** which can now be changed by the user.
**
****************************************************************************/

#include <qmessagebox.h>

#include "qdvdauthorinit.h"
#include "sourcefileentry.h"


QDVDAuthorInit::MenuBlock::MenuBlock ()
{ 
	bValid = false;  
	bHidden = false; 
	blockMovieBackground.qsBlockTag = QString ( BLOCK_MOVIE_BACKGROUND );
	blockImageBackground.qsBlockTag = QString ( BLOCK_IMAGE_BACKGROUND );
	blockEmptySound.qsBlockTag = QString ( BLOCK_EMPTY_SOUND );
	blockMplex.qsBlockTag  = QString ( BLOCK_MPLEX );
	blockSpumux.qsBlockTag = QString ( BLOCK_SPUMUX );
	blockOthers.qsBlockTag = QString ( BLOCK_OTHERS );
};

// FIXME:
// As of June 8'th 2004 this class is done 90%.
// Done ->
// o Loading of init file.
// o Saving the MenuBlock stored data back to the ini - file.
// o Saving of default init file.
// o The function to store an init file depending on the users modifications.
// o Added buttons to the CommandQueueDialog (DialogExecute)
//
// Missing ->
// o Some more sanity checks.
// o The function convertSoundFile ()
//////////////////////////////////////////////////////////////////////////////////////////////

QDVDAuthorInit::QDVDAuthorInit()
{

}

QDVDAuthorInit::QDVDAuthorInit(QString qsTempPath, QString qsProjectPath, QString qsDvdauthor)
{
	m_qsTempPath          = qsTempPath;
	m_qsProjectPath       = qsProjectPath;
	m_qsDvdauthor         = qsDvdauthor;
	m_iColorCounter       = 0;
	m_iCurrentBlockID     = 0;	// To uniquely identify each block of commands ...

	m_palMenuBlock.qsMenuTag       = QString (TAG_PAL);
	m_ntscMenuBlock.qsMenuTag      = QString (TAG_NTSC);
	m_dvdauthorMenuBlock.qsMenuTag = QString (TAG_DVDAUTHOR);
	m_burningMenuBlock.qsMenuTag   = QString (TAG_BURNING);
	m_listExecute.clear ();
	initMe ();
}

QDVDAuthorInit::~QDVDAuthorInit()
{
	uint t;
	// -2 because the last two entries are static ones ...
	for (t=0;t<m_listExecute.count()-2;t++)
		delete m_listExecute[t];
	for (t=0;t<m_arrayColors.count();t++)
		delete m_arrayColors[t];
}

bool QDVDAuthorInit::readBlock (MenuBlock::Block *pBlock, QDomElement *pElem)
{
	int iCommandNumber = 0;
	// This function gets the information from Command / Comment - tags
	QDomNode xmlNode = pElem->firstChild();
	while (!xmlNode.isNull())	{
		QDomElement searchTree = xmlNode.toElement();
		if (searchTree.tagName() == QString (TAG_COMMAND))	{
			QDomAttr a = searchTree.attributeNode(ATTRIB_DEFAULT);
			if (a.value() == QString ("true"))
				pBlock->iDefaultCommand = iCommandNumber;
			pBlock->listCommands.append (searchTree.text());
			iCommandNumber ++;
			pBlock->iBlockID = m_iCurrentBlockID ++;
//printf ("++Command<%s>\n", (const char *)searchTree.text());
		}
		else if (searchTree.tagName() == QString (TAG_COMMENT)) 	{
			pBlock->listComments.append(searchTree.text());
			pBlock->iBlockID = m_iCurrentBlockID ++;
//printf ("--Comment<%s>\n", (const char *)searchTree.text());
		}
		else
			return false;
		xmlNode = xmlNode.nextSibling();
	}
//printf ("**EndBlock \n");
	return true;
}

bool QDVDAuthorInit::readMenuBlock (MenuBlock *pMenuBlock, QDomElement *pElem)
{
	QString qsBlockName;
	MenuBlock::Block *pBlock;
	// This function reads in a MenuBlock (with multiple sub-Block)
	// First we get the attributes ...
	QDomAttr a = pElem->attributeNode ( ATTRIB_BLOCKNAME );
	pMenuBlock->qsBlockName = a.value();
	a = pElem->attributeNode ( ATTRIB_COLOR );
	pMenuBlock->colorBackground.setNamedColor(a.value());
	// Next we parse through the associated Blocks.
	QDomNode xmlNode = pElem->firstChild ();
	while (!xmlNode.isNull())	{
		QDomElement searchTree = xmlNode.toElement();
		if (searchTree.tagName() == QString (TAG_BLOCK) )	{
			pBlock = &pMenuBlock->blockOthers;
			// get the name of this block ...
			qsBlockName = searchTree.attributeNode ( ATTRIB_NAME ).value();
			if (qsBlockName == QString (BLOCK_MOVIE_BACKGROUND))
				pBlock = &pMenuBlock->blockMovieBackground;
			else if  (qsBlockName == QString (BLOCK_IMAGE_BACKGROUND))
				pBlock = &pMenuBlock->blockImageBackground;
			else if  (qsBlockName == QString (BLOCK_EMPTY_SOUND))
				pBlock = &pMenuBlock->blockEmptySound;
			else if  (qsBlockName == QString (BLOCK_MPLEX))
				pBlock = &pMenuBlock->blockMplex;
			else if  (qsBlockName == QString (BLOCK_SPUMUX))
				pBlock = &pMenuBlock->blockSpumux;
			// and now we dwelve into reading the rest of the fest ...
			if (!readBlock (pBlock, &searchTree))
				return false;
		}
		xmlNode = xmlNode.nextSibling();
	}
	return true;
}

bool QDVDAuthorInit::initMe()
{
	return readIniFile();
}

bool QDVDAuthorInit::readIniFile ()
{
	// This function reads in the xml - init - file for 'Q' DVD-Author and
	// generates the neccesary data structures to be used by appendMenu.

	// Assign the file
	QString qsInitFile = QDir::homeDirPath();
	qsInitFile.append(INIT_FILE_NAME);

	QFile initFile(qsInitFile);
	if (!initFile.open(IO_Raw | IO_ReadWrite))
		return false;

	QDomDocument xmlDoc( INIT_DOCTYPE );
	if (!xmlDoc.setContent (&initFile))	{
		// Error handling ...
		initFile.close();
		int iReturn = QMessageBox::warning ( NULL, QObject::tr ("QDVDAuthor - init file seems to be defective."),
			QObject::tr ("The file %1 seems  to have a problem. Do you want to reset this file ?").arg(INIT_FILE_NAME),
			QMessageBox::Yes, QMessageBox::No);
		if (iReturn == QMessageBox::Yes)	{
			resetInitFile ();
			return initMe ();
		}
	}
	// And at last lets try to read the information of the file.
	QDomElement docElem = xmlDoc.documentElement();
	// Sanity check ...
	if (docElem.tagName() != QString (TAG_INIT))
		return false;
	
	// Here we get the next step in the tree down ... ExecuteInterface
	uint t;
	QStringList listCommands;
	QValueList<QString> listColors;
	QValueList<int>     listOrder;
	QDomNode xmlNode;
	QDomElement childElem;
	QDomNode xmlExecuteInterfaceNode = docElem.firstChild();
	bool bHidden;
	MenuBlock *pMenuBlock;
	while (!xmlExecuteInterfaceNode.isNull())	{
		bHidden = false;
		childElem = xmlExecuteInterfaceNode.toElement();
		if (childElem.tagName() == QString(TAG_EXECUTE))	{
			// Correctly detects a ExecuteInterface - tag
			// So lets get the only attribute for ExecuteInterface
			QDomAttr a = childElem.attributeNode ( ATTRIB_HIDDEN );
			if (a.value() == QString ("true"))
				bHidden = true;
			// Here we get the next step in the tree down ... Pal, or Ntsc or Dvdauthor or Burning
			xmlNode = childElem.firstChild();
			while (!xmlNode.isNull())	{
				childElem = xmlNode.toElement();
				pMenuBlock = NULL;
				if (childElem.tagName() == QString (TAG_PAL))
					pMenuBlock = &m_palMenuBlock;
				else if (childElem.tagName() == QString (TAG_NTSC))
					pMenuBlock = &m_ntscMenuBlock;
				else if (childElem.tagName() == QString (TAG_DVDAUTHOR))
					pMenuBlock = &m_dvdauthorMenuBlock;
				else if (childElem.tagName() == QString (TAG_BURNING))
					pMenuBlock = &m_burningMenuBlock;
				if (!pMenuBlock)
					return false;
				if (!readMenuBlock (pMenuBlock, &childElem))
					return false;
				pMenuBlock->bHidden = bHidden;
				xmlNode = xmlNode.nextSibling();
			}
		}
		else if (childElem.tagName() == QString(TAG_COLOR))	{
			QDomAttr a = childElem.attributeNode ( ATTRIB_NUMBER );
			listOrder.append(a.value().toInt());
			listColors.append(childElem.text());
			m_arrayColors.append(new QColor());
		}
		// Get the next "ExecuteInterface"
		xmlExecuteInterfaceNode = xmlExecuteInterfaceNode.nextSibling();
	}
	// Okay, next we sort out the colors ...
	for (t=0;t<m_arrayColors.count();t++)
		m_arrayColors[listOrder[t]]->setNamedColor(listColors[t]);

	// Next in order to create the dvdauthor, and burn - block we need some data in the keywords to be used in resolvString()
	m_listKeywords.clear();
	m_listKeywords.append (m_qsDvdauthor);
	m_listKeywords.append (m_qsProjectPath);
	m_listKeywords.append (m_qsTempPath);

	// And finally we get the information for the dvdauthor block, and the burning block ...
	m_dvdauthorInterface.qsBlockName = resolvString(m_dvdauthorMenuBlock.qsBlockName);
	m_dvdauthorInterface.backgroundColor = m_dvdauthorMenuBlock.colorBackground;
	for (t=0;t<m_dvdauthorMenuBlock.blockOthers.listComments.count();t++)
		m_dvdauthorInterface.commentList.append(resolvString(m_dvdauthorMenuBlock.blockOthers.listComments[t]));
	for (t=0;t<m_dvdauthorMenuBlock.blockOthers.listCommands.count();t++)
		listCommands.append (resolvString(m_dvdauthorMenuBlock.blockOthers.listCommands[t]));
	m_dvdauthorInterface.listCommandList.append(listCommands);
	m_dvdauthorInterface.listDefaults.append(m_dvdauthorMenuBlock.blockOthers.iDefaultCommand);
	m_dvdauthorInterface.bShowBlock = !m_dvdauthorMenuBlock.bHidden;
	m_dvdauthorInterface.listBlockIDs.append (m_dvdauthorMenuBlock.blockOthers.iBlockID);

	listCommands.clear();
	m_burnInterface.qsBlockName = resolvString(m_burningMenuBlock.qsBlockName);
	m_burnInterface.backgroundColor = m_burningMenuBlock.colorBackground;
	for (t=0;t<m_burningMenuBlock.blockOthers.listComments.count();t++)
		m_burnInterface.commentList.append(resolvString(m_burningMenuBlock.blockOthers.listComments[t]));
	for (t=0;t<m_burningMenuBlock.blockOthers.listCommands.count();t++)
		listCommands.append (resolvString(m_burningMenuBlock.blockOthers.listCommands[t]));
	m_burnInterface.listCommandList.append(listCommands);
	m_burnInterface.listDefaults.append(m_burningMenuBlock.blockOthers.iDefaultCommand);
	m_burnInterface.bShowBlock = !m_burningMenuBlock.bHidden;
	m_burnInterface.listBlockIDs.append (m_burningMenuBlock.blockOthers.iBlockID);

	return true;
}

bool QDVDAuthorInit::saveIniFile ()
{
	uint t;
	// This function writes in the xml - init - file for 'Q' DVD-Author.
	// the input for the file is taken from the structure stored in this class
	// and alsoo from the uses input.

	// Assign the file
	QString qsInitFile = QDir::homeDirPath();
	qsInitFile.append(INIT_FILE_NAME);

	QFile initFile(qsInitFile);
	if (!initFile.open(IO_WriteOnly))
		return false;

	QDomDocument xmlDoc( INIT_DOCTYPE );
	// Okay the document is set, now let us write into the document ...
	QDomElement rootInit = xmlDoc.createElement( TAG_INIT );	// <QDVDAuthorInitFile>
	xmlDoc.appendChild( rootInit );
	// First things first ... the color table ...
	for (t=0;t<m_arrayColors.count();t++)	{
		QDomElement colorElement = xmlDoc.createElement( TAG_COLOR );	// <Color>
		QDomText domText = xmlDoc.createTextNode (m_arrayColors[t]->name());
		colorElement.setAttribute( ATTRIB_NUMBER, QString ("%1").arg(t));
		colorElement.appendChild( domText );
		rootInit.appendChild ( colorElement );
	}

	// Next are the ExecuteInterface's The menus go first bien sur ...
	QDomElement executeElement = xmlDoc.createElement( TAG_EXECUTE );	// <ExecuteInterface>
	saveMenuBlock (&m_palMenuBlock,  &executeElement);
	saveMenuBlock (&m_ntscMenuBlock, &executeElement);
	rootInit.appendChild ( executeElement );
	
	QDomElement dvdauthorElement = xmlDoc.createElement( TAG_EXECUTE );	// <ExecuteInterface>
	saveMenuBlock (&m_dvdauthorMenuBlock, &dvdauthorElement);
	rootInit.appendChild ( dvdauthorElement );

	QDomElement burnElement = xmlDoc.createElement( TAG_EXECUTE );	// <ExecuteInterface>
	saveMenuBlock (&m_burningMenuBlock, &burnElement);
	rootInit.appendChild ( burnElement );

	// And finally we will store the generated string into the init file ...
	QString xml = xmlDoc.toString ();
//printf ("%s", (const char *)xml);
	initFile.writeBlock(xml, qstrlen (xml));

	initFile.close();
	return true;
}

bool QDVDAuthorInit::saveMenuBlock (MenuBlock *pMenuBlock, QDomElement *pElement)
{
	if (pMenuBlock->bHidden)
		pElement->setAttribute( ATTRIB_HIDDEN, QString ("true") );
	QDomDocument xmlDoc = pElement->ownerDocument();
	QDomElement systemElement = xmlDoc.createElement( pMenuBlock->qsMenuTag );
	systemElement.setAttribute( ATTRIB_BLOCKNAME, pMenuBlock->qsBlockName );
	if (!pMenuBlock->colorBackground.name().isEmpty())
		systemElement.setAttribute( ATTRIB_COLOR, pMenuBlock->colorBackground.name() );
	if ( (pMenuBlock->qsMenuTag == QString (TAG_PAL)) || (pMenuBlock->qsMenuTag == QString (TAG_NTSC)) )	{
		saveBlock (&pMenuBlock->blockMovieBackground, &systemElement);
		saveBlock (&pMenuBlock->blockImageBackground, &systemElement);
		saveBlock (&pMenuBlock->blockEmptySound, &systemElement);
		saveBlock (&pMenuBlock->blockMplex, &systemElement);
		saveBlock (&pMenuBlock->blockSpumux, &systemElement);
	}
	else
		saveBlock (&pMenuBlock->blockOthers, &systemElement);
		
	pElement->appendChild (systemElement);
	
	return true;
}

bool QDVDAuthorInit::saveBlock (MenuBlock::Block *pBlock, QDomElement *pElement)
{
	uint t;
	QDomDocument xmlDoc = pElement->ownerDocument();
	QDomElement blockElement = xmlDoc.createElement( TAG_BLOCK );
	blockElement.setAttribute ( ATTRIB_NAME, pBlock->qsBlockTag );
	for (t=0;t<pBlock->listComments.count();t++)	{
		QDomElement commentElement = xmlDoc.createElement( TAG_COMMENT );
		QDomText commentText = xmlDoc.createTextNode (pBlock->listComments[t]);
		commentElement.appendChild ( commentText );
		blockElement.appendChild ( commentElement );
	}
	for (t=0;t<pBlock->listCommands.count();t++)	{
		QDomElement commandElement = xmlDoc.createElement( TAG_COMMAND );
		if (pBlock->iDefaultCommand == (int)t)
			commandElement.setAttribute( ATTRIB_DEFAULT, QString ("true"));
		QDomText commandText = xmlDoc.createTextNode (pBlock->listCommands[t]);
		commandElement.appendChild ( commandText );
		blockElement.appendChild ( commandElement );
	}
	pElement->appendChild ( blockElement );

	return true;
}

QValueList <ExecuteInterface *>&QDVDAuthorInit::getList()
{
	return m_listExecute;
}

void QDVDAuthorInit::setKeywords (QValueList<QString> listKeywords)
{
	m_listKeywords.clear();
	m_listKeywords = listKeywords;
}

void QDVDAuthorInit::setDefault(int iBlockID, uint iDefaultCommand)
{
	// This function will search through the MenuBlocks to find the appropriate comment 
	// in order to set the default command correctly.
	getBlock(iBlockID)->iDefaultCommand = iDefaultCommand;
}

QDVDAuthorInit::MenuBlock::Block *QDVDAuthorInit::getBlock (int iBlockID)
{
	uint t;
	MenuBlock *arrayMenuBlocks[4] = {&m_palMenuBlock, &m_ntscMenuBlock, &m_dvdauthorMenuBlock, &m_burningMenuBlock};
	MenuBlock *pMenuBlock;
	MenuBlock::Block *pReturn = NULL;
	for (t=0;t<4;t++)	{
		pMenuBlock = arrayMenuBlocks[t];
		if (pMenuBlock->blockMovieBackground.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockMovieBackground;
		else if (pMenuBlock->blockImageBackground.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockImageBackground;
		else if (pMenuBlock->blockEmptySound.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockEmptySound;
		else if (pMenuBlock->blockMplex.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockMplex;
		else if (pMenuBlock->blockSpumux.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockSpumux;
		else if (pMenuBlock->blockOthers.iBlockID == iBlockID)
			 pReturn = &pMenuBlock->blockOthers;
		if (pReturn)
			return pReturn;
//printf (" QDVDAuthorInit::setDefault<%d> : <%d> = <%d><%d><%d><%d><%d><%d>\n", t, iBlockID,
//pMenuBlock->blockMovieBackground.iBlockID, pMenuBlock->blockImageBackground.iBlockID, pMenuBlock->blockEmptySound.iBlockID,
//pMenuBlock->blockMplex.iBlockID, pMenuBlock->blockSpumux.iBlockID, pMenuBlock->blockOthers.iBlockID);
	}
	return NULL;
}

void QDVDAuthorInit::appendPreProcessing ()
{
	// Currently nothing needs to be done.
	m_listExecute.clear();
}

void QDVDAuthorInit::appendPostProcessing ()
{
	m_listExecute.append(&m_dvdauthorInterface);
	m_listExecute.append(&m_burnInterface);
}

void QDVDAuthorInit::appendMenu (DVDMenu *pMenu, QString qsMenuName, QString qsBackgroundFileName)
{
	// This function will generate the Commands needed per Menu.
	// The information comes from the menu on the one hand and on the other 
	// it comes from the init - file. This is the mating ground ...
	uint t, i;
	MenuBlock *pMenuBlock;
	ExecuteInterface *pInterface = new ExecuteInterface;
	
	// First things first, here we determine the Format ...
	// iFormat > 4 equals PAL, otherwise NTSC
	int iFormat = pMenu->getFormat (pMenu->getInterface()->iWidth, pMenu->getInterface()->iHeight);

	// Next is to create the keyword list ... needed for resolvString() ...
	m_listKeywords.clear();
	m_listKeywords.append(m_qsDvdauthor);
	m_listKeywords.append(m_qsProjectPath);
	m_listKeywords.append(m_qsTempPath);
	m_listKeywords.append (QString ("%1").arg(pMenu->getInterface()->iWidth));
	m_listKeywords.append (QString ("%1").arg(pMenu->getInterface()->iHeight));

	if (iFormat > 4)	{	// PAL
		pMenuBlock = &m_palMenuBlock;
		m_listKeywords.append ("PAL");
	}
	else	{
		pMenuBlock = &m_ntscMenuBlock;
		m_listKeywords.append ("NTSC");
	}
//	m_listKeywords.append(qsMenuName);
	m_listKeywords.append(pMenu->name());
	m_listKeywords.append(qsBackgroundFileName);
	m_listKeywords.append(m_qsTempPath); // +SOUND_LIST+

	// Sanity check ...
//	if ( (!pMenuBlock) || (!pMenuBlock->bValid) )
	if (!pMenuBlock)
		return;

	pInterface->qsBlockName = resolvString (pMenuBlock->qsBlockName);
//	pInterface->backgroundColor = pMenuBlock->colorBackground;
	if (m_arrayColors.count() > 0)
		pInterface->backgroundColor = *m_arrayColors[m_iColorCounter++];
	else
		pInterface->backgroundColor.setNamedColor("#9EEE81");

	if (m_iColorCounter > (int)m_arrayColors.count())
		m_iColorCounter = 0;

	// Here we check if the background is a movie or an image.
	QFileInfo backgroundInfo (qsBackgroundFileName);
	MenuBlock::Block *pBlock = &pMenuBlock->blockImageBackground;
	if ( (backgroundInfo.extension() == "mpg")  ||
		 (backgroundInfo.extension() == "mpeg") ||
		 (backgroundInfo.extension() == "avi"))
		pBlock = &pMenuBlock->blockMovieBackground;

	addBlock (pInterface, pBlock);

// Note, spumux > button 'label' is ought to be 'name' now ??? (spumux from 19 Feb 2004)
// More on multichannel audio can be found under : http://www.dahnielson.com/primer.txt
// -- pcm2aiff inFile -c5 -r1
// -- mctoolame -m s -n d -L 6channelAiffFile.aiff output.m2v

// Trial and error : arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"
	m_soundList.clear();
	if (pMenu->getInterface()->listSoundEntries.count() == 0)	{
		// This is the only instance where we need a hardcoded naming scheme ...
		m_soundList.append (QString ("\"%1.mp2\"").arg(qsMenuName));
		m_listKeywords[8] = m_soundList[0];
		addBlock(pInterface, &pMenuBlock->blockEmptySound);
	}
	else	{
		QString qsConvertedSound;
		for (t=0;t<pMenu->getInterface()->listSoundEntries.count();t++)	{
			QString qsEntryName = pMenu->getInterface()->listSoundEntries[t];
			SourceFileEntry *pEntry = pMenu->getDVDAuthor()->getSourceEntryByDisplayName(qsEntryName);
			if (!pEntry)
				continue;
			for (i=0;i<pEntry->listFileInfos.count();i++)	{
				qsConvertedSound = convertSoundFile (pEntry->listFileInfos[i]->qsFileName);
				m_soundList.append (QString ("\"%1\"").arg(qsConvertedSound));
			}
		}
		m_listKeywords[8] = m_soundList.join (" ");
	}
	addBlock(pInterface, &pMenuBlock->blockMplex);
	addBlock(pInterface, &pMenuBlock->blockSpumux);

	pInterface->bShowBlock = !pMenuBlock->bHidden;
	pInterface->listKeywords = m_listKeywords;
	m_listExecute.append(pInterface);
}

void QDVDAuthorInit::addBlock(ExecuteInterface *pInterface, MenuBlock::Block *pBlock)
{
	uint t;
	QStringList stringList;
	// Currently not supported more then one comment per block ...
//	for (t=0;t<pBlock->listComments.count(); stringList.append(resolvString(pMenu, pBlock->listComments[t++])));
	pInterface->commentList.append(resolvString(pBlock->listComments[0])); //stringList);
//	stringList.clear();
	for (t=0;t<pBlock->listCommands.count(); stringList.append(resolvString(pBlock->listCommands[t++])));
	pInterface->listCommandList.append(stringList);
	pInterface->listDefaults.append (pBlock->iDefaultCommand);
	pInterface->listBlockIDs.append (pBlock->iBlockID);

	stringList.clear();
}

QString QDVDAuthorInit::resolvString (QString qsInput)
{
	#define MAX_KEYWORDS 9
	// This function resolves the variables in the stored commands / commenst / names like
	// +MENU_NAME+, +WIDTH+, +BACKGROUND_FILE_NAME+ etc.
	QString qsOutput = qsInput;
	uint t;
	char cArrayKeyword[MAX_KEYWORDS][35] = {"+DVDAUTHOR_XML+", "+PROJECT_PATH+", "+TEMP_PATH+", "+WIDTH+", "+HEIGHT+",
		"+FORMAT+", "+MENU_NAME+", "+BACKGROUND_FILE_NAME+", "+SOUND_LIST+"};
	for (t=0;t<m_listKeywords.count();t++)	{
		// Here we replace the actual keyword with the real string.
//		if (qsOutput.find (cArrayKeyword[t]) )
			qsOutput.replace(cArrayKeyword[t], m_listKeywords[t]);
	}
	return qsOutput;
}

QString QDVDAuthorInit::convertSoundFile (QString qsOriginalSoundFile)
{
	// This function is supposed to detect the sound preferences of the sound files
	// and convert them to the propper mp2, pcm, or ac3 layer format for usage with the DVD
	QString qsReturn;

	qsReturn = qsOriginalSoundFile;

	return qsReturn;
}

void QDVDAuthorInit::resetInitFile ()
{
	QString qsInitFile = QDir::homeDirPath();
	qsInitFile.append(INIT_FILE_NAME);
	
	QFile initFile(qsInitFile);
	if ( initFile.open( IO_WriteOnly ) )	{
		QTextStream stream( &initFile );
		QString qsResetInitFile ("\
<QDVDAuthorInitFile>\n\
  <Color number=\"0\">#9EEE81</Color>\n\
  <Color number=\"1\">#8FEED3</Color>\n\
  <Color number=\"2\">#E0EE8F</Color>\n\
  <Color number=\"3\">#ED97EE</Color>\n\
  <Color number=\"4\">#9EEE81</Color>\n\
  <Color number=\"5\">#8FEED3</Color>\n\
  <Color number=\"6\">#E0EE8F</Color>\n\
  <Color number=\"7\">#ED97EE</Color>\n\
  <Color number=\"8\">#9EEE81</Color>\n\
  <Color number=\"9\">#8FEED3</Color>\n\
  <Color number=\"10\">#E0EE8F</Color>\n\
  <Color number=\"11\">#F92F5E</Color>\n\
  <ExecuteInterface>\n\
    <Pal blockname=\"+MENU_NAME+ (PAL +WIDTH+x+HEIGHT+)\">\n\
      <Block name=\"MOVIE_BACKGROUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line of command will convert the background movie&lt;BR&gt;into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">transcode -i -V -J fps 25 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m \"+TEMP_PATH+/audio+MENU_NAME+.wav\" -o background+MENU_NAME+</Command>\n\
      </Block>\n\
      <Block name=\"IMAGE_BACKGROUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line of command will convert the background image&lt;BR&gt;into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+&lt;/p&gt;</Comment>\n\
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F25:1 -A59:54 -I t -L | mpeg2enc -f 8 -n p -o \"+TEMP_PATH+/+MENU_NAME+.m2v\"</Command>\n\
        <Command default=\"true\">jpeg2yuv -n 50 -I p -f 25 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n p -f 8 -o \"+TEMP_PATH+/+MENU_NAME+.m2v\"</Command>\n\
      </Block>\n\
      <Block name=\"EMPTY_SOUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line creates an empty sound file to mix into the menu-movie.&lt;/p&gt;</Comment>\n\
        <Command>arecord -f dat -twav -d 1 | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command default=\"true\">dd if=/dev/zero bs=4 count=1920 | toolame -b128 -s 48 /dev/stdin \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
      </Block>\n\
      <Block name=\"MPLEX\">\n\
        <Comment>&lt;p align=\"center\"&gt;The following command will multiplex the sound file into the menu-movie.&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">mplex -f 8 -o \"+TEMP_PATH+/+MENU_NAME+.mpg\" \"+TEMP_PATH+/+MENU_NAME+.m2v\" +SOUND_LIST+</Command>\n\
      </Block>\n\
      <Block name=\"SPUMUX\">\n\
        <Comment>&lt;p align=\"center\"&gt;Here we use spumux to add the subpicture (buttons) the the mpeg2 video.&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">spumux \"+TEMP_PATH+/+MENU_NAME+.xml\" &lt; \"+TEMP_PATH+/+MENU_NAME+.mpg\" &gt; \"+TEMP_PATH+/+MENU_NAME+_menu.mpg\"</Command>\n\
      </Block>\n\
    </Pal>\n\
    <Ntsc blockname=\"+MENU_NAME+ (NTSC +WIDTH+x+HEIGHT+)\">\n\
      <Block name=\"MOVIE_BACKGROUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line of command will convert the background movie&lt;BR&gt;into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">transcode -i -V -J fps 29.970 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m \"+TEMP_PATH+/audio+MENU_NAME+.wav\" -o background+MENU_NAME+</Command>\n\
      </Block>\n\
      <Block name=\"IMAGE_BACKGROUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line of command will convert the background image&lt;BR&gt;into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+&lt;/p&gt;</Comment>\n\
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F30000:1001 -A10:11 -I t -L | mpeg2enc -f 8 -n n -o \"+TEMP_PATH+/+MENU_NAME+.m2v\"</Command>\n\
        <Command default=\"true\">jpeg2yuv -n 50 -I p -f 29.97 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n n -f 8 -o \"+TEMP_PATH+/+MENU_NAME+.m2v\"</Command>\n\
      </Block>\n\
      <Block name=\"EMPTY_SOUND\">\n\
        <Comment>&lt;p align=\"center\"&gt;This line creates an empty sound file to mix into the menu-movie.&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
        <Command>dd if=/dev/zero bs=4 count=1601.6 | toolame -b128 -s 48 /dev/stdin \"+TEMP_PATH+/+MENU_NAME+.mp2\"</Command>\n\
      </Block>\n\
      <Block name=\"MPLEX\">\n\
        <Comment>&lt;p align=\"center\"&gt;The following command will multiplex the sound file into the menu-movie.&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">mplex -f 8 -o \"+TEMP_PATH+/+MENU_NAME+.mpg\" \"+TEMP_PATH+/+MENU_NAME+.m2v\" +SOUND_LIST+</Command>\n\
      </Block>\n\
      <Block name=\"SPUMUX\">\n\
        <Comment>&lt;p align=\"center\"&gt;Here we use spumux to add the subpicture (buttons) the the mpeg2 video.&lt;/p&gt;</Comment>\n\
        <Command default=\"true\">spumux \"+TEMP_PATH+/+MENU_NAME+.xml\" &lt; \"+TEMP_PATH+/+MENU_NAME+.mpg\" &gt; \"+TEMP_PATH+/+MENU_NAME+_menu.mpg\"</Command>\n\
      </Block>\n\
    </Ntsc>\n\
  </ExecuteInterface>\n\
  <ExecuteInterface>\n\
    <Dvdauthor blockname=\"dvdauthor\" color=\"#F92F5E\">\n\
      <Block>\n\
        <Comment>Here we start dvdauthor with the generated xml file.</Comment>\n\
        <Command>dvdauthor -x \"+DVDAUTHOR_XML+\"</Command>\n\
      </Block>\n\
    </Dvdauthor>\n\
  </ExecuteInterface>\n\
  <ExecuteInterface hidden=\"true\">\n\
    <Burning blockname=\"Burn DVD\" color=\"#E0EE8F\">\n\
      <Block>\n\
        <Comment>Last we burn the DVD.</Comment>\n\
        <Command>growisofs -Z /dev/dvd -dvd-video +PROJECT_PATH+/</Command>\n\
        <Comment>This command will format a empty -RW DVD (only needed for older drives).</Comment>\n\
        <Command>dvd+rw-format -f /dev/srcd0</Command>\n\
        <Comment>This command generates an iso image of the DVD.</Comment>\n\
        <Command>mkisofs -dvd-video -udf -o +TEMP_PATH+/dvd.iso +PROJECT_PATH+/</Command>\n\
        <Comment>This command burns the iso DVD image to DVD</Comment>\n\
        <Command>dvdrecord -dao speed=2 dev=0,0,0 +TEMP_PATH+/dvd.iso</Command>\n\
      </Block>\n\
    </Burning>\n\
  </ExecuteInterface>\n\
</QDVDAuthorInitFile>\n");
  		stream << (const char *)qsResetInitFile << "\n";
		initFile.close();
	}
}

