/****************************************************************************
**
**
** Created: Sun April 11 22:06:51 2004
**      by: Varol Okan using the kate text editor
**
** This class is the main class for the QXine application.
**
** QXine is a small application fostering the xine libraries. It was neccesary
** to have a working interface to movie files for the 'Q' DVD-Author
** application and thus I created a small sub-project called QXine.
**
** From this information you should see why QXine is not a full featured
** video application. Sorry. Anyone interested in creating one though ?
**
****************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qdir.h>
#include <qslider.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qaction.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qfiledialog.h>

#include "qxine_global.h"

#include "qxine.h"
#include "qxinewidget.h"
#include "dialogmovie.h"
#include "dialogaboutqxine.h"
#include "dialogqxinesetup.h"

/*
** Note: The MovieDialog is to be finished in the QDVDAuthor - project,
** of which QXine is only a sub-project.
**
** Note 2: The QXineWidget is going to shrink to the most basic functionality,
**         thus AVOID USING ANY functionality of the current QXineWidget if
**         possible.
*/

QXine::QXine( QWidget* parent, const char* name, WFlags fl )
    : uiQXine ( parent, name, fl )
{
	m_iIsPlaying = STATE_STOPPED;
	m_qsCurrentVideoPlugin = QString ("xshm");
	m_qsCurrentAudioPlugin = QString ("auto");
	// First we should create the XineWidget ...
	m_pXineWidget = new QXineWidget (m_pFramePreview, "XineWidget", m_qsCurrentAudioPlugin, m_qsCurrentVideoPlugin);
	m_pVideoLayout = new QGridLayout( m_pFramePreview, 1, 1, 4, 6, "XineMainLayout");
	m_pVideoLayout->addWidget (m_pXineWidget, 0, 0);
	m_pXineWidget->InitXine();

	// Next we will create the ComboBox in the MenuBar ...
	m_pToolBarPrevious  = new QToolBar (QString("Previous"), this, DockTop);
	m_pToolBarPrevious->setHorizontalStretchable ( true );
	m_pComboPrevious = new QComboBox (m_pToolBarPrevious);
	loadHistory ();

	fileOpenAction->addTo( toolBar );
	fileOpenPrevious->addTo( toolBar );
	fileExitAction->addTo( toolBar );
	m_pActionAbout->addTo( toolBar );

	m_pSliderTime->setRange (0, 65535);
	m_iSpeed = XINE_SPEED_NORMAL;
	
	m_pSliderVolume->setRange(-100, 0);
	m_pSliderVolume->setValue(-80);

	m_pButtonPrev      ->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));
	m_pButtonNext      ->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));
	m_pButtonStop      ->setPaletteBackgroundColor (QColor (COLOR_QUICK_SELECTED));
	m_pButtonPlay      ->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));
	m_pButtonSpeedPlus ->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));
	m_pButtonSpeedMinus->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));

	connect (m_pButtonPrev,       SIGNAL(clicked()), this, SLOT(slotPrev()));
	connect (m_pButtonNext,       SIGNAL(clicked()), this, SLOT(slotNext()));
	connect (m_pButtonStop,       SIGNAL(clicked()), this, SLOT(slotStop()));
	connect (m_pButtonPlay,       SIGNAL(clicked()), this, SLOT(slotPlay()));
	connect (m_pButtonSpeedPlus,  SIGNAL(clicked()), this, SLOT(slotSpeedPlus()));
	connect (m_pButtonSpeedMinus, SIGNAL(clicked()), this, SLOT(slotSpeedMinus()));
	connect (m_pSliderVolume,     SIGNAL(valueChanged(int)), this, SLOT(slotSetVolume(int)));
	connect (m_pSliderTime,       SIGNAL(sliderReleased()), this, SLOT(slotSeekPosition()));
	
	connect (m_pComboPrevious,    SIGNAL(activated(int)), this, SLOT(slotHistory(int)));

	connect (m_pXineWidget,       SIGNAL(signalPlaybackFinished ()), this, SLOT(slotPlaybackFinished()));
	connect (m_pXineWidget,       SIGNAL(signalNewPosition(int, const QString&)), this, SLOT(slotNewPosition(int, const QString&)));
	connect (m_pActionSetup,      SIGNAL(activated()), this, SLOT(slotSetup()));
	connect (m_pActionScreenshot, SIGNAL(activated()), this, SLOT(slotScreenshot()));
}

QXine::~QXine()
{
	saveHistory();
}

void QXine::loadHistory ()
{
	// This function uses the xine-lib functionality, to restore the last iNrOfHistory
	// loaded files.
	xine_cfg_entry_t config;
	config.str_value = 0;
	xine_t *pXineEngine = (xine_t *)m_pXineWidget->GetXineEngine();
	uint t;
	char cBuffer[100];
	QFileInfo fileInfo;
	// First we clear the history ...
	m_listHistory.clear();
	m_pComboPrevious->clear();

	// Done in InitXine ...
//	QString qsConfigFile = QDir::homeDirPath();
//	qsConfigFile.append("/.qdvdauthor/qxine_config");
//	if (QFile::exists(configFile))
//		xine_config_load (xineEngine, configFile);
	// And here we get the last five history files ...
	for (t=0;t<MAX_HISTORY_FILES;t++)	{
		sprintf (cBuffer, "gui.history%d", t+1);
		xine_config_register_string (pXineEngine, cBuffer, "", "History File", "This value holds one History file", 0 , NULL, NULL);
		xine_config_lookup_entry (pXineEngine, cBuffer, &config);
		if (QString(config.str_value).isEmpty())
			continue;
		fileInfo.setFile (config.str_value);
		m_listHistory.append (config.str_value);
		m_pComboPrevious->insertItem(fileInfo.fileName());
	}
}

void QXine::saveHistory ()
{
	uint t;
	char cKey[50];
	xine_cfg_entry_t config;
	xine_t *pXineEngine = (xine_t *)m_pXineWidget->GetXineEngine();

    xine_config_lookup_entry (pXineEngine, "gui.history1", &config);
	config.help = "This value holds one History file";
	config.type = XINE_CONFIG_TYPE_STRING;
	for (t=0;t<m_listHistory.count();t++)	{
		sprintf (cKey, "gui.history%d", t+1);
		xine_config_register_string (pXineEngine, cKey, "", "History File", "This value holds one History file", 0 , NULL, NULL);
//printf ("<%s>=<%s>\n", cKey, (const char *)m_listHistory[t]);
		config.key = cKey;
		config.str_value = (char *)(const char *)m_listHistory[t];
		xine_config_update_entry (pXineEngine, &config);
	}
	QString qsConfigFile = QDir::homeDirPath();
	qsConfigFile.append("/.qdvdauthor/qxine_config");
	xine_config_save (pXineEngine, (const char *)qsConfigFile);
}

// The standard slots implemented in QXine ...
void QXine::fileOpen()
{
	// Here we open the MovieDialog.
	// Note: THe preview depends on the same class as
	// the main VideoDiaplay in QXine, thus please
	// give some time to wrap up development ...
	QStringList listFileTypes;
	listFileTypes.append (tr ("Movie/Image Files (+Movies+ *.bmp *.png *.jpg *.gif *.xbm)"));
	listFileTypes.append (tr ("Movie Files (+Movies+)"));
	listFileTypes.append (tr ("Image Files (*.bmp *.png *.jpg *.gif *.xbm)"));
	listFileTypes.append (tr ("All Files (*)"));

	DialogMovie *pDialog = new DialogMovie(this);
	pDialog->setFileTypes (listFileTypes);
//	pDialog->initMe();
	int iReturn = pDialog->exec();
	if (iReturn == QDialog::Rejected)
		return;
	setFileName (pDialog->getFileName());
}

void QXine::setFileName (QString qsFileName, bool bAddCurrentPath)
{
	m_qsFileName = qsFileName;
	if (bAddCurrentPath)
		addFileToHistory(QDir::currentDirPath() + QString ("/") + m_qsFileName);
	else
		addFileToHistory(m_qsFileName);
}

void QXine::addFileToHistory(QString qsNewFile)
{
	if (qsNewFile.isEmpty())
		return;
	uint t;
	// This function will add the newly selected file name to the history combo box...
	
	// This line will remove any double names of the history
	m_listHistory.remove(qsNewFile);
	// The we check if we reached the max history number
	if (m_listHistory.count() >= MAX_HISTORY_FILES)	{
		QString qsFileToRemove = m_listHistory[0];
		m_listHistory.remove (qsFileToRemove);
	}
	// and finally we add the current file to the top of the pop ...
	m_listHistory.append(qsNewFile);
	m_pComboPrevious->clear();
	QFileInfo fileInfo;
	QString qsFileName;
	int iHistoryCount = m_listHistory.count()-1;
	for (t=0;t<m_listHistory.count();t++)	{
		fileInfo.setFile(m_listHistory[iHistoryCount - t]);
		qsFileName = m_listHistory[iHistoryCount - t];
		// Next we check if we are playing e.g. a DVD a la dvd:/path/VIDEO_TS/
		// in which case we extract dvd:/path
		if (fileInfo.fileName().isEmpty())	{
			int iPos = m_listHistory[iHistoryCount - t].find ("/VIDEO_TS/");
			if (iPos != -1)
				qsFileName = m_listHistory[iHistoryCount - t].left (iPos);
		}
		m_pComboPrevious->insertItem(qsFileName);
	}
	// Okay, we have now the information for the new Movie file to display.
	m_pLabelHeader->setText(QString("<p align=\"center\">%1</p>").arg(m_pComboPrevious->text(0)));
	// And finally we generate a first image ...
	getImage ();
}

void QXine::getImage(uint /* iFrameNumber */)
{
	if (m_qsFileName.isEmpty())
		return;
	// Here we open the stream to grep some infos ...
	if (!xine_open(m_pXineWidget->GetStream(), m_qsFileName ))
		return;
	// Next we get the length information ...
	m_pLabelDuration->setText(m_pXineWidget->GetLengthInfo());
	if (m_pLabelDuration->text().isEmpty())
		m_pLabelDuration->setText("<p align=\"center\">Undef</p>");

	xine_play (m_pXineWidget->GetStream(), 0, 0);
	usleep (100000);
	xine_stop (m_pXineWidget->GetStream());
}

void QXine::slotHistory(int iSelected)
{
	m_qsFileName = m_listHistory[m_listHistory.count() - iSelected - 1];
	addFileToHistory(m_qsFileName);
}

void QXine::slotPrev ()
{
	m_pXineWidget->PlayPreviousChapter();
	colorMovieButtons (m_pButtonPlay);
}

void QXine::slotNext ()
{
	m_pXineWidget->PlayNextChapter();
//	m_pXineWidget->slotPlayBackwards();
	colorMovieButtons (m_pButtonPlay);
}

void QXine::slotStop ()
{
	m_pXineWidget->slotStopPlayback();
	colorMovieButtons (m_pButtonStop);
	m_pButtonPlay->setPixmap (QPixmap ().fromMimeSource("play.png"));
	m_iIsPlaying = STATE_STOPPED;
	m_pSliderTime->setValue(0);
}

void QXine::slotPlay ()
{
	if (m_qsFileName.isEmpty())
		return;
	if (m_iIsPlaying == STATE_PLAYING)	{
		m_iIsPlaying = STATE_PAUSED;
		m_pXineWidget->slotSpeedPause();
		m_pButtonPlay->setPixmap (QPixmap ().fromMimeSource("play.png"));
	}
	else if (m_iIsPlaying == STATE_PAUSED)	{
		m_pXineWidget->slotSpeedNormal();
		m_iIsPlaying = STATE_PLAYING;
	}
	else 	{		
		QString qsFileName = m_qsFileName;
		m_pXineWidget->PlayMRL(qsFileName, "Check this out", false);
		m_iSpeed = XINE_SPEED_NORMAL;
		colorMovieButtons (m_pButtonPlay);
		m_pButtonPlay->setPixmap (QPixmap ().fromMimeSource("pause.png"));
		m_iIsPlaying = STATE_PLAYING;
	}
}

void QXine::slotSpeedPlus ()
{
	float fSpeed = 0.0;
	if (m_iSpeed == XINE_SPEED_PAUSE)	{
		m_iSpeed = XINE_SPEED_SLOW_4;
		fSpeed = 0.25;
	}
	else if (m_iSpeed == XINE_SPEED_SLOW_4)	{
		m_iSpeed = XINE_SPEED_SLOW_2;
		fSpeed = 0.5;
	}
	else if (m_iSpeed == XINE_SPEED_SLOW_2)	{
		m_iSpeed = XINE_SPEED_NORMAL;
		fSpeed = 1.0;
	}
	else if (m_iSpeed == XINE_SPEED_NORMAL)	{
		m_iSpeed = XINE_SPEED_FAST_2;
		fSpeed = 2.0;
	}
	else	{
		m_iSpeed = XINE_SPEED_FAST_4;
		fSpeed = 4.0;
	}

	m_pXineWidget->slotSpeed(m_iSpeed);
//	m_pLabelSpeed->setText(QString("<p align=\"center\">%1</p>").arg(fSpeed));
	colorMovieButtons (m_pButtonSpeedPlus);
}

void QXine::slotSpeedMinus ()
{
	float fSpeed = 1.0;
	if (m_iSpeed == XINE_SPEED_FAST_4)	{
		m_iSpeed = XINE_SPEED_FAST_2;
		fSpeed = 2.0;
	}
	else if (m_iSpeed == XINE_SPEED_FAST_2)	{
		m_iSpeed = XINE_SPEED_NORMAL;
		fSpeed = 1.0;
	}
	else if (m_iSpeed == XINE_SPEED_NORMAL)	{
		m_iSpeed = XINE_SPEED_SLOW_2;
		fSpeed = 0.5;
	}
	else if (m_iSpeed == XINE_SPEED_SLOW_2)	{
		m_iSpeed = XINE_SPEED_SLOW_4;
		fSpeed = 0.25;
	}
	else	{
		m_iSpeed = XINE_SPEED_PAUSE;
		fSpeed = 0.0;
	}

	m_pXineWidget->slotSpeed(m_iSpeed);
//	m_pLabelSpeed->setText(QString("<p align=\"center\">%1</p>").arg(fSpeed));
	colorMovieButtons (m_pButtonSpeedMinus);
}

void QXine::slotPlaybackFinished ()
{
	colorMovieButtons (m_pButtonStop);
	m_pButtonPlay->setPixmap (QPixmap ().fromMimeSource("play.png"));
	m_pSliderTime->setValue(0);
	m_iIsPlaying = STATE_STOPPED;
}

void QXine::colorMovieButtons (void *pButton)
{
	static QPushButton *pPreviousButton = m_pButtonStop;
	pPreviousButton->setPaletteBackgroundColor (QColor (COLOR_QUICK_NORMAL));
	pPreviousButton = (QPushButton *)pButton;
	pPreviousButton->setPaletteBackgroundColor (QColor (COLOR_QUICK_SELECTED));
}

void QXine::slotNewPosition (int iPos, const QString& qsTime)
{
	// iPos [0 .. 65535]
//printf (" QXine::slotNewPosition <%d><%s>\n", iPos, (const char *)qsTime);
	m_pSliderTime->setValue (iPos);
	m_pLabelTime->setText (QString("<p align=\"center\">%1</p>").arg(qsTime));
}

void QXine::slotSetup ()
{
	int t;
	// We open a dialog where the user
	// o	Sees the mime - types
	// o	sees the file extensions
	// o	can select the video driver
	// o	can select the audio driver ...
	/////////////////////////////////////////
	// Here we create the SetupDialog - object
	DialogQXineSetup *pDialog = new DialogQXineSetup (this);

/* get lists of available audio and video output plugins */
	xine_t *pXineEngine = (xine_t *)m_pXineWidget->GetXineEngine();
	QStringList listVideoPlugins;
	QStringList listAudioPlugins;
	QStringList listFileExtensions;
	QStringList listMimeTypes;

	const char *const *ppVideoPlugins = xine_list_video_output_plugins (pXineEngine);
	t = -1;
	while (ppVideoPlugins[++t])	{
		listVideoPlugins.append (ppVideoPlugins[t]);
//printf ("<%d><%s>\n", t, ppVideoPlugins[t]);
	}
	const char *const *ppAudioPlugins = xine_list_audio_output_plugins (pXineEngine);
	t = -1;
	while (ppAudioPlugins[++t])	{
		listAudioPlugins.append (ppAudioPlugins[t]);
//printf ("<%d><%s>\n", t, ppAudioPlugins[t]);
	}

	pDialog->setVideoPlugins   (listVideoPlugins, m_qsCurrentVideoPlugin);
	pDialog->setAudioPlugins   (listAudioPlugins, m_qsCurrentAudioPlugin);
/*	pDialog->setFileExtensions (listFileExtensions);
	pDialog->setMimeTypes      (listMimeTypes);
*/
	if (pDialog->exec() == QDialog::Rejected)
		return;
	if (m_qsCurrentVideoPlugin != pDialog->getVideoPlugin())
		m_pXineWidget->SetVisualPlugin (pDialog->getVideoPlugin());
//	if (m_qsCurrentAudioPlugin != pDialog->getAudioPlugin())
//		m_pXineWidget->setAudioPlugin (pDialog->getAudioPlugin());

	m_qsCurrentVideoPlugin = pDialog->getVideoPlugin();
	m_qsCurrentAudioPlugin = pDialog->getAudioPlugin();
}

void QXine::slotSetVolume (int iVolume)
{
	xine_set_param(m_pXineWidget->GetStream(), XINE_PARAM_AUDIO_VOLUME, -iVolume);
}

void QXine::slotSeekPosition ()
{
	int iPosition = m_pSliderTime->value();
	m_pXineWidget->slotChangePosition(iPosition);
}

void QXine::fileOpenRecent()
{
}

void QXine::fileExit()
{
	close();
}

void QXine::slotScreenshot()
{
	uchar *pRgbPile = NULL;
	int iWidth, iHeight;
	double fScaleFactor;

	m_pXineWidget->GetScreenshot (pRgbPile, iWidth, iHeight, fScaleFactor);
	
	if (!pRgbPile)
		return;
	QImage screenShot(pRgbPile, iWidth, iHeight, 32, 0, 0, QImage::IgnoreEndian);
	if (fScaleFactor >= 1.0)
		iWidth = (int)((double) iWidth * fScaleFactor);
	else
		iHeight = (int) ((double) iHeight / fScaleFactor);

	screenShot = screenShot.smoothScale(iWidth, iHeight);
	
	QString qsFileName = QFileDialog::getSaveFileName("./", tr("Images (*.png *.xpm *.jpg)"), this, tr("save file Dialog"), tr("Save Screenshot under ..."));

	if (qsFileName.isEmpty())
		return;
	QFileInfo fileInfo (qsFileName);
	QString qsExtension = fileInfo.extension();
	qsExtension = qsExtension.upper();
	screenShot.save (qsFileName, qsExtension);

	delete []pRgbPile;	
}

void QXine::helpAbout()
{
	AboutQXine *pDialog = new AboutQXine (this);
	pDialog->show();
}



