/****************************************************************************
** StructureToolBar - class
**
** Created: Tue May 04 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which displays all currently selected
** sources for the DVD, such as all Videos, and all Audio files.
**
** Besides displaying these it will also do some background checks.
** For this it will spawn a new thread, which will analyse the file
** and see if it needs to get converted for a propper usage.
**
** tcscan is your friend.
** 
** The result will be color coded.
** o	Gray, not yet determined
** o	any shades of green -> In DVD format.
** o	any shades of blue  -> will be converted before creating DVD
** o	any shades of red   -> Can not automatically handle this format.
**
****************************************************************************/
#include <stdlib.h>

#include <qmainwindow.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qdockarea.h>

#include "global.h"
#include "sourcetoolbar.h"
#include "dialogslide.h"
#include "qdvdauthor.h"
#include "dialogmovie.h"
#include "listboxcolortext.h"
#include "qplayer/xineinfo.h"


SourceToolBar::SourceToolBar (const QString &qsLabel, QMainWindow *pMainWindow, QWidget *pParent, bool bNewLine, const char *pName, WFlags f)
	: QToolBar (qsLabel, pMainWindow, pParent, bNewLine, pName, f)
{
	m_pDVDAuthor = (QDVDAuthor *)pMainWindow;
	setResizeEnabled (true);
	setMovingEnabled (true);
	pMainWindow->addDockWindow (this, Left);
	m_pSourceWidget = new uiSourceWidget (this);
	m_pSourceWidget->m_pListBoxAllSources->clear ();
	m_pSourceWidget->m_pListBoxAllSources->setColumnMode(QListBox::FixedNumber); //FitToWidth);
	m_pSourceWidget->m_pListViewVideoSources->clear ();
	m_pSourceWidget->m_pListViewAudioSources->clear ();

	connect( m_pSourceWidget->m_pListBoxAllSources, SIGNAL( mouseButtonClicked(int,QListBoxItem*,const QPoint&)), this, SLOT(slotClickedOnVideoList(int,QListBoxItem*,const QPoint&) ) );
//	connect( m_pSourceWidget->m_pListViewVideoSources, SIGNAL( mouseButtonClicked(int,QListBoxItem*,const QPoint&)), this, SLOT(slotClickedOnVideoList(int,QListBoxItem*,const QPoint&) ) );
//	connect( m_pSourceWidget->m_pListViewAudioSources, SIGNAL( mouseButtonClicked(int,QListBoxItem*,const QPoint&)), this, SLOT(slotClickedOnVideoList(int,QListBoxItem*,const QPoint&) ) );

	connect ( m_pSourceWidget->m_pButtonAddMovie, SIGNAL(clicked()), this, SLOT(slotAddMovie()));
	connect ( m_pSourceWidget->m_pButtonAddSlide, SIGNAL(clicked()), this, SLOT(slotAddSlideshow()));
}

SourceToolBar::~SourceToolBar ()
{
	uint t;
	for (t=0;t<m_listSourceFileEntries.count();t++)
		delete m_listSourceFileEntries[t];
	m_listSourceFileEntries.clear();
}

QSize SourceToolBar::sizeHint () const
{
	QSize theSize = QToolBar::sizeHint();
	if ( (area() != 0) && (area()->orientation() == Qt::Vertical) )	// it is docked, make it at least 250 wide
		theSize.setWidth(10);
	return QSize (theSize);
}

QString SourceToolBar::convertFileSize(uint iFileSize)
{
	QString qsReturn;
	if (iFileSize > 1024 * 1024 * 1024)	// GBytes
		qsReturn = qsReturn.sprintf ("%.2f GB", (double)iFileSize / (1024*1024*1024));
	else if (iFileSize > 1024 * 1024)	// GBytes
		qsReturn = qsReturn.sprintf ("%.2f MB", (double)iFileSize / (1024*1024));
	else if (iFileSize > 1024)	// GBytes
		qsReturn = qsReturn.sprintf ("%.2f kB", (double)iFileSize / (1024));
	else
		qsReturn = qsReturn.sprintf ("%.2d Byte", iFileSize);

	return qsReturn;
}

int SourceToolBar::sourceFileCount()
{
	return (int)m_listSourceFileEntries.count();
}

SourceFileEntry *SourceToolBar::sourceFileEntry(uint iEntryNumber)
{
	return m_listSourceFileEntries[iEntryNumber];
}

SourceFileEntry *SourceToolBar::getCurrentSourceFileEntry()
{
	// This function will return the currently selected source file entry ...
	uint t;
	QString qsCurrentText = m_pSourceWidget->m_pListBoxAllSources->currentText();
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		if (m_listSourceFileEntries[t]->qsDisplayName == qsCurrentText)
			return m_listSourceFileEntries[t];
	}
	return NULL;
}

void SourceToolBar::slotClickedOnVideoList(int iButton, QListBoxItem *pItem, const QPoint &thePoint)
{
	// First we check if the item is valid ...
	if (pItem == NULL)	{
		slotAddMovie ();
		return;
	}
	// here we handle the movie - right click ...
	if (iButton == Qt::RightButton)	{
		// Here we pop open the properties dialog for the movie, where you can set
		// o size of movie (resizing tool used = ???
		// o Define Title # / Add Chapters to Title
		
		// Here we find out if we can actually play the file ... Meaning slideshows can not be played !!!
		uint t;
		bool bShow = true;
		for (t=0;t<m_listSourceFileEntries.count();t++)	{
			if (pItem->text() == m_listSourceFileEntries[t]->qsDisplayName)	{
				if (m_listSourceFileEntries[t]->bIsSlideshow)
					bShow = false;
				break;
			}
		}

		QPopupMenu *pMenu = new QPopupMenu(m_pSourceWidget->m_pListBoxAllSources);
		if (bShow)
			pMenu->insertItem ( tr ("Play"), this, SLOT(slotPlayMovie()));
		pMenu->insertItem ( tr ("Edit ...")    , this, SLOT(slotEditMovie()));
		pMenu->insertItem ( tr ("Convert ...") , this, SLOT(slotConvertMovie()));
		pMenu->insertItem ( tr ("Delete")      , this, SLOT(slotDeleteSource()));
		pMenu->exec(thePoint);
	}
	else {

	}
	return;
}

void SourceToolBar::slotAddMovie()
{
	uint t;
	// Some one clicked the "Add Movie" button.
	QString qsFilter = m_pDVDAuthor->getMovieFilter();
	QStringList listAddMovies = QFileDialog::getOpenFileNames (tr("Movie Files (")+qsFilter+QString (")"), m_pDVDAuthor->currentPath(), this, tr("Open file dialog"), tr ("Add To Project ..."));

	if (listAddMovies.count() < 1)
		return;
	QFileInfo fileInfo (listAddMovies[0]);
	QString qsPath = fileInfo.filePath();
	m_pDVDAuthor->setCurrentPath( qsPath );

	// Lets create a new SoourceFileEntry ...
	XineInfo *pXineInfo = new XineInfo (m_pDVDAuthor->getXineEngine());
	SourceFileEntry *pEntry = new SourceFileEntry;
	pEntry->bSoundSource = false;
	SourceFileInfo *pInfo;
	for (t=0;t<listAddMovies.count();t++)	{
		pInfo = new SourceFileInfo;
		pXineInfo->setStream(listAddMovies[t]);

		pInfo->qsFormat     = pXineInfo->getFormat (true);
		pInfo->qsResolution = pXineInfo->getResolutionString ();
		pInfo->qsLength     = pXineInfo->getLengthString ();
		pInfo->qsSize       = pXineInfo->getSizeString();
		pInfo->qsRatio      = pXineInfo->getRatio ();
		pInfo->qsFPS        = QString ("%1").arg(pXineInfo->getFPS());
		pInfo->qsStatus     = pXineInfo->getStatus();
		pInfo->qsFileName   = listAddMovies[t];

		pEntry->listFileInfos.append(pInfo);
	}
	if (listAddMovies.count () > 1)	{
		QString qsText = tr(" Movie Files>");
		pEntry->qsDisplayName.sprintf ("[%02d] - <%02d", getFreeSourceSlot (), listAddMovies.count()) + qsText;	//fileInfo.fileName();
	}
	else
		pEntry->qsDisplayName.sprintf ("[%02d] - %s", getFreeSourceSlot (), (const char *)fileInfo.fileName());
	m_listSourceFileEntries.append(pEntry);
	// Okay, now we should also add this into the list box ...
	delete pXineInfo;
	addMovie (pEntry);
}

int SourceToolBar::getFreeSourceSlot ()
{
	// this function will return a free number according to the SourceEntries currently in the list.
	// Note : a standard entry start like "[xx] - " where xx is a number
	uint t;
	int iPos, iSourceNumber, iInquireNumber;
	bool bOk;
	QString qsPart;
	iInquireNumber = 1;
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		iPos = m_listSourceFileEntries[t]->qsDisplayName.find ("]", 1);
		if (iPos == -1)
			continue;
		qsPart = m_listSourceFileEntries[t]->qsDisplayName.mid (1, iPos-1);
		if (qsPart.isNull ())
			continue;
		iSourceNumber = qsPart.toInt(&bOk);
		if (!bOk)
			continue;
		if (iSourceNumber == iInquireNumber)	{
			iInquireNumber ++;
			t = 0;
		}
	}
	// And at this point we should have a correct number ...
	return iInquireNumber;
//	return m_listSourceFileEntries.count()+1;
}

void SourceToolBar::addMovie (SourceFileEntry *pEntry)
{
	uint t;
	QColor statusColor (COLOR_MOVIE_FILES_OK);

	// And further on to the m_pListViewVideoSources ...
	ListBoxColorText *pListBoxItem;
	SourceFileInfo *pInfo;
	for (t=0;t<pEntry->listFileInfos.count();t++)	{
		pInfo = pEntry->listFileInfos[t];
		// Here we check that ALL sources are ok
		if (pInfo->qsStatus != QString ("Ok"))
			statusColor = QColor(COLOR_MOVIE_FILES_BAD);

		new QListViewItem (m_pSourceWidget->m_pListViewVideoSources, pInfo->qsFormat,
			pInfo->qsResolution, pInfo->qsLength, pInfo->qsSize, pInfo->qsRatio,
			pInfo->qsFPS, pInfo->qsStatus, pInfo->qsFileName);
	}
	pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, statusColor);
	m_pSourceWidget->m_pListBoxAllSources->insertItem(pListBoxItem);
}

void SourceToolBar::appendSourceFileEntry(SourceFileEntry *pEntry)
{
	// This function is called when loading from an XML-project file ???

	m_listSourceFileEntries.append(pEntry);

	ListBoxColorText *pListBoxItem;
	QColor statusColor (COLOR_MOVIE_FILES_OK);
	
//	if (pEntry->listFileInfos[0]->qsSample.isEmpty())	{	// Here we handle a Movie SourceFileEntry ...
	if (!pEntry->bSoundSource)	{	// Here we handle a Movie SourceFileEntry ...
		for (uint t=0;t<pEntry->listFileInfos.count();t++)	{
			if (pEntry->listFileInfos[t]->qsStatus != QString ("Ok"))
				statusColor = QColor (COLOR_MOVIE_FILES_BAD);
		
			SourceFileInfo *pInfo = pEntry->listFileInfos[t];
			new QListViewItem (m_pSourceWidget->m_pListViewVideoSources, pInfo->qsFormat, pInfo->qsResolution, pInfo->qsLength,  pInfo->qsSize, pInfo->qsRatio, pInfo->qsFPS, pInfo->qsStatus, pInfo->qsFileName);
		}
	}
	else	{	// And here we have a Sound SourceFileEntry
		statusColor = QColor (COLOR_SOUND_FILES_OK);
	
		for (uint t=0;t<pEntry->listFileInfos.count();t++)	{
			if (pEntry->listFileInfos[t]->qsStatus != QString ("Ok"))
				statusColor = QColor (COLOR_SOUND_FILES_BAD);
		
			SourceFileInfo *pInfo = pEntry->listFileInfos[t];
			new QListViewItem (m_pSourceWidget->m_pListViewAudioSources, pInfo->qsFormat, pInfo->qsLength, pInfo->qsBits, pInfo->qsSample, pInfo->qsBPS, pInfo->qsSize,  pInfo->qsStatus, pInfo->qsFileName);
		}
	}
	pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, statusColor);
	m_pSourceWidget->m_pListBoxAllSources->insertItem(pListBoxItem);	
}

void SourceToolBar::slotAddSound()
{
	// never used, the real function comes from 
	// QDVDMenu::slotAddSound()->DVDAuthor::addSound()->SourceToolBar::addSound()
	QString qsFilter = m_pDVDAuthor->getSoundFilter();
	// For now we assume this is slotEditAdd()
	QStringList listAddSounds = QFileDialog::getOpenFileNames(tr("Sound Files (")+qsFilter+QString(")"), m_pDVDAuthor->currentPath(), this, tr("Open file dialog"), tr("Add To Project ..."));
	if (listAddSounds.count() < 1)
		return;
	// Okay, now we should also add this into the list box ...
	addSound (listAddSounds);
}

void SourceToolBar::addSound (QStringList &listSoundNames)
{
	uint t;
	QFileInfo fileInfo (listSoundNames[0]);
	QString qsFileName = fileInfo.fileName();

	// And here we set the  current Directory for the application ...
	QString qsPath = fileInfo.filePath();
	m_pDVDAuthor->setCurrentPath( qsPath );

	// Before we insert it we should remove all previous entries so that we hold only one entry for one sound file
	removeEntry (qsFileName);

	XineInfo *pXineInfo = new XineInfo (m_pDVDAuthor->getXineEngine ());
	QColor statusColor (COLOR_SOUND_FILES_OK);
	SourceFileInfo  *pInfo;
	SourceFileEntry *pEntry = new SourceFileEntry;
	pEntry->bSoundSource = true;
	for (t=0;t<listSoundNames.count();t++)	{
		pXineInfo->setStream (listSoundNames[t]);
		// Lets create a new SoourceFileEntry for this sound file ...
		pInfo = new SourceFileInfo;

		pInfo->qsSize     = pXineInfo->getSizeString();
		pInfo->qsBits     = QString ("%1").arg(pXineInfo->getBits());
		pInfo->qsSample   = pXineInfo->getSampleString ();
		pInfo->qsBPS      = pXineInfo->getBPSString (false);
		pInfo->qsLength   = pXineInfo->getLengthString ();
		pInfo->qsFormat   = pXineInfo->getFormat (false);
		pInfo->qsStatus   = pXineInfo->getStatus();
		pInfo->qsFileName = listSoundNames[t];

		if (pInfo->qsStatus != QString ("Ok"))
			statusColor = QColor (COLOR_SOUND_FILES_BAD);

		pEntry->listFileInfos.append (pInfo);
	}
	if (listSoundNames.count () > 1)	{
		QString qsText = tr(" Sound Files>");
		pEntry->qsDisplayName.sprintf ("[%02d] - <%02d", getFreeSourceSlot (), listSoundNames.count()) + qsText;
	}
	else
		pEntry->qsDisplayName.sprintf ("[%02d] - %s",getFreeSourceSlot (), (const char *)fileInfo.fileName());
	m_listSourceFileEntries.append(pEntry);

	// And finally we add it to the list ...
	ListBoxColorText *pListBoxItem;
	pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, statusColor);
	m_pSourceWidget->m_pListBoxAllSources->insertItem(pListBoxItem);

	// And further on to the m_pListViewVideoSources ...
	new QListViewItem (m_pSourceWidget->m_pListViewAudioSources, pInfo->qsFormat, pInfo->qsLength, pInfo->qsBits, pInfo->qsSample, pInfo->qsBPS, pInfo->qsSize,  pInfo->qsStatus, pInfo->qsFileName);
	delete pXineInfo;
}

void SourceToolBar::slotAddSlideshow()
{
printf ("SourceToolBar::slotAddSlideshow\n");
	// First we pop up the slideshow generation dialog box
	QString qsTempPath = m_pDVDAuthor->getTempFile(QString ());
	CSlideDialog *pSlideDialog = new CSlideDialog;
	pSlideDialog->initMe(this, qsTempPath);
	pSlideDialog->show();
	// Note that the SourceFileEntry is generated  when we have given a name to the
	// newly generated slideshow. This is then done SourceToolBar::slotAddSlideshow(QString);
}


void SourceToolBar::slotEditMovie()
{
	// Here we open the MovieDialog.
	// Note: The preview depends on the same class as
	// the main QXineWidget in QXine, thus please
	// give some time to wrap up development ...
	QStringList listFileTypes;
	SourceFileEntry *pEntry = m_listSourceFileEntries[m_pSourceWidget->m_pListBoxAllSources->currentItem ()];
	QString qsOriginalDisplayName = pEntry->qsDisplayName;
	listFileTypes.append (tr ("Movie/Image Files (+Movies+ *.bmp *.png *.jpg *.gif *.xbm)"));
	listFileTypes.append (tr ("Movie Files (+Movies+)"));
	listFileTypes.append (tr ("Image Files (*.bmp *.png *.jpg *.gif *.xbm)"));
	listFileTypes.append (tr ("All Files (*)"));

	// Here we try to find out if we have a movie or a sound ...
	int iWhichTab = SOURCE_FILE_TAB;
	int iCurrent = m_pSourceWidget->m_pListBoxAllSources->currentItem ();
	if (	(iCurrent < (int)m_listSourceFileEntries.count ()) &&
			(m_listSourceFileEntries[iCurrent]->bSoundSource) )
		iWhichTab = SOUND_OPTIONS_TAB;


	DialogMovie *pDialog = new DialogMovie(m_pDVDAuthor->getXineEngine (), this, iWhichTab);
	pDialog->setFileTypes (listFileTypes);
	pDialog->setSourceFileEntries(m_listSourceFileEntries,  m_pSourceWidget->m_pListBoxAllSources->currentItem ());

	int iReturn = pDialog->exec();
	if (iReturn == QDialog::Rejected)
		return;
	refreshToolBarEntries();
	// Here we check if the DisplayName has been changed. Note that the pointer has not changed, only the values.
	if ( (qsOriginalDisplayName != pEntry->qsDisplayName) && (m_pDVDAuthor) )
			m_pDVDAuthor->replaceSourceDisplayName(qsOriginalDisplayName, pEntry->qsDisplayName);

	delete pDialog;
}

void SourceToolBar::refreshToolBarEntries()
{
	uint t, i;
	QColor statusColor;
	ListBoxColorText *pListBoxItem;
	SourceFileEntry *pEntry;
	SourceFileInfo *pInfo;
	// This function will remove all entries from all listBox objects and re-create all information from
	// The current m_listSourceFileEntries.
	m_pSourceWidget->m_pListBoxAllSources->clear ();
	m_pSourceWidget->m_pListViewVideoSources->clear ();
	m_pSourceWidget->m_pListViewAudioSources->clear ();
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		pEntry = m_listSourceFileEntries[t];
		// Okay here we decide if we have a Movie or sound stream ...
//		if (pEntry->listFileInfos[0]->qsSample.isEmpty())	{
		if (!pEntry->bSoundSource)	{
			statusColor = QColor(COLOR_MOVIE_FILES_OK);
			for (i=0;i<pEntry->listFileInfos.count();i++)	{
				pInfo = pEntry->listFileInfos[i];
				// Here we check that ALL sources are ok
				if (pInfo->qsStatus != QString ("Ok"))
					statusColor = QColor(COLOR_MOVIE_FILES_BAD);

				new QListViewItem (m_pSourceWidget->m_pListViewVideoSources, pInfo->qsFormat,
					pInfo->qsResolution, pInfo->qsLength, pInfo->qsSize, pInfo->qsRatio,
					pInfo->qsFPS, pInfo->qsStatus, pInfo->qsFileName);
			}
		}
		else 	{
			statusColor = QColor (COLOR_SOUND_FILES_OK);
			for (i=0;i<pEntry->listFileInfos.count();i++)	{
				pInfo = pEntry->listFileInfos[i];
				if (pInfo->qsStatus != QString ("Ok"))
					statusColor = QColor (COLOR_SOUND_FILES_BAD);

				new QListViewItem (m_pSourceWidget->m_pListViewAudioSources, pInfo->qsFormat,
					pInfo->qsLength, pInfo->qsBits, pInfo->qsSample, pInfo->qsBPS,
					pInfo->qsSize,  pInfo->qsStatus, pInfo->qsFileName);
			}
		}
		pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, statusColor);
		m_pSourceWidget->m_pListBoxAllSources->insertItem(pListBoxItem);
	}
}

void SourceToolBar::slotConvertMovie()
{
	// Called when the user right clicks in the SourceFileEntry - list
	QMessageBox::warning (NULL, tr ("Not implemented yet."),
		tr ("This function is not implemented yet."), QMessageBox::Ok, QMessageBox::NoButton);
}

void SourceToolBar::slotDeleteSource()
{
	QString qsCurrentText = m_pSourceWidget->m_pListBoxAllSources->currentText();
	// Called when the user right clicks in the SourceFileEntry - list
	if ( (!getCurrentSourceFileEntry()->bSoundSource) && (m_pDVDAuthor) )	{
		
		// Okay we should politely check if this source is in use by a button.
		if (m_pDVDAuthor->isSourceEntryUsed(qsCurrentText))
			if (QMessageBox::warning (NULL, tr ("Warning, This source is in use."),
				tr ("This Source is in use.\nDo you realy want to delete this source ?\n"), 
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::No)
					return;
	}
	
	removeEntry (qsCurrentText, false);
}

void SourceToolBar::removeEntry (QString &qsEntry, bool bSourceOnly)
{
	uint t;
	SourceFileEntry *pSourceFileEntry = NULL;
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		if (m_listSourceFileEntries[t]->qsDisplayName == qsEntry)	{
			// Here we remove this entry from the m_listSourceFileEntris - list.
			pSourceFileEntry = m_listSourceFileEntries[t];
			m_listSourceFileEntries.remove (pSourceFileEntry);
		}
	}
	for (t=0;t<m_pSourceWidget->m_pListBoxAllSources->count();t++)	{
		if (m_pSourceWidget->m_pListBoxAllSources->text(t) == qsEntry)	{
			// Here we remove this entry from m_pListBoxVideos - widget.
			m_pSourceWidget->m_pListBoxAllSources->removeItem (t);
		}
	}
	if (!pSourceFileEntry)
		return;
	QValueList<QListViewItem *> listDelItems;
	QListViewItem *pItem = m_pSourceWidget->m_pListViewVideoSources->firstChild();
	while (pItem)	{
		// Here we remove this entry from m_pListBoxVideos - widget.
		for (t=0;t<pSourceFileEntry->listFileInfos.count();t++)	{
			if (pItem->text(MOVIE_FILE_NAME_INDEX) == pSourceFileEntry->listFileInfos[t]->qsFileName)	{
				listDelItems.append(pItem);
				// FIXME: If we use SourceFileEntry->qsDisplay name rather then the single filename, we are better off here
				//        Since we remove only the associated files and leave the others untouched.
				// Okay if the user has the same file multiple times in there we only want to remove the entry once.
				pSourceFileEntry->listFileInfos[t]->qsFileName = QString ("");
			}
		}
		pItem = pItem->nextSibling();
	}
	// And here we delete the items
	for (t=0;t<listDelItems.count();t++)	{
		delete listDelItems[t];
	}
	listDelItems.clear();
	pItem = m_pSourceWidget->m_pListViewAudioSources->firstChild();
	while (pItem)	{
		// Here we remove this entry from m_pListBoxVideos - widget.
		for (t=0;t<pSourceFileEntry->listFileInfos.count();t++)	{
			if (pItem->text(AUDIO_FILE_NAME_INDEX) == pSourceFileEntry->listFileInfos[t]->qsFileName)	{
				listDelItems.append(pItem);
				// Okay if the user has the same file multiple times in there we only want to remove the entry once.
				pSourceFileEntry->listFileInfos[t]->qsFileName = QString ("");
			}
		}
		pItem = pItem->nextSibling();
	}
	for (t=0;t<listDelItems.count();t++)
		delete listDelItems[t];
	// If we should only remove the entry in the SoureToolBar and leave the ones in QDVDAuthor as is
	// This is the case when we create a new entry. The first thing done is to remove all
	// double entries but we want to leave the entries in the Menus intact.
	if (m_pDVDAuthor && !bSourceOnly)
		// So the user has decided to delete this source, then we should change the assoziated
		// buttons - action !!!
		m_pDVDAuthor->removedSourceEntry(pSourceFileEntry);

	// At this point we can delete the pSourceFileEntry ...
	delete pSourceFileEntry;
}


void SourceToolBar::slotPlayMovie()
{
	// Called when the user right clicks in the SourceFileEntry - list
	uint t, i;
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		if (m_pSourceWidget->m_pListBoxAllSources->currentText() == m_listSourceFileEntries[t]->qsDisplayName)	{
			// Here we execute the external QXine video viewer application ...
			
			// First let us find out if the application exists after all ...
//			QFileInfo fileInfo("qplayer");
//			if (!fileInfo.exists ())
//				QMessageBox::warning (NULL, QString ("Error.."),
//					QString ("Could not find qplayer application."), QMessageBox::Ok, QMessageBox::Ok);
//			else
//				QMessageBox::warning (NULL, QString ("Cool .."),
//					QString ("Stuhl ...."), QMessageBox::Ok, QMessageBox::Ok);
					
			QString qsCommand ("qplayer ");
			for (i=0;i<m_listSourceFileEntries[t]->listFileInfos.count();i++)
				qsCommand += QString ("\"%1\" ").arg(m_listSourceFileEntries[t]->listFileInfos[i]->qsFileName);
			qsCommand += QString (" &");
			system ((const char *)qsCommand);
			// Finally leave the loop.
			break;
		}
	}
}

// the following two functions are called from CSlideDialog, if avail ...
void SourceToolBar::slotAddSlideshow (QString qsSlideshowName)
{
printf ("SourceToolBar::slotAddSlideshow <%s>\n", (const char *)qsSlideshowName);
	// Lets create a new SourceFileEntry ...
	SourceFileEntry *pEntry = new SourceFileEntry;
	SourceFileInfo  *pInfo = new SourceFileInfo;
	pEntry->bIsSlideshow = true;
	pInfo->qsFileName = qsSlideshowName;
	pEntry->listFileInfos.append(pInfo);
	pEntry->qsDisplayName.sprintf ("[%02d] - %s", getFreeSourceSlot (), (const char *)qsSlideshowName);
//	pEntry->qsDisplayName = qsSlideshowName;	// E.g. slideshow.xml
	m_listSourceFileEntries.append(pEntry);
	// Okay, now we should also add this into the list box ...
	ListBoxColorText *pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, QColor (COLOR_SLIDE_FILES_OK));
	m_pSourceWidget->m_pListBoxAllSources->insertItem(pListBoxItem);
}

void SourceToolBar::slotSlideshowDone(QString qsSlideshowName)
{
printf ("SourceToolBar::slotSlideshowDone <%s>\n", (const char *) qsSlideshowName);
	uint t, iListBoxPosition = 0;
	SourceFileEntry *pEntry;
	for (t=0;t <m_pSourceWidget->m_pListBoxAllSources->count();t++)	{
		if (m_pSourceWidget->m_pListBoxAllSources->text(t) == qsSlideshowName)	{
			iListBoxPosition = t;
			break;
		}
	}	
	for (t=0;t<m_listSourceFileEntries.count();t++)	{
		pEntry = m_listSourceFileEntries[t];
		if (pEntry->qsDisplayName == qsSlideshowName)	{
			// First thing we should modify the name displayed ...
			pEntry->qsDisplayName = qsSlideshowName + QString (".mpeg");
			// Next we determine the fileName of the generated mpeg video ...
			QFileInfo fileInfo (pEntry->listFileInfos[0]->qsFileName);
			pEntry->listFileInfos[0]->qsFileName = m_pDVDAuthor->getTempFile(fileInfo.fileName()+QString (".mpeg"));
			pEntry->bIsSlideshow = false;	// now we hold a mpeg and not a xml - file ...
			pEntry->bSoundSource = false;

			ListBoxColorText *pListBoxItem = new ListBoxColorText (pEntry->qsDisplayName, QColor (COLOR_MOVIE_FILES_OK));
			m_pSourceWidget->m_pListBoxAllSources->changeItem (pListBoxItem, iListBoxPosition);
//			m_pListBoxVideos->insertItem(pListBoxItem);
			return;
		}
	}
}

void SourceToolBar::clear ()
{
	uint t;
	for (t=0;t<m_listSourceFileEntries.count();t++)
		delete m_listSourceFileEntries[t];
	m_listSourceFileEntries.clear();

	m_pSourceWidget->m_pListBoxAllSources->clear();
	m_pSourceWidget->m_pListViewVideoSources->clear();
	m_pSourceWidget->m_pListViewAudioSources->clear();
}
