/****************************************************************************
** StructureToolBar - class
**
** Created: Tue May 04 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/
#include <qmainwindow.h>
#include <qlistview.h>

#include "structuretoolbar.h"

StructureToolBar::StructureToolBar (const QString &qsLabel, QMainWindow *pMainWindow, QWidget *pParent, bool bNewLine, const char *pName, WFlags f)
	: QToolBar (qsLabel, pMainWindow, pParent, bNewLine, pName, f)
{
	setResizeEnabled (true);
	setMovingEnabled (true);
	pMainWindow->addDockWindow (this, Left);
	m_pListViewStructure = new QListView( this, "m_pListViewStructure" );
	m_pListViewStructure->addColumn( tr( "Object" ) );
	m_pListViewStructure->addColumn( tr( "Name" ) );
//	m_pListViewStructure->setMinimumHeight (10);
}

StructureToolBar::~StructureToolBar ()
{

}

QListView *StructureToolBar::listView()
{
	return m_pListViewStructure;
}

QSize StructureToolBar::sizeHint () const
{
//	return QSize (QToolBar::sizeHint().width(), 200);
	return QSize (250, 200);
}



