/****************************************************************************
** Interface to the GUI.
**
** Created: Wed March 16 22:48:00 2005
**      by: Varol Okan using kate editor
**
**
****************************************************************************/

#ifndef DIALOGMOVIE_H
#define DIALOGMOVIE_H

#include <qlistview.h>

#include "sourcefileentry.h"
#include "uidialogmovie.h"

class MovieObject;
class DVDMenu;
class MediaInterface;
class StartStopControl;

class ListViewColorItem : public QListViewItem
{
public:
	ListViewColorItem (QListView *, QColor, QString, QString l2=QString::null, QString l3=QString::null, QString l4=QString::null,
		QString l5=QString::null, QString l6=QString::null, QString l7=QString::null, QString l8=QString::null);

	virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int);
private:
	QColor m_theColor;
};

class DialogMovie : public uiDialogMovie
{
	Q_OBJECT
public:
	 DialogMovie(QWidget *p=NULL, const char *n=NULL, WFlags f=0);
	~DialogMovie();

	void initMe(SourceFileInfo  *, const void *, int);
	void initMe(SourceFileEntry *);
	void initMe(MovieObject     *);
	void initMe(DVDMenu         *);
	void initMediaInterface(DVDMenu *);

	bool transcodeEnabled ();
	void initTranscodeTab ();
	
	SourceFileInfo *sourceFileInfo ();

protected slots:
	virtual void slotNewVolume (int);
	virtual void accept        ();
	virtual void slotBlink     ();
	virtual void slotWidth     ();
	virtual void slotHeight    ();
	virtual void slotPlay      ();
	virtual void slotStop      ();
	virtual void slotStart     ();
	virtual void slotEnd       ();
	virtual void slotTranscode ();
	virtual void slotEncodeNow ();

	virtual void slotAddChapter   ();
	virtual void slotDelChapters  ();
	virtual void slotAutoChapters ();
	virtual void slotAnimation    ();
	virtual void slotSizeDialog   ();
	virtual void slotCurrentChanged (QListBoxItem *);

	
	virtual void slotNewPosition(int, const QString&);
	virtual void slotSliderValues (float, float);

	virtual void slotVideoOutChanged        (const QString &);
	virtual void slotVideoResolutionChanged (const QString &);
	virtual void slotVideoRateChanged       (const QString &);
	virtual void slotVideoTypeChanged       (const QString &);
	virtual void slotVideoAspectChanged     (const QString &);
	virtual void slotVideoBitrateChanged    (const QString &);
	virtual void slotAudioOutChanged        (const QString &);
	virtual void slotAudioTypeChanged       (const QString &);
	virtual void slotAudioBitrateChanged    (const QString &);
	virtual void slotSetStartStop           ();

	virtual void slotAddColorKey ();
	virtual void slotDelColorKey ();
	virtual void slotBrowseColorKey ();

private:
	long normToLong ( QString qsInput );
	QString longToNorm  ( long iInput );
	void setStartStop          ( bool );

private:
	QRect             m_rectGeometry;
	QString           m_qsFileName;
	QString           m_qsPosition;
	int               m_iMovieLength;
	QWidget          *m_pTranscodeTab;
	MediaInterface   *m_pMediaInterface;
	StartStopControl *m_pStartStopControl;
	SourceFileInfo    m_sourceFileInfo;
	MovieObject      *m_pMovieObject;
	DVDMenu          *m_pDVDMenu;
};

#endif // DIALOGMOVIE_H
