/****************************************************************************
** DialogMovieObject class
**
** Created: Wed Jan 26 22:48:00 2005
**      by: Varol Okan using Kate
**
**
****************************************************************************/
#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qdatetime.h>
#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include "dvdmenu.h"
#include "qdvdauthor.h"
#include "qplayer/mediainfo.h"
#include "qplayer/mediacreator.h"
#include "qplayer/startstopcontrol.h"
#include "qplayer/engines/mediainterface.h"

#include "dialogmovieobject.h"
#include "movieobject.h"
#include "dvdmenu.h"

DialogMovieObject::DialogMovieObject(QWidget * parent, const char * name, WFlags f)
	: uiDialogMovieObject (parent, name, f)
{
	m_pMediaInterface   = NULL;
	m_pStartStopControl = NULL;
	m_iMovieLength      =    0;
	connect (m_pEditWidth,   SIGNAL(lostFocus ()), this, SLOT(slotWidth  ()));
	connect (m_pEditHeight,  SIGNAL(lostFocus ()), this, SLOT(slotHeight ()));
	connect (m_pButtonPlay,  SIGNAL(clicked ()),   this, SLOT (slotPlay ()));
	connect (m_pButtonStop,  SIGNAL(clicked ()),   this, SLOT (slotStop ()));
	connect (m_pButtonStart, SIGNAL(clicked ()),   this, SLOT (slotStart()));
	connect (m_pButtonEnd,   SIGNAL(clicked ()),   this, SLOT (slotEnd  ()));

}

DialogMovieObject::~DialogMovieObject()
{
	delete m_pMediaInterface;
	delete m_pStartStopControl;
}

void DialogMovieObject::initMe(DVDMenu *pMenu)
{
	if (!pMenu)
		return;
	if ( (pMenu->getInterface()->qsMovieFileName.isNull()) && (pMenu->getInterface()->qsBackgroundFileName.isNull()) )
		return;
	QFileInfo fileInfo;
	QString qsFormat, qsBackgroundName;

	qsFormat = QString ("hh:mm:ss.zzz");
	QTime endingTime = pMenu->getInterface()->timeOffset.addMSecs(-pMenu->getInterface()->timeDuration.msecsTo(QTime()));
	m_pEditStarting->setText (pMenu->getInterface()->timeOffset.toString(qsFormat));
	m_pEditEnding  ->setText (endingTime.toString (qsFormat));

	m_pEditX      ->hide();
	m_pEditY      ->hide();
	m_pEditWidth  ->hide();
	m_pEditHeight ->hide();
	m_pLabelX     ->hide();
	m_pLabelY     ->hide();
	m_pLabelWidth ->hide();
	m_pLabelHeight->hide();
	m_pCheckAspect->hide();	

	MediaInfo *pMediaInfo    = pMenu->getDVDAuthor()->getMediaInfo ();
	void      *pExistingMediaEngine = pMediaInfo->getMediaEngine   ();
	// Here we create the MediaInterface (the widget) If the mediaengine in NULL or not ...
	m_pMediaInterface = MediaCreator::createPreferredWidget (m_pMediaPreview, "ChapterXineWidget", pExistingMediaEngine);
	connect (m_pMediaInterface, SIGNAL(signalNewPosition(int, const QString&)), this, SLOT(slotNewPosition(int, const QString&)));
	QGridLayout *pVideoLayout = new QGridLayout (m_pMediaPreview, 1, 1, 2, 2, "MediaMainLayout");
	pVideoLayout->addWidget (m_pMediaInterface->getWidget(), 0, 0);
	// This is take care of in the polish () function for Xine and not necessary for MPlayer ...
	m_pMediaInterface->initMediaEngine();

	m_pMediaInterface->openMRL (m_qsFileName);
	m_pMediaInterface->getScreenshot  ();
	if (pMenu->getInterface()->qsMovieFileName.isNull())
		m_qsFileName = pMenu->getInterface()->qsBackgroundFileName;
	else
		m_qsFileName = pMenu->getInterface()->qsMovieFileName;
	fileInfo.setFile (m_qsFileName);
	qsBackgroundName = QString (" : %1 <%2>").arg(fileInfo.fileName()).arg(pMenu->getInterface()->timeDuration.toString(qsFormat));

	m_pTextTitle->setText (pMenu->name() + qsBackgroundName);

	// Here we ensure the availability of a MediaInfo - object
	if (!pMediaInfo)
		pMediaInfo =  m_pMediaInterface->getMediaInfo ();
	if (!pMediaInfo)
		return;

	// here we extract some information + the screenshot.
	pMediaInfo->setFileName (m_qsFileName);
	qsBackgroundName = QString (" : %1 <%2>").arg(fileInfo.fileName()).arg(pMediaInfo->getLengthString());
	m_iMovieLength = pMediaInfo->getLength ();

	m_pTextTitle->setText (pMenu->name() + qsBackgroundName);

	// This is the new version, where I have a new WidgetControl.
	QGridLayout *pLayout = new QGridLayout( m_pFrameControl, 1, 1, 2, 2, "pLayout");
	m_pStartStopControl = new StartStopControl ( m_pFrameControl );
	m_pStartStopControl->initMe (m_qsFileName, pMenu->getDVDAuthor()->getDragNDropContainer()->sizeThumbnail.width(), pMediaInfo->getLength());
	pLayout->addWidget( m_pStartStopControl, 0, 0 );

	connect (m_pStartStopControl, (SIGNAL (signalSliderValues (float, float))), this, SLOT(slotSliderValues(float, float)));
}

void DialogMovieObject::initMe(MovieObject *pMovieObject)
{
	if (!pMovieObject)
		return;
	QString qsFormat;
	m_pEditX->setText (QString ("%1").arg(pMovieObject->rect().x()));
	m_pEditY->setText (QString ("%1").arg(pMovieObject->rect().y()));
	m_pEditWidth ->setText (QString ("%1").arg(pMovieObject->rect().width()));
	m_pEditHeight->setText (QString ("%1").arg(pMovieObject->rect().height()));
	
	qsFormat = QString ("hh:mm:ss.zzz");
	QTime endingTime = pMovieObject->offset().addMSecs(-pMovieObject->duration().msecsTo(QTime()));
	m_pEditStarting->setText (pMovieObject->offset().toString(qsFormat));
	m_pEditEnding  ->setText (endingTime.toString (qsFormat));

	m_rectGeometry = pMovieObject->rect();
	m_qsFileName   = pMovieObject->fileName();

	QFileInfo fileInfo(m_qsFileName);
	// and now on to initializing the dialog. Length : 00:07:23.123 File : Cool Video.mpg
	m_pTextTitle->setText (tr ("File : %1").arg(fileInfo.fileName()));

	// we'll init the MediaEngine here
	DVDMenu   *pDVDMenu             = pMovieObject->dvdMenu();
	MediaInfo *pMediaInfo           = NULL;
	void      *pExistingMediaEngine = NULL;
	if (pDVDMenu)	{
		pMediaInfo = pDVDMenu->getDVDAuthor()->getMediaInfo   ();
		pExistingMediaEngine = pMediaInfo->getMediaEngine     ();
	}
	// Here we create the MediaInterface (the widget) If the mediaengine in NULL or not ...
	m_pMediaInterface = MediaCreator::createPreferredWidget (m_pMediaPreview, "ChapterXineWidget", pExistingMediaEngine);
	connect (m_pMediaInterface, SIGNAL(signalNewPosition(int, const QString&)), this, SLOT(slotNewPosition(int, const QString&)));
	QGridLayout *pVideoLayout = new QGridLayout (m_pMediaPreview, 1, 1, 2, 2, "MediaMainLayout");
	pVideoLayout->addWidget (m_pMediaInterface->getWidget(), 0, 0);
	// This is take care of in the polish () function for Xine and not necessary for MPlayer ...
	m_pMediaInterface->initMediaEngine();

	m_pMediaInterface->openMRL (m_qsFileName);
	m_pMediaInterface->getScreenshot  ();

	// Here we ensure the availability of a MediaInfo - object
	if (!pMediaInfo)
		pMediaInfo =  m_pMediaInterface->getMediaInfo ();
	if (!pMediaInfo)
		return;

	// here we extract some information + the screenshot.
	pMediaInfo->setFileName (pMovieObject->fileName ());
	m_pTextTitle->setText (tr ("Length : <%1> File : %2").arg(pMediaInfo->getLengthString()).arg(fileInfo.fileName()));
	m_iMovieLength = pMediaInfo->getLength ();

	QGridLayout *pLayout = new QGridLayout( m_pFrameControl, 1, 1, 2, 2, "pLayout");
	m_pStartStopControl = new StartStopControl ( m_pFrameControl );
	m_pStartStopControl->initMe (m_qsFileName, pDVDMenu->getDVDAuthor()->getDragNDropContainer()->sizeThumbnail.width(), pMediaInfo->getLength());
	pLayout->addWidget( m_pStartStopControl, 0, 0 );

	connect (m_pStartStopControl, (SIGNAL (signalSliderValues (float, float))), this, SLOT(slotSliderValues(float, float)));
}

void DialogMovieObject::slotWidth()
{
	if (m_pCheckAspect->isChecked())	{
		float fAspect = (float)m_rectGeometry.height() / (float)m_rectGeometry.width();
		int iWidth = m_pEditWidth->text().toInt();
		m_pEditHeight->setText (QString ("%1").arg((int)(fAspect * iWidth)));
	}
}

void DialogMovieObject::slotHeight()
{
	if (m_pCheckAspect->isChecked())	{
		float fAspect = (float)m_rectGeometry.width() / (float)m_rectGeometry.height();
		int iHeight = m_pEditHeight->text().toInt();
		m_pEditWidth->setText (QString ("%1").arg((int)(fAspect * iHeight)));
	}
}

void DialogMovieObject::slotPlay  ()
{
	if (m_pMediaInterface)	{
		if      (m_pMediaInterface->isPaused ())
			 m_pMediaInterface->play ();
		else if (m_pMediaInterface->isPlaying())
			 m_pMediaInterface->pause();
		else
			m_pMediaInterface->playMRL(m_qsFileName);
	}
}

void DialogMovieObject::slotStop  ()
{
	if (m_pMediaInterface)
		m_pMediaInterface->stop ();
}

void DialogMovieObject::slotStart ()
{
	// This function will set the Start offset of the video clip
	if (m_qsPosition.length () < 8)
		m_pEditStarting->setText (QString ("0") + m_qsPosition + QString (".000"));
	else
		m_pEditStarting->setText (m_qsPosition);
	// But we also need to make sure that the start is not set before the end ...
	setStartStop (true);
}

void DialogMovieObject::slotEnd   ()
{
	if (m_qsPosition.length () < 8)
		m_pEditEnding->setText (QString ("0") + m_qsPosition + QString (".000"));
	else
		m_pEditEnding->setText (m_qsPosition);
	// But we also need to make sure that the end is not set before the start ...
	setStartStop (false);
}

void DialogMovieObject::setStartStop (bool bStart)
{
	QTime zeroTime;
	QTime startTime = QTime::fromString (m_pEditStarting->text());
	QTime endTime   = QTime::fromString (m_pEditEnding  ->text());
	if (endTime < startTime)	{
		if (bStart)
			m_pEditEnding->setText (m_pEditStarting->text());
		else
			m_pEditStarting->setText (m_pEditEnding->text());
	}
	// and last but not least we should set the slider controls ...
	int iStartTime = zeroTime.msecsTo (startTime);	
	int iEndTime   = zeroTime.msecsTo   (endTime);	
	float fPercentage = (float)iStartTime / (float)m_iMovieLength;
	m_pStartStopControl->setStart (fPercentage);
	fPercentage = (float)iEndTime / (float)m_iMovieLength;
	m_pStartStopControl->setEnd   (fPercentage);
}

void DialogMovieObject::slotSliderValues (float fStart, float fEnd)
{
	// This function is called when the user uses the slider controls (values in percentage)
	QTime zeroTime;
	QTime startTime;
	QTime endTime;
	QString qsFormat ("hh:mm:ss.zzz");
	startTime = startTime.addMSecs ((int)(fStart * m_iMovieLength));
	endTime = endTime.addMSecs ((int)(fEnd   * m_iMovieLength));
	m_pEditStarting->setText (startTime.toString (qsFormat));
	m_pEditEnding->setText (endTime.toString (qsFormat));
}

void DialogMovieObject::slotNewPosition(int, const QString &qsPosition)
{
	m_qsPosition = qsPosition;
	if (m_qsPosition.length() == 8)
		m_qsPosition += ".000";

	m_pLabelCurrentPos->setText ("<p align=\"center\">" + m_qsPosition + "</p>");
	if (m_iMovieLength == 0)
		return;
	QTime curTime = QTime::fromString(qsPosition);
	QTime zeroTime;
	int iCurTime = zeroTime.msecsTo (curTime);	
//printf ("DialogMovieObject::slotNewPosition <%s> <%d><%d>\n", (const char *)curTime.toString(), m_iMovieLength, iCurTime);
	float fPercentage = (float)iCurTime / (float)m_iMovieLength;
	m_pStartStopControl->setProgress (fPercentage);
}

