/*****************************************************************************
 ** Class Import::Kino
 **
 ** This class handles the import filter for kino's smil format.
 ** Please note that the actual SMIL format is extensive and HUGE
 ** ( check http://www.w3.org/2001/SMIL20/Language )
 **
 ** I am only implementing a basic SMIL format to handle ...
 ** 
 ** <?xml version="1.0"?>
 ** <smil xmlns:smil2="http://www.w3.org/2001/SMIL20/Language">
 **   <seq>
 **     <video src="/home/varol/dvdproject/kino/At The Beach001.dv" clipBegin="0" clipEnd="3594"/>
 **   </seq>
 **   <seq>
 **     <video src="/home/varol/dvdproject/kino/At The Beach002.dv" clipBegin="0" clipEnd="6999"/>
 **   </seq>
 ** </smil>
 *****************************************************************************/

#ifndef __IMPORT_KINO_H__
#define __IMPORT_KINO_H__

#define SMIL_SMIL        "smil"
#define SMIL_SEQ         "seq"
#define SMIL_VIDEO       "video"

#define ATTRIB_SRC       "src"
#define ATTRIB_CLIPBEGIN "clipBegin"
#define ATTRIB_CLIPEND   "clipEnd"
#define ATTRIB_TITLE     "title" 
#define ATTRIB_AUTHOR    "author" 
#define ATTRIB_ABSTRACT  "abstract" 
#define ATTRIB_ID        "id" 
#define ATTRIB_COPYRIGHT "copyright"


class SourceFileEntry;
class QDomElement;
class QDVDAuthor;

namespace Import
{

class CXmlKino
{
public:
  class seq_struct {
public:
     seq_struct ();

     bool readXml (QDomElement * );

     QString src;
     long    clipBegin;
     long    clipEnd;
     QString title;
     QString author;
     QString abstract;
     int     id;
     QString copyright;
  };
  class smil_struct {
public:
      smil_struct ();
     ~smil_struct ();

     bool readXml (QDomElement * );
     seq_struct *addSeq ();

     seq_struct	**ppArraySeq;
  };
  
public:
   CXmlKino ( );
  ~CXmlKino ( );

  bool readXml ( QString & );

  smil_struct m_smil;
};

class Kino
{
public:
   Kino ( QDVDAuthor * );
  ~Kino ( );
  
  bool import                   ( );
  bool import               ( QString );
  SourceFileEntry *getEntry     ( );

private:
  bool buildFromKinoXML ( CXmlKino * );

  SourceFileEntry *m_pEntry;
  QDVDAuthor      *m_pDVDAuthor;
};

}

#endif // __IMPORT_KINO_H__
