/****************************************************************************
** Class Keyword 
**
** Created: Fri 08 Dec 12:09:08 2005
**      by: Varol Okan using XEmacs
**
** This class will replace a given token in a string with a value
**
****************************************************************************/

#ifndef KEYWORD_H
#define KEYWORD_H

#include <qstringlist.h>

class Keyword
{
public:
  enum enKeyBase { Keys, TransKeys, SubKeys, BaseLast };

  enum enTranscodeKeys {
    TransDVDAuthorXML=0, TransProjectPath, TransTempPath,    TransInputName , 
    TransBaseName,       TransFileExt,     TransAudioFormat, TransAudioType, 
    TransAudioBitrate,   TransSampleRate,  TransStartingAt,  TransEndingAt,
    TransWidth,          TransHeight,      TransVideoFormat, TransVideoType, 
    TransVideoBitrate,   TransFrameRate,   TransRatio,       TransLast
  };
  enum enKeys {
    KeyDVDAuthorXML=0,   KeyProjectPath,   KeyTempPath,      KeyWidth, 
    KeyHeight,           KeyFormat,        KeyMenuName,      KeyStartPos, 
    KeyDuration,         KeyBackgroundFileName, KeyBackgroundFullName, 
    KeySoundList,        KeyLast
  };
  enum enSubtitlesKeys {
    SubProjectPath=0,  SubTempPath, SubInputFileName, SubBaseName, SubFileExt, 
    SubLast
  };
  
  class Entry {
  public:
     Entry  ( ) { };
    ~Entry  ( ) { };
    QString qsKey;
    QString qsValue;
    int     iIndex;
  };

   Keyword ();
  ~Keyword ();

  int     count                            ( int );
  void    clear                            ( int );
  QString value                       ( int, int );
  QString key                         ( int, int );
  bool    setValue           ( int, int, QString );
  QString resolvString            ( int, QString );
  QString resolvConvert       ( QString, QString );
  QStringList getValues                    ( int );
  QStringList getKeys                      ( int );
  void    setKeywords ( int, QValueList<QString> );

private:
  QValueList<Entry *> m_listOfPair    [ BaseLast ];
};

#endif // KEYWORD_H


