/****************************************************************************
** TemplateWizard class
**
** Created: Mon May 23 12:09:08 2005
**      by: Varol Okan using kate editor
**
** This class allows the user to choose a template and simply fillin the 
** blanks.
**
** Templates are stored under :
** /usr/share/qdvdauthor/templates/static/<tmpltdir>
** /usr/share/qdvdauthor/templates/movie/<tmpltdir>
** - each template has its own tmpltdir
** - each tmpltdir has a preview.jpg OR preview.mpg
** - each tmpltdir has a template.xml file, which describes the template.
**
****************************************************************************/

#ifndef TEMPLATEWIZARD_H
#define TEMPLATEWIZARD_H

#include <qframe.h>
#include <qlistbox.h>
#include <qtooltip.h>

#include "uitemplatewizard.h"

class TemplateWizard;
class MediaInterface;
class QDVDAuthor;
class DVDMenu;

// This class was derived to have the mouseClick and drop events covered
class TemplateFrame : public QFrame
{
	Q_OBJECT
public:
	TemplateFrame ( TemplateWizard *, QWidget *p=0, const char *n=0, WFlags f=0 );
	virtual ~TemplateFrame ();

protected:
	virtual void dropEvent     (QDropEvent *);
	virtual void dragEnterEvent(QDragEnterEvent *);

protected slots:
	void mouseReleaseEvent ( QMouseEvent * );

signals:
	void signalMouseReleaseEvent (QMouseEvent *);
private:
	TemplateWizard *m_pTemplateWizard;
};

class ListBoxToolTip : public QToolTip 
{
public:
	ListBoxToolTip(QListBox *);
	virtual ~ListBoxToolTip () {};

	virtual void maybeTip(const QPoint &);
protected:
	QListBox* m_pListBox;
};

class TemplateWizard : public uiTemplateWizard
{
	Q_OBJECT

public:
	class DropZone
	{
		 DropZone ();
	public:
		 DropZone (int, QString, QRect);
 		~DropZone ();

		int      iNumber;	// Counter, of which DropZone we have ... E.g. 1
		bool     bMovie;	// Is this a movie Source ?
		QString  qsText;	// E.g "Movie 1" used for ???
		QRect    rect;
		QString  qsFileName;
		QPixmap *pPixmap;
	};

	 TemplateWizard( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~TemplateWizard();

	void initMe             (QDVDAuthor *);
	void droppedSomething   (QDropEvent *);
	DVDMenu *getMenu        ();

protected:
	void initTab (QString, QIconView * );
	void initPreview                  ();
	void initDragList                 ();
	void refreshBackground            ();
	void refreshComboMenu             ();
	QString getSourceEntryName (QString);
	QString readProjectFile (QString, bool);

protected slots:
	virtual void slotTemplateClicked   (QMouseEvent   *);
	virtual void slotListBoxClicked    (QListBoxItem  *);
	virtual void slotIconViewClicked   (QIconViewItem *);
	virtual void slotTargetMenuChanged (const QString &);
	virtual void slotPlaybackFinished  ();
	virtual void next   ();
	virtual void reject ();
	virtual void accept ();
	virtual void hide   ();
    
private:
	QDVDAuthor              *m_pDVDAuthor;
	TemplateFrame           *m_pFrameProperties;
	DVDMenu                 *m_pDVDMenu;
	MediaInterface          *m_pMediaInterface;
	ListBoxToolTip          *m_pListBoxToolTip;
	bool                     m_bDontRestart;

	QValueList<DVDMenu *>    m_listDVDMenus;
	QString                  m_qsPathName;
	QValueList<DropZone *>   m_listDropZones;
	QString                  m_qsXMLDVDMenu;
	QString                  m_qsCurrentTemplate;
	float                    m_fScale;
	QStringList              m_listSourceFileDescriptions;
};

#endif // TEMPLATEWIZARD_H
