/****************************************************************************
** DialogCommandEditor class
**
** Created: Mon Jun 07 22:48:00 2004
**      by: Varol Okan using Kate
**
**
****************************************************************************/

#include <qtextedit.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qcombobox.h>

#include "dialogcommandeditor.h"

DialogCommandEditor::DialogCommandEditor (QWidget *pParent, const char *pName, WFlags f )
	: uiDialogCommandEditor (pParent, pName, f)
{
	// Setting of the classes variables ...
	m_pCommandBlock = NULL;
}

DialogCommandEditor::~DialogCommandEditor ()
{
	// The Dialog takes care of the destruction of the generated tabs,
	// so we won't have to do it manually here
}

void DialogCommandEditor::initMe (QDVDAuthorInit::MenuBlock::Block *pBlock, uint iCurrentTab, QStringList listVars, uint iMaxVars )
{
  uint t, iCount;
  initMe (pBlock, iCurrentTab);
  m_pComboVar->clear ();

  iCount = ( iMaxVars > 0 ) ? iMaxVars : listVars.count ();

  for (t=0;t<iCount;t++) 
    m_pComboVar->insertItem (listVars[t].replace ("+", ""));
}

void DialogCommandEditor::initMe (QDVDAuthorInit::MenuBlock::Block *pBlock, uint iCurrentTab)
{
	uint t;
 	// Here we store the datablock ...
	m_pCommandBlock = pBlock;
	m_pTextEditComment->setText(pBlock->listComments[0]);
	
	// This one tab is static and the others are generated dynamically ...
	m_pTextEditCommand->setText(pBlock->listCommands[0]);
	m_listCommandTabs.append(tab);
	m_listCheckDefault.append(m_pCheckDefault);
	m_listEditCommands.append(m_pTextEditCommand);

	for (t=1;t<pBlock->listCommands.count();t++)
		addCommandTab(pBlock->listCommands[t]);
	m_pTabWidget->setCurrentPage(iCurrentTab);

	m_listCheckDefault[pBlock->iDefaultCommand]->setChecked(true);
	// And now let us make some connections
	connect (m_pButtonAddCommand, SIGNAL(clicked()), this, SLOT(slotAddCommand ()));
	connect (m_pButtonAddToCommand, SIGNAL(clicked()), this, SLOT(slotAddToCommand ()));
	connect (m_pButtonDeleteCommand, SIGNAL(clicked()), this, SLOT(slotDeleteCommand ()));
	connect (m_pCheckDefault, SIGNAL(clicked()), this, SLOT(slotCheckDefault ()));
}

void DialogCommandEditor::slotAddCommand ()
{
	addCommandTab (QString ());
}

void DialogCommandEditor::addCommandTab(QString qsCommand)
{
	QWidget     *pTab;
	QGridLayout *pLayout;
	QCheckBox   *pCheck;
	QLabel      *pLabel;
	QTextEdit   *pCommand;

	pTab     = new QWidget( m_pTabWidget ); //, QString("tab%1").arg(t) );
	pLayout  = new QGridLayout( pTab, 1, 1, 4, 0 ); //, QString("tabLayout%1").arg(t));
	pCheck   = new QCheckBox( pTab ); //, QString("m_pCheckDefault%1").arg(t) );
	pLabel   = new QLabel( pTab ); //, QString("textLabel%1").arg(t) );
	pCommand = new QTextEdit( pTab ); //, QString("pCommand%1").arg(t) );
	pCommand->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, m_pTextEditCommand->sizePolicy().hasHeightForWidth() ) );
	pCommand->setPaletteForegroundColor( QColor( 255, 0, 0 ) );
	pCommand->setPaletteBackgroundColor( QColor( 194, 185, 255 ) );

	m_listCommandTabs.append(pTab);
	m_listCheckDefault.append(pCheck);
	m_listEditCommands.append(pCommand);

	pLayout->addWidget( pCheck, 0, 1 );
	pLayout->addWidget( pLabel, 0, 0 );
	pLayout->addMultiCellWidget( pCommand, 1, 1, 0, 1 );
	m_pTabWidget->insertTab( pTab, QString("Cmd %1").arg(m_listEditCommands.count()) );

	pCheck->setText( tr( "Use as default command" ) );
	pLabel->setText( tr( "<p align=\"center\">Command Line</p>" ) );
	pCommand->setText(qsCommand);
	connect (pCheck, SIGNAL(clicked()), this, SLOT(slotCheckDefault ()));
}

void DialogCommandEditor::slotAddToCommand ()
{
	// This slot will insert the selected string into the command 
	QTextEdit *pCommand;
	pCommand = m_listEditCommands[m_pTabWidget->currentPageIndex()];
	pCommand->insert(QString("+")+m_pComboVar->currentText()+QString("+"));
}

void DialogCommandEditor::slotDeleteCommand ()
{
	// Here we delete a command and remove all 
	uint iCmdToRemove, t;
	// Sanity check, we need to keep at least one command
	if (m_pTabWidget->count() <= 1)
		return;
	iCmdToRemove = m_pTabWidget->currentPageIndex ();
	// Here we shift all widgets over to the left and delete the last tabwidget ...
	for (t=iCmdToRemove;t<m_listCheckDefault.count()-1;t++)
		m_listCheckDefault[t]->setChecked(m_listCheckDefault[t+1]->isChecked());
	for (t=iCmdToRemove;t<m_listEditCommands.count()-1;t++)
		m_listEditCommands[t]->setText(m_listEditCommands[t+1]->text());
	// Next we remove the references  from the dynamic lists ...
	QWidget *pTab = m_listCommandTabs.last();
	m_listCommandTabs.remove(pTab);
	m_listCheckDefault.remove(m_listCheckDefault.last());
	m_listEditCommands.remove(m_listEditCommands.last());
	// And then finally we delete the tab widget ...
	delete pTab;
}

void DialogCommandEditor::slotCheckDefault ()
{
	// here we work the checks ...
	uint t;
	bool bActiveChecked = true;

	// Finally we ensure that only one check is set ...
	for (t=0;t<m_listCheckDefault.count();t++)	{
		if (m_listCheckDefault[t]->isVisible())
			bActiveChecked = m_listCheckDefault[t]->isChecked ();
		else
			m_listCheckDefault[t]->setChecked(false);
	}
	// In case the user actually unchecked the checkDefault, we set the first command as the default.
	if (!bActiveChecked)
		m_listCheckDefault[0]->setChecked(true);
}

void DialogCommandEditor::accept ()
{
	// Handles the Ok - button ...
	uint t;
	m_pCommandBlock->listCommands.clear();
	// First we store the command list of this execution block in the data structure ...
	for (t=0;t<m_listEditCommands.count();t++)	{
		if (!m_listEditCommands[t]->text().isEmpty())
			m_pCommandBlock->listCommands.append(m_listEditCommands[t]->text());
	}
	// Here we store the default commands index ...
	for (t=0;t<m_listCheckDefault.count();t++)	{
		if (m_listCheckDefault[t]->isChecked())
			m_pCommandBlock->iDefaultCommand = t;
	}
	// And finally we store the header description of this command lines function
	m_pCommandBlock->listComments[0] = m_pTextEditComment->text();
	
	uiDialogCommandEditor::accept();	
}


