/****************************************************************************
** Interface to the GUI.
**
** Created: Wed Jun 7 22:48:00 2006
**      by: Varol Okan using xemacs
**
**
****************************************************************************/

#ifndef DIALOGCREATETEMPLATE_H
#define DIALOGCREATETEMPLATE_H

#include <qframe.h>
#include <qurloperator.h>

// the designer created GUI.
#include "uicreatetemplate.h"

class QPaintEvent;
class QProcess;
class QNetworkOperation;

class ButtonObject;
class MenuObject;
class DVDMenu;
class DialogCreateTemplate;

class CreateTemplatePreview : public QFrame 
{
  Q_OBJECT

public:
   CreateTemplatePreview ( QWidget*p=NULL, const char *n=NULL, WFlags f=0 );
  ~CreateTemplatePreview ( );

  void initMe ( DVDMenu *, DialogCreateTemplate * );
  void setBackgroundFileName    ( const QString & );

  QValueList<MenuObject *> &getDropZones ( );
  void ensureUniqueDropZoneName          ( );

protected:
  virtual void mousePressEvent       ( QMouseEvent * );
  virtual void mouseReleaseEvent     ( QMouseEvent * );
  virtual void mouseDoubleClickEvent ( QMouseEvent * );
  virtual void mouseMoveEvent        ( QMouseEvent * );

  virtual void paintEvent    ( QPaintEvent   * );

  MenuObject *isWithinObject ( const QPoint  & );
  void createObjectList      ( );
  bool isUniqueName          ( int,  QString & );

protected slots:
  virtual void polish ( );

private:
  float                  m_fScale;
  DVDMenu               *m_pDVDMenu;
  //  QFrame                *m_pFrameProperties;
  QString                m_qsBackgroundFileName;
  DialogCreateTemplate  *m_pDialog;
  // All valid objects from the DVDMenu
  QValueList<MenuObject *>m_listOfMenuObjects;
  // Those objects that were selected as DropZone.
  QValueList<MenuObject *>m_listOfDropZones;
};

class DialogCreateTemplate : public uiCreateTemplate
{
  Q_OBJECT

public:
   DialogCreateTemplate ( QWidget *p=NULL, const char *n=0, WFlags f=0 );
  ~DialogCreateTemplate ( );

  void initMe       ( DVDMenu * );

protected:
  QString createTemplate   ( );
  QString getTypePath      ( );

  bool createTemplateXml   ( QString & );
  bool createBackground    ( QString & );
  bool createIndexXml      ( );
  bool createWebHtml       ( );

  QString findGuiSU        ( );
  void    installToSystem  ( QString &, bool );
  QString handleButtonXml  ( int, QString  & );

  void handleMenuImages    ( QString &, QString & );
  void handleMenuBackground( QString & );
  void handleMenuDropZones ( QString & );
  void handleMenuMovie     ( QString & );
  void handleMenuAudio     ( QString &, QString & );

protected slots:
  virtual void polish                ( );
  virtual void slotHelp              ( );
  virtual void slotCreateTemplate    ( );
  virtual void slotUpload            ( );
  virtual void slotInstall           ( );
  virtual void slotProcessExited     ( );
  virtual void slotReadFromProcess   ( );
  virtual void slotNetworkData       ( const QByteArray &, QNetworkOperation * );
  virtual void slotNetworkFinished   ( QNetworkOperation * );
  virtual void slotUploadFinished    ( int, bool );

private:
  DVDMenu                *m_pDVDMenu;
  CreateTemplatePreview  *m_pFrameProperties;
  QProcess               *m_pNewProcess;
  bool         m_bInstallDone; // indictes that the user clicked on the Install button
  QUrlOperator m_Network;
  QString      m_qsCreateString;
  QString      m_qsData;
  int          m_iStatsID;
};

#endif // DIALOGCREATETEMPLATE_H

