/****************************************************************************
** bugs_workaround.h
**
** This file defines variables to switch on/off workaroud to bugs which are 
** not in 'Q' DVD-Author iself but rather in the used utilities / programs
** that we are using.
**
** I put all of those switches in one central spot and added as many comments
** as psooible. 
**
** You are encouraged to switch each one of those flags off and see if it is 
** working for you without the provided workaround.
**
*****************************************************************************/

#include "qdvdauthor/qplayer/MEDIA_CONFIG.h"

//#define DVDAUTHOR_VERSION_LESS_0_6_10
// For some reasons the interface changed between 0.6.9 and 0.6.10
// If this variable is defined the generated xml output will use 
// "name", rather then "label" for buttons in the spumux xml files. 
// ( xml_dvdauthor.cpp::CXmlSpumux::action_struct::readXml and 
//   xml_dvdauthor.cpp::CXmlSpumux::action_struct::writeXml )

#ifdef XINE_SUPPORT
//#define XINIT_THREADS_CRASH 1
// This bug causes QDVDAuthor to hang or crash. XInitThreads is needed to
// access XLibs in a multi threaded application, such as xine. 
// However Qt and XInitThreads don't get along and causing QDVDAUthor
// to hang or crash on some machines.
// If you set this flag it will omit the XInitThreads in main.cpp
// Possible side effects might also lead to crashes though.
// To ensure this doe not affect you, you have to compile QDVDAuthor
// with only MPlayer Support and disable xine-libs.
#else
#define XINIT_THREADS_CRASH 1
#endif


// The following variable no longer exists in the code ... why ?
#define XINE_THREADING_CRASH
// Xine is initialized in a background thread and if the thread is
// returning it will crash the application on some computers but not 
// on every computer. 
// It is safer to keep this variable defined. But you can try to compile 
// without and if QDVDAuthor crashes at start then you need to enable this 
// variable.
//
// The workaround will leave the initialization thread around for 
// a period of one year (if the program runs that long), after which 
// it might crash.
// ( qplayer/xineinfo.cpp::CreateXineEngine::run )
