/****************************************************************************
** DialogFiles
**
**   Created : Tue Dec 11 22:48:00 2007
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This ialog offers an easy way to select and sort source files ( videos )
** into SourceFileEntries.
**
** This of course is helpfull if you have 100+ files
**
****************************************************************************/

#ifndef __DIALOGFILES_H__
#define __DIALOGFILES_H__


#include <qlistview.h>
#include <qlistbox.h>
#include <qprocess.h>
#include <qpixmap.h>

#include "qplayer/mediascanner.h"
#include "sourcefileentry.h"
#include "uidialogfiles.h"
#include "cachethumbs.h"

class QIconViewItem;
class QIconDragItem;
class QPushButton;
class QTimer;

class SourceToolBar;

// Separate from global namspace because nested classes 
// are not supported by moc.
namespace Input
{

class DialogFiles; // forward declaration

class GroupView : public QListView
{
  Q_OBJECT
public:
  // This is the size for all thumbs in the list controls
  static const int m_iSize;

  class Item : public QListViewItem  {
    public:
    Item ( QListView *, QString, bool );
    Item ( QListView *, Item *, QString, bool );
    virtual ~Item ( );

    virtual void paintCell ( QPainter   *, const QColorGroup &, int, int, int );
    virtual int  width     ( const QFontMetrics &, const QListView *, int ) const;

    SourceFileInfo       *pSourceFileInfo;
    Cache::Thumbs::Entry *pCache;
    bool bAlternateColor;
  };

  GroupView ( QWidget *, QIconView *, DialogFiles *, SourceFileEntry *p=NULL );
  GroupView ( QWidget *, SourceFileEntry * );
  virtual ~GroupView  ( );

  SourceFileEntry *sourceFileEntry ( ); // could be NULL
  void append ( void * );

  QString groupName     ( );
  void    setGroupName  ( QString & );
protected: // member functions
  // Overloaded function
  virtual QDragObject *dragObject( );
  virtual void dropEvent         ( QDropEvent      * );
  virtual void dragEnterEvent    ( QDragEnterEvent * );
  virtual void timerEvent        ( QTimerEvent     * );

protected slots:
  virtual void slotAlternateColors ( );

private: // member variables
  QIconView       *m_pPreview;
  DialogFiles     *m_pDialog;
  SourceFileEntry *m_pSourceFileEntry;
};

class ScanDVDate : public QProcess 
{
  Q_OBJECT
public:
  // Scanning the input video for DVDates
  ScanDVDate ( DialogFiles *, QString, QIconViewItem * );
  virtual ~ScanDVDate ( );

  bool hasExited ( );

protected slots:
  virtual void slotExited ( );
 
private:
  bool bExited; 
  QString        qsFileName; 
  QIconViewItem *pItem;
  DialogFiles   *pDialog;
};

class DialogFiles : public uiDialogFiles
{
  Q_OBJECT

  class Thumbs; // forward declaration
  class DirItem : public QListViewItem  {
  public:
    DirItem ( QListView *, QString );
    DirItem ( DirItem *,   QString );
    virtual ~DirItem ( ) { };

    virtual void setOpen ( bool );
    QString  dir ( );
    DirItem *findSubDir ( QString );

  private:
    DirItem *pParent;
    QString  qsPathName;
    bool     bReadable;
  };

  class ThumbnailRequest : public ExecuteJob {
  public:
    ThumbnailRequest ( DialogFiles * );
    ThumbnailRequest ( DialogFiles *, QIconViewItem *, QString, uint );
    virtual ~ThumbnailRequest ( );

    virtual bool response ( );

    QIconViewItem *pOwnerItem; 
    DialogFiles   *pParent;
    uint           iNumberOfThumbs;
  };
  class MultiThumbRequest : public ThumbnailRequest {
  public:
    MultiThumbRequest ( DialogFiles *, QIconViewItem *, QString, QImage *, uint );
    virtual ~MultiThumbRequest ( );

    virtual bool response ( );

    void createThumbs     ( );
    long iMovieLength;
    long iDelta;
    uint iSize;
    uint iCurrentThumb;
    QImage **arrayOfThumbs;
  };
  // When the image is rendered the returned data is temp stored in this struct
  // to be executed in timerEvent.
  class WorkWaiting  {
  public:
    WorkWaiting ( QIconViewItem *, QImage *, bool );
    ~WorkWaiting ( );

    QIconViewItem *pItem;
    QImage        *pImage;
    bool           bMarkIcon;
  };

  class Thumbs {
  public:
     Thumbs ( );
    ~Thumbs ( );

    QIconViewItem *pOwnerItem;
    QPixmap      **arrayOfPix; // these pixmaps are the scaled versions of pEntry->arrayOfThumbs
    uint           iNumberOfPix;
    uint           iCurrentPix;
    // we need a pointer to the corresponding cache object in here
    Cache::Thumbs::Entry *pCache;
    SourceFileInfo *pSourceFileInfo; // only set if the item is created through a drop from a GroupView.
  };

public:
  class VFSelectItem : public QListBoxText  { //QListBoxItem {
  public:
    VFSelectItem ( bool, QListBox *, const QString &t=QString::null );
    virtual void paint ( QPainter * );
    virtual int height ( const QListBox * ) const;

    bool bAlternate;
  };

public: // public strctures ...
  DialogFiles ( QWidget *, const char *n=0, WFlags f=0 );
  virtual ~DialogFiles ( );

  void initWork      ( QIconViewItem *, QImage *, bool );
  bool initScanDV    ( Thumbs * );
  void addProgress   ( int );
  uint thumbnailSize ( );

  SourceFileInfo *findSourceFileInfo ( QIconViewItem * );
  QValueList<SourceFileEntry *> &getGroups ( );

protected:
  void initMe            ( );
  void initGroups        ( );
  void copyEntry         ( SourceFileEntry *, SourceFileEntry * );
  GroupView *addGroup    ( SourceFileEntry * );
  GroupView *addGroup    ( QString &, QStringList & );
  void addSourceToGroup  ( GroupView * );
  QString uniqueGroupName( QString );
  bool findDesktopDir    ( QString );
  void initVirtualFolders( );
  void initDirectories   ( );
  void showContextMenu   ( const QPoint &, QIconViewItem * );
  void showBasicMenu     ( const QPoint & );
  void createIconStars   ( );
  void recreateThumbs    ( Thumbs  * );
  bool isValid           ( QIconViewItem * );
  void addPlayButton     ( QIconViewItem *, QPixmap * );
  void createPix         ( QPixmap *, QImage *, float f=0.0f, int i=-1 );
  void markIcon          ( QIconViewItem *, int );
  void setIconText       ( QIconViewItem * );
  void setIconText       ( Thumbs * );
  void resizeIcons       ( int );

  void setTreeDir        ( QString );
  void setQuickDir       (     int );
  void setCurrentDir     ( QString );
  QString currentDir     ( );

  void setVirtualFolder  ( int );
  void toSourceGroup     ( int );
  void toVirtualFolder   ( int );
  void registerRequest   ( MultiThumbRequest * );
  void append            ( Thumbs  * );
  void clearPreview      ( );
  Thumbs *createFromCache( Cache::Thumbs::Entry * );
  void currentSourceToPreview    ( );
  void allSourcesToPreview       ( );
  void stopThumbing              ( );
  void play              ( QString );
  void lock              ( );
  void unlock            ( );
  QValueList<QListViewItem *> getSelectedVirtual ( );

  // Virtual functions
  virtual void timerEvent       ( QTimerEvent    * );
  virtual void load      ( QStringList & );
  virtual QString getDirFilter  ( );

protected slots:
  virtual void slotToVirtualFolder       ( QListBoxItem  * );
  virtual void slotToSourceGroup         ( QListBoxItem  * );
  virtual void slotAllToVirtualFolder    ( QListBoxItem  * );
  virtual void slotAllToSourceGroup      ( QListBoxItem  * );
  virtual void slotSourceToVirtualFolder ( QListBoxItem  * );
  virtual void slotSourceToSourceGroup   ( QListBoxItem  * );
  virtual void slotDirectoryChanged      ( QListViewItem * );
  virtual void slotGroupContextMenu      ( QListViewItem *, const QPoint &, int );
  virtual void slotPreviewClicked        ( int, QIconViewItem *, const QPoint & );
  virtual void slotPreviewPressed        (      QIconViewItem *, const QPoint & );
  virtual void slotDroppedOnPreview      ( QDropEvent *, const QValueList<QIconDragItem> & );
  virtual void slotVirtualChanged        ( );
  virtual void slotIconSelectionChanged  ( );
  virtual void slotAutoOpen              ( );
  virtual void slotQuickDir              ( );
  virtual void slotScanDir               ( );
  virtual void slotThumbing              ( );
  virtual void slotSelectByStars         ( );
  virtual void slotSizeReleased          ( );
  virtual void slotSizeChanged           ( int );
  virtual void slotRegisterRequests      ( );
  virtual void slotAddGroup              ( );
  virtual void slotEditGroup             ( );
  virtual void slotDeleteGroup           ( );
  virtual void slotAddVirtual            ( );
  virtual void slotEditVirtual           ( );
  virtual void slotCloneVirtual          ( );
  virtual void slotDeleteVirtual         ( );
  virtual void accept                    ( );
  virtual void reject                    ( );
  virtual void slotAutoGroup             ( );
  virtual void slotReload                ( );
  virtual void slotRefresh               ( );
  virtual void slotSetProgress           ( );
  virtual void slotAttrib                ( bool );
  virtual void slotShowVirtual           ( QListViewItem *, const QPoint &, int );
  virtual void slotVirtualContextMenu    ( QListViewItem *, const QPoint &, int );

protected:
  static bool m_bStars;
  static bool m_bName;
  static bool m_bDate;
  static bool m_bLength;
  static int  m_iThumbnailSize;

  QTimer   *m_pTimerAutoOpen;
  QTimer   *m_pTimerScanDir;
  QTimer   *m_pTimerThumbing;
  QListBox *m_pVirtualFolderDialog;

  QString   m_qsProjectDir;
  QString   m_qsDocumentsDir;
  QString   m_qsDesktopDir;
  QString   m_qsHomeDir;
  QString   m_qsRootDir;
  QString   m_qsTempDir;
  QString   m_qsCurrentDir;
  QPushButton *m_pActiveQuickButton;

  QPixmap   m_pixMenuStars[6];
  QPixmap   m_pixIconStars[7];

  bool      m_bCanClose;
  bool      m_bCanChangeIcons;
  uint      m_iProgress;
  //uint      m_iThumbnailSize;
  uint      m_iMultiThumbNumber;

  QMutex    m_mutex;
  QMutex    m_mutexRequest;

  QValueList<ScanDVDate  *>       m_listOfDVScansToDo;
  QValueList<WorkWaiting *>       m_listOfWorkToDo;
  QValueList<MultiThumbRequest *> m_listOfRequests;

  Thumbs *m_pActiveThumbs;
  QValueList<Thumbs *>            m_listOfThumbs;
  QValueList<SourceFileEntry *>   m_listOfGroups;

  friend class GroupView;
};

}; // end namespace Input

#endif // __DIALOGFILES_H__

