/****************************************************************************
** Form implementation generated from reading ui file 'smalldialogaudio.ui'
**
**   Created : Mon Jan 29 21:19:51 2007
**        by : Varol Okan using XEmacs and designer
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "smalldialogaudio.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfileinfo.h>
#include <qspinbox.h>

#include "utils.h"
#include "messagebox.h"
#include "sourcefileentry.h"
#include "uidialogsubtitle.h"

/*
 *  Constructs a SmallDialogAudio as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SmallDialogAudio::SmallDialogAudio( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "SmallDialogAudio" );

    setPaletteBackgroundColor( QColor( 147, 77, 238 ) );
    setSizeGripEnabled( TRUE );
    SmallDialogAudioLayout = new QVBoxLayout( this, 11, 6, "SmallDialogAudioLayout"); 

    layout9 = new QHBoxLayout( 0, 0, 6, "layout9"); 

    textLabel1 = new QLabel( this, "textLabel1" );
    layout9->addWidget( textLabel1 );

    m_pLabelLanguage = new QLabel( this, "m_pLabelLanguage" );
    layout9->addWidget( m_pLabelLanguage );
    SmallDialogAudioLayout->addLayout( layout9 );

    m_pComboAudioEntry = new QComboBox( FALSE, this, "m_pComboAudioEntry" );
    m_pComboAudioEntry->setEnabled( TRUE );
    SmallDialogAudioLayout->addWidget( m_pComboAudioEntry );

    m_pGroupAudioFile = new QGroupBox( this, "m_pGroupAudioFile" );
    m_pGroupAudioFile->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)5, 0, 0, m_pGroupAudioFile->sizePolicy().hasHeightForWidth() ) );
    m_pGroupAudioFile->setColumnLayout(0, Qt::Vertical );
    m_pGroupAudioFile->layout()->setSpacing( 2 );
    m_pGroupAudioFile->layout()->setMargin( 4 );
    m_pGroupAudioFileLayout = new QGridLayout( m_pGroupAudioFile->layout() );
    m_pGroupAudioFileLayout->setAlignment( Qt::AlignTop );

    layout21 = new QVBoxLayout( 0, 0, 6, "layout21"); 

    m_pCheckEnable = new QCheckBox( m_pGroupAudioFile, "m_pCheckEnable" );
    layout21->addWidget( m_pCheckEnable );

    m_pGroupAudio = new QGroupBox( m_pGroupAudioFile, "m_pGroupAudio" );
    m_pGroupAudio->setEnabled( TRUE );
    m_pGroupAudio->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)5, 0, 0, m_pGroupAudio->sizePolicy().hasHeightForWidth() ) );
    m_pGroupAudio->setColumnLayout(0, Qt::Vertical );
    m_pGroupAudio->layout()->setSpacing( 2 );
    m_pGroupAudio->layout()->setMargin( 2 );
    m_pGroupAudioLayout = new QHBoxLayout( m_pGroupAudio->layout() );
    m_pGroupAudioLayout->setAlignment( Qt::AlignTop );

    layout47 = new QVBoxLayout( 0, 0, 6, "layout47"); 

    layout29 = new QVBoxLayout( 0, 0, 6, "layout29"); 

    textLabel1_6_4_2 = new QLabel( m_pGroupAudio, "textLabel1_6_4_2" );
    textLabel1_6_4_2->setEnabled( TRUE );
    layout29->addWidget( textLabel1_6_4_2 );

    textLabel1_6_4 = new QLabel( m_pGroupAudio, "textLabel1_6_4" );
    textLabel1_6_4->setEnabled( TRUE );
    layout29->addWidget( textLabel1_6_4 );
    layout47->addLayout( layout29 );

    layout31 = new QVBoxLayout( 0, 0, 6, "layout31"); 

    textLabel1_6_4_2_2 = new QLabel( m_pGroupAudio, "textLabel1_6_4_2_2" );
    textLabel1_6_4_2_2->setEnabled( TRUE );
    layout31->addWidget( textLabel1_6_4_2_2 );

    textLabel1_2_3_4_2 = new QLabel( m_pGroupAudio, "textLabel1_2_3_4_2" );
    textLabel1_2_3_4_2->setEnabled( TRUE );
    layout31->addWidget( textLabel1_2_3_4_2 );
    layout47->addLayout( layout31 );
    m_pGroupAudioLayout->addLayout( layout47 );

    layout48 = new QVBoxLayout( 0, 0, 6, "layout48"); 

    layout30 = new QVBoxLayout( 0, 0, 6, "layout30"); 

    m_pComboAudioOut = new QComboBox( FALSE, m_pGroupAudio, "m_pComboAudioOut" );
    m_pComboAudioOut->setEnabled( TRUE );
    m_pComboAudioOut->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 3, 0, m_pComboAudioOut->sizePolicy().hasHeightForWidth() ) );
    layout30->addWidget( m_pComboAudioOut );

    m_pComboAudioSampleRate = new QComboBox( FALSE, m_pGroupAudio, "m_pComboAudioSampleRate" );
    m_pComboAudioSampleRate->setEnabled( TRUE );
    m_pComboAudioSampleRate->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 3, 0, m_pComboAudioSampleRate->sizePolicy().hasHeightForWidth() ) );
    m_pComboAudioSampleRate->setEditable( TRUE );
    layout30->addWidget( m_pComboAudioSampleRate );
    layout48->addLayout( layout30 );

    layout32 = new QVBoxLayout( 0, 0, 6, "layout32"); 

    m_pComboAudioType = new QComboBox( FALSE, m_pGroupAudio, "m_pComboAudioType" );
    m_pComboAudioType->setEnabled( TRUE );
    m_pComboAudioType->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 3, 0, m_pComboAudioType->sizePolicy().hasHeightForWidth() ) );
    layout32->addWidget( m_pComboAudioType );

    m_pComboAudioBitrate = new QComboBox( FALSE, m_pGroupAudio, "m_pComboAudioBitrate" );
    m_pComboAudioBitrate->setEnabled( TRUE );
    m_pComboAudioBitrate->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 3, 0, m_pComboAudioBitrate->sizePolicy().hasHeightForWidth() ) );
    m_pComboAudioBitrate->setEditable( TRUE );
    layout32->addWidget( m_pComboAudioBitrate );
    layout48->addLayout( layout32 );
    m_pGroupAudioLayout->addLayout( layout48 );
    layout21->addWidget( m_pGroupAudio );

    m_pGroupAudioFileLayout->addLayout( layout21, 0, 0 );
    SmallDialogAudioLayout->addWidget( m_pGroupAudioFile );
    spacer5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    SmallDialogAudioLayout->addItem( spacer5 );

    layout9_2 = new QGridLayout( 0, 1, 1, 0, 6, "layout9_2"); 

    m_pButtonLanguage = new QPushButton( this, "m_pButtonLanguage" );
    m_pButtonLanguage->setAutoDefault( TRUE );

    layout9_2->addWidget( m_pButtonLanguage, 0, 1 );

    m_pButtonHelp = new QPushButton( this, "m_pButtonHelp" );
    m_pButtonHelp->setAutoDefault( TRUE );

    layout9_2->addWidget( m_pButtonHelp, 0, 0 );

    m_pButtonOk = new QPushButton( this, "m_pButtonOk" );
    m_pButtonOk->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 0, 0, m_pButtonOk->sizePolicy().hasHeightForWidth() ) );
    m_pButtonOk->setAutoDefault( TRUE );
    m_pButtonOk->setDefault( TRUE );

    layout9_2->addWidget( m_pButtonOk, 1, 0 );

    m_pButtonCancel = new QPushButton( this, "m_pButtonCancel" );
    m_pButtonCancel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 0, 0, m_pButtonCancel->sizePolicy().hasHeightForWidth() ) );
    m_pButtonCancel->setAutoDefault( TRUE );

    layout9_2->addWidget( m_pButtonCancel, 1, 1 );
    SmallDialogAudioLayout->addLayout( layout9_2 );
    languageChange();
    resize( QSize(260, 359).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    m_pAudio                  = NULL;
    m_pSourceFileEntry        = NULL;
    m_pOrigSourceFileEntry    = NULL;
    m_pPreviousSourceFileInfo = NULL;

    // signals and slots connections
    connect( m_pButtonOk,        SIGNAL( clicked  (      ) ), this, SLOT( accept   ( ) ) );
    connect( m_pButtonCancel,    SIGNAL( clicked  (      ) ), this, SLOT( reject   ( ) ) );
    connect( m_pButtonLanguage,  SIGNAL( clicked  (      ) ), this, SLOT( slotAudioLanguage ( ) ) );
    connect( m_pButtonHelp,      SIGNAL( clicked  (      ) ), this, SLOT( slotHelp ( ) ) );
    connect( m_pComboAudioEntry, SIGNAL( activated(  int ) ), this, SLOT( slotAudioEntryChanged ( int ) ) );
    connect( m_pCheckEnable,     SIGNAL( toggled  ( bool ) ), this, SLOT( slotTranscoding ( bool ) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
SmallDialogAudio::~SmallDialogAudio()
{
  // no need to delete child widgets, Qt does it all for us
  if ( m_pSourceFileEntry )
    delete m_pSourceFileEntry;
  m_pSourceFileEntry = NULL;
}

void SmallDialogAudio::initMe ( Audio *pAudio )
{
  if ( ! pAudio )
    return;

  unsigned  int t = 0;
  QString   qsLang;
  QFileInfo fileInfo;
  Utils     theUtils;
  initAudioInfo ( pAudio );

  fileInfo.setFile ( pAudio->qsFileName );
  m_pComboAudioEntry->insertItem ( fileInfo.fileName ( ) );

  qsLang = theUtils.iso639 ( pAudio->qsIso639, false, t++ );
  setLanguageText ( qsLang );

  // Finally we set the current file ...
  slotAudioEntryChanged ( 0 );
}

void SmallDialogAudio::initMe ( SourceFileEntry *pSourceFileEntry, bool bShowLanguage )
{
  if ( ! pSourceFileEntry || ! pSourceFileEntry->bSoundSource )
    return;

   m_pOrigSourceFileEntry = pSourceFileEntry;
   m_pSourceFileEntry     = new SourceFileEntry;
  *m_pSourceFileEntry     = *pSourceFileEntry;

  if ( ! bShowLanguage ) {
    m_pButtonLanguage->setEnabled ( false );
    m_pLabelLanguage->hide  ( );
    textLabel1->hide        ( );
  }

  //  initAudio ...
  int             t;
  QFileInfo       fileInfo;
  SourceFileInfo *pInfo = NULL;
    
  for ( t=0; t<(int)pSourceFileEntry->listFileInfos.count ( ); t++ ) {
    pInfo = pSourceFileEntry->listFileInfos[t];
    if ( ! pInfo )
      continue;
    fileInfo.setFile ( pInfo->qsFileName );
    m_pComboAudioEntry->insertItem ( fileInfo.fileName ( ) );
  }
  // Finally we set the current file ...
  slotAudioEntryChanged ( 0 );
}

void SmallDialogAudio::slotTranscoding ( bool bEnabled )
{
  m_pGroupAudio->setEnabled ( bEnabled );
}

void SmallDialogAudio::slotAudioLanguage ( )
{
    // This will add a new audio track to the PGC (Title)
  // For simplicity we abuse the SubtitleDialog.
  uiDialogSubtitle theDialog;
  theDialog.m_pTextNumber->hide ( );
  theDialog.m_pSpinboxNumber->hide ( );
  theDialog.setCaption ( "Select language" );
  int     t;
  Utils   theUtils;
  QString qsLang, qsCode, qsEmpty;

  t = 0;
  qsLang = "Somthing"; //qsNone;
  theDialog.m_pComboLanguage->clear ( );
  while ( ! qsLang.isEmpty ( ) ) {
    qsLang = theUtils.iso639 ( qsCode,  false,  t++ );
    theDialog.m_pComboLanguage->insertItem ( qsLang );
  }

  if ( theDialog.exec ( ) == QDialog::Rejected )
    return;

  // At this point we should get the language ...
  qsLang = theDialog.m_pComboLanguage->currentText ( );
  setLanguageText ( qsLang );
}

void SmallDialogAudio::setLanguageText ( QString &qsLanguage )
{
  m_pLabelLanguage->setText ( "<p align=\"right\"><b>" + qsLanguage + "</b></p>" );
}

QString SmallDialogAudio::languageText ( )
{
  return m_pLabelLanguage->text ( );
}

void SmallDialogAudio::slotAudioEntryChanged ( int )
{
  if ( ! m_pSourceFileEntry )
    return;

  int t;
  QFileInfo fileInfo;
  SourceFileInfo *pInfo = NULL;
  QString qsFile = m_pComboAudioEntry->currentText ( );

  setTranscoding ( m_pPreviousSourceFileInfo );
  m_pPreviousSourceFileInfo = NULL;
  
  for ( t=0; t<(int)m_pSourceFileEntry->listFileInfos.count ( ); t++ ) {
    pInfo = m_pSourceFileEntry->listFileInfos[t];
    if ( ! pInfo )
      continue;
    fileInfo.setFile ( pInfo->qsFileName );
    if ( fileInfo.fileName ( ) == qsFile ) {
      initAudioInfo  ( pInfo );
      break;
    }
  }
}

void SmallDialogAudio::initAudioInfo ( SourceFileInfo *pInfo )
{
  if ( ! pInfo )
    return;
 
  m_pPreviousSourceFileInfo = pInfo; 
  initTranscode ( pInfo->pTranscodeInterface );
}

void SmallDialogAudio::initAudioInfo ( Audio *pAudio )
{
  if ( ! pAudio )
    return;

  m_pAudio = pAudio;
  TranscodeInterface *pTranscode = pAudio->pTranscodeInterface;
  initTranscode ( pTranscode );
}

void SmallDialogAudio::initTranscode ( TranscodeInterface *pTranscode )
{
  bool    bEnableTranscoding = ( pTranscode );
  QString qsTemp;
  Utils   theUtils;
  long    iBitrate, iSample;

  m_pCheckEnable->setChecked ( bEnableTranscoding );
  m_pGroupAudio ->setEnabled ( bEnableTranscoding );
  if ( bEnableTranscoding )  {
    qsTemp = pTranscode->qsAudioType;
    qsTemp.remove ( "Keep " );
    if ( qsTemp.length ( ) < 1 )
      qsTemp = "mp2";
    m_pComboAudioType->setCurrentText ( qsTemp );

    iBitrate = pTranscode->iAudioBitrate;
    if ( iBitrate < 0 )
         iBitrate *= -1;
    m_pComboAudioBitrate->setCurrentText ( theUtils.longToNorm( iBitrate ) + QString ( "bps" ) );
    iSample = pTranscode->iSample;
    if ( iSample < 0 )
         iSample *= -1;
    m_pComboAudioSampleRate->setCurrentText ( QString ( "%1" ).arg( iSample ) );
  }
}

void SmallDialogAudio::slotHelp ( )
{
  QSize helpSize ( 600, 400 );
  MessageBox::help ( this, tr ("DVD Audio streams" ), "audio_streams.html", helpSize );
}

void SmallDialogAudio::setTranscoding ( Audio *pAudio )
{
  if ( ! pAudio )
    return;

  if ( ! m_pCheckEnable->isChecked ( ) ) {
    if ( pAudio->pTranscodeInterface )
      delete pAudio->pTranscodeInterface;
    pAudio->pTranscodeInterface = NULL;
    return;
  }
  setTranscoding ( pAudio->pTranscodeInterface );
}

void SmallDialogAudio::setTranscoding ( SourceFileInfo *pSourceFileInfo )
{
  if ( ! pSourceFileInfo )
    return;

  if ( ! m_pCheckEnable->isChecked ( ) ) {
    if ( pSourceFileInfo->pTranscodeInterface )
      delete pSourceFileInfo->pTranscodeInterface;
    pSourceFileInfo->pTranscodeInterface = NULL;
    return;
  }
  setTranscoding ( pSourceFileInfo->pTranscodeInterface );
}

void SmallDialogAudio::setTranscoding ( TranscodeInterface *&pTranscode )
{
  QString qsTemp;
  Utils   theUtils;
  int     iBitrate, iSample;

  if ( ! pTranscode )
    pTranscode = new TranscodeInterface;

  pTranscode->qsAudioFormat = m_pComboAudioOut->currentText  ( );
  pTranscode->qsAudioType   = m_pComboAudioType->currentText ( );
  qsTemp = m_pComboAudioBitrate->currentText ( );
  iBitrate =  theUtils.normToLong ( qsTemp );
  if ( iBitrate < 2000 )
	  iBitrate *= 1000;
  pTranscode->iAudioBitrate = iBitrate;
  qsTemp = m_pComboAudioSampleRate->currentText ( );
  iSample =  qsTemp.toInt ( );
  pTranscode->iSample       = iSample;
}

void SmallDialogAudio::accept ( )
{
  int    t, i;
  SourceFileInfo *pInfo1, *pInfo2;

  setTranscoding ( m_pPreviousSourceFileInfo );
  m_pPreviousSourceFileInfo = NULL;

  if ( m_pSourceFileEntry ) {
    // Here we move the transcoding interface(es) over to the orig SourceFileEntry.
    for ( t=0; t<(int)m_pSourceFileEntry->listFileInfos.count ( ); t++ ) {
      pInfo1 = m_pSourceFileEntry->listFileInfos[t];
      if ( ! pInfo1 )
	continue;
      for ( i=0; i<(int)m_pOrigSourceFileEntry->listFileInfos.count ( ); i++ ) {
	pInfo2 = m_pOrigSourceFileEntry->listFileInfos[i];
	if ( ! pInfo2 )
	  continue;
	if ( pInfo1->qsFileName == pInfo2->qsFileName ) {
	  if ( pInfo2->pTranscodeInterface )
	    delete pInfo2->pTranscodeInterface;
	  pInfo2->pTranscodeInterface = pInfo1->pTranscodeInterface;
	  pInfo1->pTranscodeInterface = NULL;
	  // exit the inner loop ...
	  i = m_pOrigSourceFileEntry->listFileInfos.count ( );
	}
      }
    }
  }
  else if ( m_pAudio )
	setTranscoding ( m_pAudio );

  QDialog::accept ( );
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void SmallDialogAudio::languageChange()
{
    setCaption( tr( "Audio settings" ) );
    textLabel1->setText( tr( "<p align=\"left\">Language : </p>" ) );
    m_pLabelLanguage->setText( tr( "<p align=\"right\"><b>German</b></p>" ) );
    m_pGroupAudioFile->setTitle( tr( "Audio File" ) );
    m_pCheckEnable->setText( tr( "Enable transcoding" ) );
    m_pGroupAudio->setTitle( tr( "Audio Settings" ) );
    textLabel1_6_4_2->setText( tr( "Sound out :" ) );
    textLabel1_6_4->setText( tr( "Sample :" ) );
    textLabel1_6_4_2_2->setText( tr( "Type :" ) );
    textLabel1_2_3_4_2->setText( tr( "Bitrate :" ) );
    m_pComboAudioOut->clear();
    m_pComboAudioOut->insertItem( tr( "Stereo 2.0" ) );
    m_pComboAudioSampleRate->clear();
    m_pComboAudioSampleRate->insertItem( tr( "48000" ) );
    m_pComboAudioType->clear();
    m_pComboAudioType->insertItem( tr( "mp2" ) );
    m_pComboAudioBitrate->clear();
    m_pComboAudioBitrate->insertItem( tr( "192kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "32kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "64kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "128kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "224kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "384kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "768kbps" ) );
    m_pComboAudioBitrate->insertItem( tr( "1536kbps" ) );
    m_pButtonLanguage->setText( tr( "&Language" ) );
    m_pButtonLanguage->setAccel( QKeySequence( tr( "Alt+L" ) ) );
    m_pButtonHelp->setText( tr( "&Help" ) );
    m_pButtonHelp->setAccel( QKeySequence( tr( "F1" ) ) );
    m_pButtonOk->setText( tr( "&OK" ) );
    m_pButtonOk->setAccel( QKeySequence( QString::null ) );
    m_pButtonCancel->setText( tr( "&Cancel" ) );
    m_pButtonCancel->setAccel( QKeySequence( QString::null ) );
}

