%define dv2sub dv2sub-0.3
%define _prefix /usr

# determine what platform we are building on
%define fedora 0
%define suse 0
%define mdk 0

# third party packagers
%define _packager D. Scott Barninger <barninger@fairfieldcomputers.com>
%{?contrib_packager:%define _packager %{contrib_packager}}

%define build_templates 0
%{?build_templ:%define build_templates 1}

%if %{_vendor} == redhat
	%define fedora 1
	%define _dist %(cat /etc/redhat-release)
	%define suse_version 0000
%endif
%if %{_vendor} == suse
	%define suse 1
	%define _dist %(grep -i SuSE /etc/SuSE-release)
%endif
%if %{_vendor} == Mandriva
	%define mdk 1
	%define _dist %(grep Mand /etc/mandrake-release)
	%define suse_version 0000
%endif

%if ! %{fedora} && ! %{suse} && ! %{mdk}
%{error: Unknown platform. Please examine the spec file.}
exit 1
%endif

# manual define for 64 bit
%define amd64 0
%{?build_amd64:%define amd64 1}

# media backend selection - default to mplayer
%define xine_support 0
%define mplayer_support 0
%{?build_xine:%define xine_support 1}
%{?build_mplayer:%define mplayer_support 1}
%if ! %{xine_support} && ! %{mplayer_support}
	%define mplayer_support 1
%endif
%if %{xine_support}
	%define configure_opts --no-mplayer-support
	%define media_backend Xine
%endif
%if %{mplayer_support}
	%define configure_opts --no-xine-support
	%define media_backend MPlayer
%endif

Summary: QDVDAuthor, the GUI frontend for dvdauthor and other related tools.
Name: qdvdauthor
Version: 1.8.0
Release: 1
Group: Applications/Multimedia
License: GPL v2
Distribution: %{_dist}
Source0: %{name}-%{version}.tar.gz

%if %{build_templates}
Source2: %{name}-templates-%{version}.tar.bz2
%endif

Source3: %{dv2sub}.tar.gz

#Patch0: %{name}-%{version}.patch

BuildRoot: %{_tmppath}/%{name}-root
URL: http://qdvdauthor.sourceforge.net/
Packager: %{_packager}
%define qdvdauthor_dir %{name}-%{version}
%define qdvdauthor_templates_dir %{name}-templates-%{version}

BuildRequires: pkgconfig
%if %{suse} && %{suse_version} == 1000
BuildRequires: libdv
%else
BuildRequires: libdv-devel
%endif
BuildRequires: dvdauthor >= 0.6.10
%if %{fedora} && %{mplayer_support}
BuildRequires: mplayer
%endif
%if %{suse} && %{mplayer_support}
BuildRequires: MPlayer
%endif
%if %{mdk} && %{mplayer_support}
BuildRequires: mplayer
%endif
%if %{fedora} && %{xine_support}
BuildRequires: xine-lib-devel
%endif
%if %{suse} && %{xine_support}
BuildRequires: libxine1-devel
%endif
%if %{mdk} && %{xine_support}
BuildRequires: libxine1-devel
%endif
%if %{fedora}
BuildRequires: bzip2-devel
%endif
%if %{suse}
BuildRequires: bzip2
%endif
%if %{mdk}
BuildRequires: libbzip2-devel
%endif
%if %{fedora}
BuildRequires: qt-devel
BuildRequires: qt3-devel
%endif
%if %{suse}
BuildRequires: qt3-devel
BuildRequires: libqt4-devel
%endif
%if %{mdk}
BuildRequires: libqt3-devel
BuildRequires: libqt4-devel
%endif
BuildRequires: glibc-devel
%if %{fedora}
BuildRequires: freetype-devel
%endif
%if %{suse} || %{mdk}
BuildRequires: freetype2-devel
%endif
%if %{fedora} || %{mdk}
BuildRequires: libjpeg-devel
BuildRequires: ffmpeg-devel
%endif
%if %{suse}
BuildRequires: libjpeg
BuildRequires: libffmpeg-devel
%endif
BuildRequires: libpng-devel
%if %{fedora} || %{mdk}
BuildRequires: libtiff-devel
%endif
%if %{suse}
BuildRequires: libtiff
%endif
BuildRequires: libxml2-devel >= 2.6
BuildRequires: zlib-devel

Requires: bzip2
Requires: dvdauthor >= 0.6.10
Requires: mjpegtools
Requires: ffmpeg
%if %{fedora}
Requires: qt qt3
%endif
%if %{suse}
Requires: qt3 libqt4
%endif
%if %{mdk}
Requires: libqt3 libqtcore4
%endif
Requires: glibc
Requires: libgcc
%if %{fedora}
Requires: freetype
%endif
%if %{suse} || %{mdk}
Requires: freetype2
%endif
Requires: libjpeg
Requires: libpng
Requires: libtiff
Requires: libxml2 >= 2.6
Requires: zlib
Requires: sox
%if %{mdk} && %{xine_support}
Requires: libxine1
%endif
%if %{suse} && %{xine_support}
Requires: libxine1
%endif
%if %{fedora} && %{xine_support}
Requires: xine-lib
%endif
%if %{mdk} && %{mplayer_support}
Requires: mplayer
%endif
%if %{suse} && %{mplayer_support}
Requires: MPlayer
%endif
%if %{fedora} && %{mplayer_support}
Requires: mplayer
%endif
%if %{suse} || %{mdk}
Requires: netpbm
%endif
%if %{fedora}
Requires: netpbm-progs
%endif
Requires: dv2sub

%description

QDVDAuthor is a gui frontend for using dvdauthor to 
easily build DVD menus and assemble the DVD VOB files. 

This package requires %{media_backend}.

%if %{build_templates}
%package templates
Summary: QDVDAuthor, the GUI frontend for dvdauthor and other related tools.
Group: Applications/Multimedia

%description templates
Optional menu templates for use with qdvdauthor.
%endif

%package dv2sub
Summary: QDVDAuthor, the GUI frontend for dvdauthor and other related tools.
Group: Applications/Multimedia

Provides: dv2sub = 0.3
Requires: glibc libdv

%description dv2sub
QDVDAuthor's version of the %{dv2sub} utility for systems that lack it. It 
does not include the dv2sub kino scripts.

%if %{suse}
%debug_package
%endif

%prep

%setup

%if %{build_templates}
%setup -T -D -b 2
%endif

%setup -T -D -b 3

#%if %{mdk}
#%patch -p1
#%endif

%build

%if %{amd64} && %{suse}
# This is the usual path and environment for AMD64 with SuSE 9.0 
export LDFLAGS=-L/usr/X11/lib64 
export QMAKESPEC=linux-g++-64
%endif

# set paths for ffmpeg
export FFMPEG=$(pkg-config --variable=prefix libavformat)
export FFMPEG_INC=$(pkg-config --variable=includedir libavformat)
export FFMPEG_LIB=$(pkg-config --variable=libdir libavformat)

./configure --no-configurator --prefix=%{_prefix} --omit-local-ffmpeg %{configure_opts}

# No call to make is necessary because it is done by the configure script

# build dv2sub
cd ../%{dv2sub}
./configure --prefix=%{_prefix}
make
cd ../%{qdvdauthor_dir}

%install

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

mkdir -p $RPM_BUILD_ROOT%{_prefix}/bin
mkdir -p $RPM_BUILD_ROOT%{_prefix}/man/man1
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/pixmaps
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/applications
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/i18n
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/html/en
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/simpledvd
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/complexdvd
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/lib
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qdvdauthor \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qplayer \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qrender \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.png \
	$RPM_BUILD_ROOT%{_prefix}/share/pixmaps
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.desktop \
	$RPM_BUILD_ROOT%{_prefix}/share/applications
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/doc/html/en/*.html \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/html/en
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/silence.mp2 \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor
install -m 0755 $RPM_BUILD_DIR/%{dv2sub}/src/dv2sub \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0644 $RPM_BUILD_DIR/%{dv2sub}/doc/dv2sub.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/silence.ac3 \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/plugins/libcomplexdvd.so* \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/plugins/libsimpledvd.so* \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/complexdvd/*.jpg \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/complexdvd
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/complexdvd/*.png \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/complexdvd
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/simpledvd/*.jpg \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/simpledvd
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/plugins/simpledvd/*.png \
	$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/plugins/simpledvd
install -m 0755 lib/*so* $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/lib/

%if %{build_templates}
cp -R -p $RPM_BUILD_DIR/%{qdvdauthor_templates_dir}/* \
		$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/
rm -f $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/COPYING
rm -f $RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/INSTALL
%endif

cp -p $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor/i18n/*.qm \
		$RPM_BUILD_ROOT%{_prefix}/share/qdvdauthor/i18n/


%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"
rm -rf $RPM_BUILD_DIR/%{dv2sub}

%files
%defattr(-,root,root)
%{_prefix}/bin/qdvdauthor
%{_prefix}/bin/qplayer
%{_prefix}/bin/qrender
%{_prefix}/share/pixmaps/qdvdauthor.png
%{_prefix}/share/applications/qdvdauthor.desktop
%{_prefix}/share/qdvdauthor/i18n
%{_prefix}/share/qdvdauthor/html/en
%{_prefix}/share/qdvdauthor/silence.mp2
%{_prefix}/share/qdvdauthor/silence.ac3
%{_prefix}/share/qdvdauthor/plugins
%{_prefix}/share/qdvdauthor/lib/*so*
%doc README TODO COPYING CHANGELOG

%if %{build_templates}
%files templates
%defattr(-,root,root)
%{_prefix}/share/qdvdauthor/animated
%{_prefix}/share/qdvdauthor/static
%{_prefix}/share/qdvdauthor/transition
%{_prefix}/share/qdvdauthor/buttons
%{_prefix}/share/qdvdauthor/plugins/menuslide
%{_prefix}/share/qdvdauthor/slideshow
%{_prefix}/share/qdvdauthor/silence.mp2
%doc ../%{qdvdauthor_templates_dir}/COPYING
%endif

%files dv2sub
%defattr(-,root,root)
%{_prefix}/bin/dv2sub
%{_prefix}/man/man1/dv2sub.1*
%doc ../%{dv2sub}/README ../%{dv2sub}/TODO ../%{dv2sub}/COPYING ../%{dv2sub}/ChangeLog ../%{dv2sub}/AUTHORS


%changelog
* Sat Feb 21 2009 D. Scott Barninger <barninger at fairfieldcomputers.com>
- fix file conflict between qdvdauthor and qdvdauthor-templates
* Sun Jan 18 2009 D. Scott Barninger <barninger at fairfieldcomputers.com>
- added slideshow to templates package
* Sat Nov 29 2008 D. Scott Barninger <barninger at fairfieldcomputers.com>
- ver 1.6 remove dvd slideshow and qslideshow, new configure
- use pkgconfig to set paths for ffmpeg locations
* Sun Aug 17 2008 D. Scott Barninger <barninger at fairfieldcomputers.com>
- ver 1.5 add qrender and libjhead
* Sun May 11 2008 D. Scott Barninger <barninger at fairfieldcomputers.com>
- ver 1.2 add plugins
* Sun Mar 30 2008 D. Scott Barninger <barninger at fairfieldcomputers.com>
- upgrade dvd-slideshow to v0.8.0
* Fri Jan 25 2008 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 1.0 final add templates COPYING file
- upgrade dv2sub to v0.3
- add debug_package
* Sat Oct 27 2007 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 1.0 RC2 revise templates package
* Sun Feb 18 2007 D. Scott Barninger <barninger at fairfieldcomputers.com>
- fix %suse_version macro
* Sun Feb 11 2007 D. Scott Barninger <barninger at fairfieldcomputers.com>
- add third party packager tag
- add libdv build requirement
* Sun Feb 04 2007 D. Scott Barninger <barninger at fairfieldcomputers.com>
- add silence.mp2
- add dv2sub package
- add rm of other dirs to clean macro
* Thu Nov 23 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- add html help files
- add build requires for dvdauthor and mplayer as configure now barfs if missing
* Sun Oct 08 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.1.3 release
- add i18n translation files
- add build switch for templates package
* Sun Aug 27 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.1.2 release
- add templates package
* Sat Jul 08 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.1.1 release
- change mandrake grep string to cover mandriva
* Mon Jun 26 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- change Copyright tag to License
* Sun Jan 22 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- add -i to grep of SuSE-release
* Sun Jan 01 2006 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.1.0 release
- patch dvd-slideshow script
* Sun Feb 13 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- fix redhat detection
* Sun Feb 06 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- add command line switch for media backend
* Sat Feb 05 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- add platform detection
- add xine/mplayer build options
* Mon Jan 24 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- remove manual configuration and go with configure script
- add _prefix variable
* Sun Nov 07 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.8 release
- remove ImageMagick Build dependancy
- add Mandrake build support
- updated dvd-slideshow to 0.6.0
- dvd-slideshow now has rpms on sourceforge so add a Conflict
- remove rh9 build and replace with fedora (for all RedHat builds)
- add qplayer application
* Sun May 16 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- update requires for 0.0.6 (xine)
- add build define for AMD 64 bit support
* Sat Apr 03 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- now require dvdauthor >= 0.6.10 and libxml2 >= 2.6
* Tue Mar 09 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- updated dvd-slideshow to 0.5.4
- add dir2slideshow script & man page
- add gallery2slideshow man page
- add jigl2slideshow man page
- added sox to prerequisites (required by dvd-slideshow)
- removed redundant permissions attributes in files section (also bad form per Michael K. Johnson)
- added additional clean of build_root to top of install section
- removed clean of build_dir
* Tue Feb 17 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- changed qt requirement to 3.1
- fixed location of description section; dependencies weren't working
* Sun Feb 15 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- initial spec file
