/****************************************************************************
** Interface to the GUI.
**
**   Created : Sun Feb 23 21:45:00 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** The ButtonObject is a MenuObject derived class, where the user can store
** all associated information (objects).
**
** A Button can consist of a Background (color), an Image or Movie, a Frame,
** and a Text - object.
** All these object can belon to only one button, stacked above each other.
** For this reason the ButtonObject is a container class for those Object.
**
** ButtonObject is also derived from the same base-class as the object it
** contains, simply to make the right handling of mouse events etc easier
** to handle. It also makes a lot of sense designing this structure because
** it makes the MenuPreview class and the MenuObject derived classes so much
** more flexible.
**
**
**
**             [Text]
**      /--------|------------/
**     /         |           / <- [Frame]
**    /  /-------V----------/--/
**   /  /    Click Me      /  / 
**  /  /                  /  /
** /---------------------/  /
**   /                     / <- [Image or Movie]
**  /---------------------/       [Background]
**
****************************************************************************/

#ifndef BUTTONOBJECT_H
#define BUTTONOBJECT_H

// The button state
#define STATE_NORMAL      0
#define STATE_SELECTED    1
#define STATE_HIGHLIGHTED 2

// Which way to go next ...
#define NEXT_BUTTON_UP    0
#define NEXT_BUTTON_DOWN  1
#define NEXT_BUTTON_RIGHT 2
#define NEXT_BUTTON_LEFT  3

class QListViewItem;

#include "menuobject.h"

class SourceFileEntry;
class SourceFileInfo;
class MenuPreview;

class ButtonObject : public MenuObject
{
	Q_OBJECT
public:
	ButtonObject (QWidget *pParent = 0); //, const char * name = 0, WFlags f = 0 );
	virtual ~ButtonObject();
	virtual void drawContents         ( QPainter *          );
	virtual void drawContents         ( QPainter *, uint    );
	virtual void drawContents         ( QPainter *, int, int);
	virtual bool mouseMoveEvent       ( QMouseEvent *       );
	virtual bool mousePressEvent      ( QMouseEvent *       );
	virtual bool mouseReleaseEvent    ( QMouseEvent *       );
	virtual bool mouseDoubleClickEvent( QMouseEvent *       );
	virtual MenuObject *clone         ( QWidget *p1=NULL, MenuObject *p2=NULL );
	virtual ButtonObject &operator =  ( ButtonObject &      );

	virtual MenuObject *shadow        ( );
	virtual void updateShadow         ( );
	virtual void setShadow            ( MenuObject * );

	virtual bool readProjectFile      ( QDomNode    &  );
	virtual bool writeProjectFile     ( QDomElement &  );
	virtual StructureItem *createStructure ( StructureItem * );
	virtual bool createContextMenu    ( QPoint         );
	virtual void setRect              ( QRect &        );
	virtual QRect &rect               ( );
	virtual QRect &boundingRect       ( );
	void createMask                   ( Rgba *         );
	void setPlayMultipleList          ( QStringList &  );
	void setLoopMultiple              ( bool );

	void appendNormal                 ( MenuObject  *  );
	void appendSelected               ( MenuObject  *  );
	void appendHighlighted            ( MenuObject  *  );

	MenuObject *getNormal             ( uint );
	MenuObject *getSelected           ( uint );
	MenuObject *getHighlighted        ( uint );
	
	MenuObject *removeNormal          ( uint );
	MenuObject *removeSelected        ( uint );
	MenuObject *removeHighlighted     ( uint );

	bool removeNormal                 ( MenuObject * );
	bool removeSelected               ( MenuObject * );
	bool removeHighlighted            ( MenuObject * );

	uint getNormalCount               ( );
	uint getSelectedCount             ( );
	uint getHighlightedCount          ( );

	Rgba getMaskColor                 (       bool, int i=0 );
	bool setMaskColor                 ( Rgba, bool, int i=0 );
	QStringList &getPlayMultipleList  ( );
	bool         getLoopMultiple      ( );

	int  chapter                      ( bool );
	void setAction                    ( QString & );
	void setPreAction                 ( QString & );
	void setNext                      ( uint, QString & );
	QString &next                     ( uint );
	QString &action                   ( );
	QString &preAction                ( );

	SourceFileInfo  *sourceFileInfo   ( );
	SourceFileEntry *sourceFileEntry  ( );
	void setSourceFileEntry           ( SourceFileEntry *);

	void deleteMasks                  ( );
	bool readObjects                  ( QDomNode &, MenuPreview *);
	QString &sourceDisplayName        ( );

	void replaceColor                 ( Rgba, Rgba );

protected:
	void clear ();
	virtual AnimationAttribute *getSpecificAttributes (long, QString);


signals:
	void signalUnbuttonMe             (ButtonObject *);
	void signalCreateButtonDialog     (ButtonObject *);

public slots:
	virtual void slotEdit             ( );
	virtual void slotEditObject       ( );
	virtual void slotObjectProperties ( );
	virtual void slotUnbutton         ( );
	virtual void slotEmitUnbuttonMe   ( );
	virtual void slotMoveable         ( );
	virtual void slotToText           ( );
	virtual void slotToFrame          ( );
	virtual void slotToImage          ( );
	virtual void slotToMovie          ( );

protected:
	int     m_iButtonState;
	bool    m_bMoveable;
	QString m_qsAction;	// the action to take ...
	QString m_qsPreAction;  // ';' separated commands before the jump - action.
	QString m_qsUp;
	QString m_qsDown;
	QString m_qsRight;
	QString m_qsLeft;
	SourceFileEntry *m_pSourceFileEntry;
	QString m_qsSourceDisplayName;
	// The following lists hold the information for the different button states.
	QValueList<MenuObject *> m_listNormalState;      // Image or Movie, Frame, Text, Background
	QValueList<MenuObject *> m_listSelectedState;    // Frame, Text, Background
	QValueList<MenuObject *> m_listHighlightedState; // Frame, Text, Background

	QStringList              m_listPlayMultiple;     // If the user selected multiple files to be played
	bool                     m_bLoopMultiple;        // Loop after playing all files in the Multiple list.
};

#endif	// BUTTONOBJECT_H

