/****************************************************************************
** DialogImages
**
**   Created : Sun Apr 27 22:48:00 2008
**        by : Varol Okan using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This dialog offers an easy way to create slideshows from a selection
** of images.
**
** This of course is helpfull if you have 100+ files
**
****************************************************************************/

#ifndef __DIALOGIMAGES_H__
#define __DIALOGIMAGES_H__

#include "dialogfiles.h"
// Separate from global namspace because nested classes 
// are not supported by moc.

class QWMatrix;
class QPopupMenu;
class QIconViewItem;

class CXmlSlideshow;

namespace Input
{

class ImageScan;

class DialogImages : public DialogFiles
{
  Q_OBJECT

  class ImageEntry  {
  public:
     ImageEntry ( );
    ~ImageEntry ( );

    // Note: Can I remove most vars here and use the ones from the cache object ?
    QString   qsFileName; // name of the Image
    QDateTime    created; // Either file date or from exif info ( to be used as a subtitle ? )
    QIconViewItem *pItem; // If the item exists
    QString  qsDimension; // The width x height
    QString  qsImageInfo; // All info returned by jhead

    QString qsComment; // User provided commant ( to be used as subtitle )
    uint  iDurationMs; // Duration the image is visible in Ms
    // Placeholder for a filter 
    QPixmap thePixmap;  // Only set if required to be set ...
    Cache::Thumbs::ImageEntry *pCache;
  };
  class Worker : public QThread  {
  public:
    Worker ( DialogImages * );
    virtual ~Worker  ( );
    bool hasExited   ( );
  protected:
    virtual void run ( );

    DialogImages *pParent;
    bool bExited;
  };
public:
  DialogImages ( QWidget *, bool b=true, const char *n=0, WFlags f=0 );
  virtual ~DialogImages ( );

  QValueList<CXmlSlideshow *> &getSlideshows ( );
  void initMe ( );

protected slots:
  virtual void slotEditGroup      ( );
  virtual void slotCheckWorker    ( );
  virtual void slotPreviewClicked ( int, QIconViewItem *, const QPoint & );
  virtual void slotPreview        ( QIconViewItem * );

  virtual void slotPlay       ( );   // overloaded from DIalogFiles. Calls slotView ( )
  virtual void slotView       ( );
  virtual void slotRemove     ( );
  virtual void slotRotate90   ( );
  virtual void slotRotate180  ( );
  virtual void slotRotate270  ( );
  virtual void slotRotateFree ( );


protected:
  void rotate  (  double );
  void clearSlideshows ( );
  void clearWorker     ( );

//  void rescueImageAttributes ( CXmlSlideshow::img_struct *, CXmlSlideshow * );
  void rescueImageAttributes (  void *, CXmlSlideshow * );

  ImageScan *takeNextScanObject   ( ImageScan *p=NULL );
  virtual QString getDirFilter    ( );
  virtual void setIconText        ( Thumbs        * );
  virtual void setIconText        ( QIconViewItem * );
  virtual void newThumbnailRequest( QIconViewItem * );
  virtual void showBasicMenu      ( const QPoint &  );
  virtual void showContextMenu    ( const QPoint &, QIconViewItem * );
  virtual void playFromGroup      ( Cache::Thumbs::Entry * );
  virtual GroupView *addGroup     ( SourceFileEntry * );
  virtual void timerEvent         ( QTimerEvent * );
  virtual void accept             ( );

private:
  QValueList<CXmlSlideshow *> m_listOfSlideshows;
  QValueList<ImageScan *>     m_listOfImageScansToDo;
  QValueList<ImageScan *>     m_listOfImageScansDone;
  QValueList<Worker *>        m_listOfWorker;

  uint           m_iMaxThreads;
  QPopupMenu    *m_pContextMenu;

  friend class ImageScan;
  friend class Worker;
};

class ImageScan
{
public:
  ImageScan ( DialogImages *, QIconViewItem * );
  virtual ~ImageScan ( );

  bool hasExited ( bool b=false );
  void createPix ( );

private:
  bool bExited;
  DialogImages *pDialog;

public:
  DialogImages::ImageEntry *pEntry;
};

}; // end namespace Input

#endif // __DIALOGIMAGES_H__

