/****************************************************************************
** DialogSlideshow
**
**   Created : Wed Jun 4 12:09:08 2008
**        by : Varol Okan using vi
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef DIALOGSLIDESHOW_H
#define DIALOGSLIDESHOW_H

#include "uislideshow.h"

// 5 seconds transition ...
#define THUMBNAIL_COUNT 5 * 10

class QTimer;
class CXmlSlideshow;

namespace Input
{

class DialogSlideshow : public uiSlideshow
{
    Q_OBJECT

public:
     DialogSlideshow ( QWidget *parent=0 );
    ~DialogSlideshow ( );

  QString     background ( );
  QStringList filterList ( );
  QStringList &audioList ( );
  void initMe ( CXmlSlideshow *, bool b=true );

protected slots:
  virtual void slotAll         ( );
  virtual void slotAnim        ( );
  virtual void slotImage       ( );
  virtual void slotClear       ( );
  virtual void slotColor       ( );
  virtual void slotAddAudio    ( );
  virtual void slotAnimatePix  ( );
  virtual void slotDeleteAudio ( );
  virtual void slotValueChanged(  int );
  virtual void slotIntroPage   ( bool );
  virtual void slotSelectionChanged ( QListViewItem * );

private:
  void initTransitions   ( );
  void createTransitions ( );
  void displayLength     ( );
  void createVidsLength  ( );
  void createAudioLength ( );
  void recreatePix       ( );
  void augmentAlpha      ( int,      QImage &, QImage &, QImage &, QImage & );
  void augmentAlpha      ( int, int, QImage &, QImage &, QImage &, QImage &, QImage * );

private:
  CXmlSlideshow *m_pSlideshow;
  QString        m_qsBackground;
  QStringList    m_listAudio;
  unsigned int   m_iTotalAudioLength;

  QTimer        *m_pTimer;
  QPixmap       *m_arrayPix[THUMBNAIL_COUNT];
  int            m_iCurrentPix;
  bool           m_bAnimated;
};

}; // end of Namespace Input

#endif // DIALOGSLIDESHOW_H
