/****************************************************************************
** Implementation of class Export::DVDAuthor
**
**   Created : 
**        by : Varol Okan using the kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class collects all possible information about
** the current set stream.
**
****************************************************************************/

#ifndef __EXPORT_DVDAUTHOR_H__
#define __EXPORT_DVDAUTHOR_H__

#include <qvaluelist.h>

class SourceFileEntry;
class CXmlDVDAuthor;
class ButtonObject;
class CXmlSpumux;
class QDVDAuthor;
class Subtitles;
class VMGMenu;
class DVDMenu;


namespace Export
{

  class DVDAuthor;

class JumpTable 
{
public:
	JumpTable ();

	// The jumpIndex is the number assigned to g3
	// the menu designated to handle the jumpTable 
	// will use this index to jump to the associated 
	// title / chapter.
	bool            bAlreadyPresent; // the optimization step filters out double entries
	int             iJumpIndex;
	int             iTitle;
	int             iMenu;
	int             iChapter;
	QString         qsAction;
	DVDMenu        *pMenu;
	ButtonObject   *pButton;
};

class ExportTitleset
{
public:
	 ExportTitleset              ( DVDAuthor *       );
	~ExportTitleset              (                   );
	int  findMenu                ( DVDMenu *         );
	int  findTitle               ( SourceFileInfo  * );
	int  findTitle               ( SourceFileEntry * );
	JumpTable *findJumpTable     ( DVDMenu *         );
	int  getTotalChapters        ( SourceFileInfo  * );
	int  getChapters             ( SourceFileInfo  *, QString );
	bool checkForPrePostCommands ( SourceFileEntry *, bool b=false );

	int                           iTitlesetNumber;
	bool                          bSetByUser;
	QString                       qsFormat;
	DVDAuthor                    *pExportDVDAuthor;
	QValueList<DVDMenu *>         listMenus;              // all menus which fit the format.
	QValueList<JumpTable *>       listJumpTable;          // the jump table
	QValueList<SourceFileEntry *> listSourceFileEntries;
};

class PlayMultiple
{
 public:
  PlayMultiple ( SourceFileInfo *, SourceFileInfo * );
  QString getPostCommand  ( );
  void    addPlayMultiple ( QString & );

  SourceFileInfo *pSourceInfo;
  SourceFileInfo *pTargetInfo; // required to determine checkForPrePostCommands
  QString         qsPost;
  bool            bLoop;
};

class DVDAuthor
{
public:
   DVDAuthor  ( QDVDAuthor * );
  ~DVDAuthor  ();

  bool exportXml ();
  bool createXml ();
  bool createXml ( QString & );

private:
  ExportTitleset *findTitleset ( SourceFileEntry * );
  ExportTitleset *findTitleset ( SourceFileInfo * );
  ExportTitleset *findTitleset ( ButtonObject * ); // currently unused ...
  ExportTitleset *findTitleset ( DVDMenu * );
  ExportTitleset *findTitleset ( int );
  JumpTable      *findJumpTableEntry ( ButtonObject * );
  PlayMultiple   *findMultiple ( SourceFileInfo *, bool );
  bool optimizeJumpTable       ( ExportTitleset *, JumpTable * );
  int  getHighestTitlesetNumber( );
  int  getFirstEmptyTitleset   ( );
  bool populateListOfTitlesets ( );
  bool stowMenusAway           ( );
  bool createJumpTable         ( );
  bool createNoMenuDVD         ( QString & );
  bool createDVDAuthorXml      ( QString & );
  void createPlayMultiple      ( ButtonObject   *, DVDMenu *, uint );
  void createJumpToMenu        ( SourceFileInfo *, DVDMenu *, uint );
  QString createFormatString   ( SourceFileInfo *, bool  b = false );
  QString createFormatString   ( DVDMenu * );
  bool cleanUpSourceFileEntries( QValueList<SourceFileEntry *>   & );
  void cleanSourceFileEntris   ( );

  ExportTitleset *addToTitleset(SourceFileEntry *, int, bool b=false      );
  bool addToTitleset( CXmlDVDAuthor::titleset_struct *, SourceFileEntry * );
  bool addToTitleset( CXmlDVDAuthor::titles_struct *,   SourceFileEntry * );
  bool addToTitleset( CXmlDVDAuthor::pgc_struct *,      SourceFileEntry * );
  bool addToTitleset( CXmlDVDAuthor::pgc_struct *,      SourceFileInfo  * );
  bool addToMenu    ( CXmlDVDAuthor::titleset_struct *, ExportTitleset  * );
  bool addToMenu    ( CXmlDVDAuthor::menus_struct *,    ExportTitleset  * );
  bool addToMenu    ( CXmlDVDAuthor::pgc_struct *,      ExportTitleset  * );
  bool addToMenu    ( CXmlDVDAuthor::titleset_struct *, DVDMenu         * );
  bool addToMenu    ( CXmlDVDAuthor::menus_struct *,    DVDMenu         * );
  bool addToMenu    ( CXmlDVDAuthor::pgc_struct *,      DVDMenu         * );
  bool addToVideo   ( CXmlDVDAuthor::video_struct *,    QString&,QString& );
  bool addToVideo   ( CXmlDVDAuthor::video_struct *,    int,int,QString & );
  bool addToAudio   ( CXmlDVDAuthor::menus_struct *,    DVDMenu         * );

  CXmlDVDAuthor::pgc_struct *getPgc ( CXmlDVDAuthor::menus_struct *, DVDMenu * );
  DVDMenu *getMenuFromButton   ( ButtonObject     * );
  DVDMenu *getMenuFromEntry    ( SourceFileEntry  * );
  QString jumpToSubMenu        ( SourceFileEntry  * );
  QString adjustChapterOffset  ( QStringList &, int );
  void getButtonNumberFromName ( QValueList<ButtonObject *> &, QString & );

  bool m_bOutOfSpecDialog;
  bool m_bMenuZeroDialog;
  bool m_bInsertComments;
  QDVDAuthor *m_pDVDAuthor;
  QValueList<DVDMenu *>         m_listOfAllMenus; 
  QValueList<PlayMultiple *>    m_listPlayMultiple;
  QValueList<ExportTitleset *>  m_listTitlesets;
  QValueList<SourceFileEntry *> m_listNewEntries;
  friend class ExportTitleset;
};

class Spumux
{
public:
   Spumux ( );
  ~Spumux ( );

  bool createXml      ( );
  bool createXml      ( DVDMenu * );
  bool createXml      ( SourceFileInfo * );
  bool createXml      ( SourceFileInfo *, Subtitles * );
  bool createTextXml  ( SourceFileInfo *, Subtitles * );
  bool createImageXml ( SourceFileInfo *, Subtitles * );

protected:
  bool correctOverlappingButtons ( QValueList<QRect> &, int, int );

};

}

#endif // __EXPORT_DVDAUTHOR_H__
