/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include <vpopmail.h>
#include <vpopmail_config.h>
#include <vauth.h>
#include "config.h"
#include "qmailadmin.h"
#include "qmailadminx.h"

static char dchar[4];
void check_user_forward_vacation(char newchar);

static char NTmpBuf[500];

/*
 * send an html template to the browser 
 */
int send_template(char *actualfile)
{
  send_template_now("header.html");
  send_template_now(actualfile);
  send_template_now("footer.html");
  return 0;
}

int send_template_now(char *filename)
{
 FILE *fs;
 int i;
 int j;
 int inchar;
 int testint;
 char *tmpstr;
 struct stat mystat;
    

  if (strstr(filename, "/")!= NULL||strstr(filename,"..")!=NULL) {
    printf("warning: invalid file name %s\n", filename );
    return(-1);
  }


  tmpstr = getenv(QMAILADMIN_TEMPLATEDIR);
  if (tmpstr == NULL ) tmpstr = HTMLLIBDIR; 
  snprintf(TmpBuf2, (MAX_BUFF - 1), "%s/%s", tmpstr, filename);

  if (lstat(TmpBuf2, &mystat)==-1 || S_ISLNK(mystat.st_mode)) {
    printf("warning: file name is symbolic link %s\n", filename );
    return(-1);
  } 

  /* open the template */
  fs = fopen( TmpBuf2, "r" );
  if (fs == NULL) {
    fprintf(actout,"%s %s<br>\n", get_html_text("144"), TmpBuf2);
    return 0;
  }

  /* parse the template looking for "##" pattern */
  while ((inchar = fgetc(fs)) >= 0) {
    /* if not '#' then send it */
    if (inchar != '#') {
      fputc(inchar, actout);

    /* found a '#' */
    } else {
      /* look for a second '#' */
      inchar = fgetc(fs);
      if (inchar < 0) {
        break;

      /* found a tag */
      } else if (inchar == '#') {
        inchar = fgetc(fs);
        if (inchar < 0) break;

        /* switch on the tag */
        switch (inchar) {
          /* dictionary line, we three more chars for the line */
          case 'X':
            for(i=0;i<3;++i) dchar[i] = fgetc(fs);
            dchar[i] = 0;
            printf("%s", get_html_text(dchar));
            break;

          case 'p':
            show_user_lines(Username, Domain, Mytime, RealDir);
            break;

          /* show version number */
          case 'V':
            printf("<a href=http://www.inter7.com/qmailadmin>%s</a> %s<BR>", 
              QA_PACKAGE, QA_VERSION);
            printf("<a href=http://www.inter7.com/vpopmail>%s</a> %s<BR>", 
              PACKAGE, VERSION);
            break;

          /* show number of pop accounts */
          case 'B':
            load_limits();
            count_users();
            if(MaxPopAccounts > -1) {
              printf("%d/%d", CurPopAccounts, MaxPopAccounts);
            } else {
              printf("%d/%s", CurPopAccounts, get_html_text("229"));
            }
            break;

          /* parse include files */
          case 'N':
            i=0; 
            TmpBuf[i]=fgetc(fs);
            if (TmpBuf[i] == '/') {
              fprintf(actout, "%s", get_html_text("144"));
            } else {
              for(;TmpBuf[i] != '\0' && TmpBuf[i] != '#' && i < MAX_BUFF;) {
                TmpBuf[++i] = fgetc(fs);
              }
              TmpBuf[i] = '\0';
              if ((strstr(TmpBuf, "../")) != NULL) {
                fprintf(actout, "%s: %s", get_html_text("144"), TmpBuf);
              } else if((strcmp(TmpBuf, filename)) != 0) {
                send_template_now(TmpBuf);
              }
            }
            break;

          case 'v':
            fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font><br>", 
              Domain);
            fprintf(actout, 
       "<font size=\"2\" color=\"#ff0000\"><b>%s</b></font><br>", 
              get_html_text("001"));
            if (AdminType==DOMAIN_ADMIN){

              if (MaxPopAccounts != 0) {
                fprintf(actout, 
       "<a href=\"%s/com/showusers?user=%s&time=%i&dom=%s&\">",
                  CGIPATH,Username,Mytime,Domain); 
                fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                  get_html_text("061"));
              }

              if (MaxForwards != 0 || MaxAliases != 0) {
                fprintf(actout, 
       "<a href=\"%s/com/showforwards?user=%s&time=%i&dom=%s&\">",
                  CGIPATH,Username,Mytime,Domain);
                fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s %s</b></font></a><br>",
                  get_html_text("121"),get_html_text("122"));
              }

              if (MaxAutoResponders != 0) {
                fprintf(actout, 
       "<a href=\"%s/com/showautoresponders?user=%s&time=%i&dom=%s&\">",
                  CGIPATH,Username,Mytime,Domain);
                fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></a></font><br>",
                  get_html_text("077"));
              }

              if (MaxMailingLists != 0) {
                fprintf(actout, 
       "<a href=\"%s/com/showmailinglists?user=%s&time=%i&dom=%s&\">",
                  CGIPATH, Username,Mytime,Domain);
                fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                  get_html_text("080"));
              }
            } else {
               fprintf(actout, 
       "<a href=\"%s/com/moduser?user=%s&time=%i&dom=%s&moduser=%s\">",
                 CGIPATH,Username,Mytime,Domain,Username);
               fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s %s</b></font></a><br><br>",
                 get_html_text("111"), Username);
             }

             if (AdminType == DOMAIN_ADMIN) {
               fprintf(actout, "<br>");
               fprintf(actout, 
       "<font size=\"2\" color=\"#ff0000\"><b>%s</b></font><br>",
                 get_html_text("124"));

               if (MaxPopAccounts != 0) {
                 fprintf(actout, 
       "<a href=\"%s/com/adduser?user=%s&time=%i&dom=%s&\">",
                   CGIPATH,Username,Mytime,Domain);
                 fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                   get_html_text("125"));
               }

               if (MaxAliases != 0) {
                 fprintf(actout, 
       "<a href=\"%s/com/adddotqmail?atype=alias&user=%s&time=%i&dom=%s&\">",
                   CGIPATH, Username,Mytime,Domain);
                 fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                   get_html_text("126"));
               }

               if (MaxForwards != 0) {
                 fprintf(actout, 
       "<a href=\"%s/com/adddotqmail?atype=forward&user=%s&time=%i&dom=%s&\">",
                   CGIPATH, Username,Mytime,Domain);
                 fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                   get_html_text("127"));
               }

               if (MaxAutoResponders != 0) {
                 fprintf(actout, 
       "<a href=\"%s/com/addautorespond?user=%s&time=%i&dom=%s&\">",
                   CGIPATH, Username,Mytime,Domain);
                 fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></a></font><br>",
                   get_html_text("128"));
               }

               if (MaxMailingLists != 0) {
                 fprintf(actout, 
       "<a href=\"%s/com/addmailinglist?user=%s&time=%i&dom=%s&\">",
                   CGIPATH, Username,Mytime,Domain);
                 fprintf(actout, 
       "<font size=\"2\" color=\"#000000\"><b>%s</b></font></a><br>",
                   get_html_text("129"));
               }
             }
             break;

          /* show the lines inside a alias table */
          case 'b':
            show_dotqmail_lines(Username,Domain,Mytime,RealDir,"alias");
            break;

          /* show the lines inside a mailing list table */
          case 'c':
            show_mailing_list_line2(Username,Domain,Mytime,RealDir);
            break;

          /* show the lines inside a forward table */
          case 'd':
            show_dotqmail_lines(Username,Domain,Mytime,RealDir,"forward");
            break;

          /* show the lines inside a mailing list table */
          case 'e':
            show_mailing_list_line(Username,Domain,Mytime,RealDir);
            break;

          /* this will be used to parse mod_mailinglist-idx.html */
            case 'E':
            show_current_list_values();
            break;

          /* show the forwards */
            case 'f':
              if (AdminType == DOMAIN_ADMIN) {
                show_forwards(Username,Domain,Mytime,RealDir);
              }
              break;

          /* show the lines inside a autorespond table */
          case 'g':
            show_autorespond_line(Username,Domain,Mytime,RealDir);
            break;

          /* show the counts */
          case 'h':
            show_counts();
            break;

          /* check for user forward and forward/store vacation */
          case 'i':
            check_user_forward_vacation(fgetc(fs));
            break;

          /* show the users */
          case 'u':
            show_users(Username,Domain,Mytime,RealDir);
            break;

          /* show the aliases stuff */
          case 'l':
            if (AdminType == DOMAIN_ADMIN) {
              show_aliases(Username,Domain,Mytime,RealDir);
            }
            break;

          /* show the mailing lists */
          case 'm':
            if (AdminType == DOMAIN_ADMIN) {
              show_mailing_lists(Username,Domain,Mytime,RealDir);
            }
            break;

          /* show the mailing list subscribers */
          case 'M':
            if (AdminType == DOMAIN_ADMIN) {
              show_list_users_now();
            }
            break;

          /* show the mailing list moderators */
          case 'o':
            if (AdminType == DOMAIN_ADMIN) {
              show_list_moderators_now();
            }
            break;

          /* show the mailing list digest subscribers */
          case 'G':
            if (AdminType == DOMAIN_ADMIN) {
              show_list_digest_users_now();
            }
            break;

          /* show the autoresponder stuff */
          case 'r':
            if (AdminType == DOMAIN_ADMIN) {
              show_autoresponders(Username,Domain,Mytime,RealDir);
            }
            break;

          /* send the CGIPATH parameter */
          case 'C':
            fprintf(actout,"%s", CGIPATH);
            break;

          /* send the Alias parameter */
          case 'a':
            fprintf(actout,"%s", Alias);
            break;

          case 'I':
            show_dotqmail_file(ActionUser);
            break;

          /* send the action user parameter */
          case 'A':
            fprintf(actout,"%s", ActionUser);
            break;

          /* send the domain parameter */
          case 'D':
            fprintf(actout,"%s", Domain);
            break;

          /* send the username parameter */
          case 'U':
            fprintf(actout,"%s", Username);
            break;

          /* send the time parameter */
          case 'T':
            fprintf(actout,"%d", Mytime);
            break;

          /* send the status message parameter */
          case 'S':
            fprintf(actout,"%s", StatusMessage);
            break;

          /* show the catchall name */
          case 's':
            get_catchall();
            break;

          /* display a file */
          case 'F':
            {
             FILE *fs;
              sprintf(TmpBuf, ".qmail-%s", ActionUser);
              for (i=6; TmpBuf[i] != 0; ++i) {
                if (TmpBuf[i] == '.') TmpBuf[i] = ':';
              }
              if ((fs=fopen(TmpBuf, "r")) == NULL) ack("123", 123);
              fgets(TmpBuf2, MAX_BUFF, fs);

              if (fgets(TmpBuf2, MAX_BUFF, fs)) {

                /* See if it's a Maildir path rather than address */
                i = strlen(TmpBuf2) - 2;
                if (TmpBuf2[i] == '/') {
                  --i;
                  for(; TmpBuf2[i] != '/'; --i);
                  --i;
                  for(;TmpBuf2[i]!='/';--i);
                  for(++i, j=0; TmpBuf2[i] != '/'; ++j,++i) {
                    TmpBuf3[j] = TmpBuf2[i];
                  }
                  TmpBuf3[j] = '\0';
                  fprintf(actout, "value=\"%s@%s\"><td>\n", TmpBuf3, Domain);
                } else {
                  /* take off newline */
                  i = strlen(TmpBuf2); --i; TmpBuf2[i] = 0;
                  fprintf(actout, "value=\"%s\"><td>\n", &TmpBuf2[1]);
                }
              } 
              fclose(fs);
              upperit(ActionUser);
              sprintf(TmpBuf, "%s/message", ActionUser);

              if ((fs = fopen(TmpBuf, "r")) == NULL) ack("123", 123);

              fgets( TmpBuf2, MAX_BUFF, fs);
              fgets( TmpBuf2, MAX_BUFF, fs);
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t<td>&nbsp;</td>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t  <td><b>%s</b>&nbsp;</td>\n", get_html_text("006"));

              /* take off newline */
              i = strlen(TmpBuf2); --i; TmpBuf2[i] = 0;
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t  <td><input type=\"text\" size=\"40\" name=\"alias\" maxlength=\"128\" value=\"%s\"></td>\n",
                &TmpBuf2[9]);
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t  <td>&nbsp;</td>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t</tr>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t</table>\n");
              fprintf(actout, "\t\t\t\t\t\t\t\t\t\t\t\t<textarea cols=\"80\" rows=\"40\" name=\"message\">");
                fgets(TmpBuf2, MAX_BUFF, fs);
              while (fgets(TmpBuf2, MAX_BUFF, fs)) {
                fprintf(actout, "%s", TmpBuf2);
              }
              fprintf(actout, "</textarea>");
              fclose(fs);
            }
            break;

          case 'O':
            {
             struct vqpasswd *pw;

               pw = vauth_getall(Domain,1,0);
               while (pw != NULL) {
                 fprintf(actout, "<option value=\"%s\">%s</option>\n", 
                   pw->pw_name, pw->pw_name);
                 pw = vauth_getall(Domain,0,0);
               }
            }
            break;

          default:
            break;
        }
        /*
         * didn't find a tag, so send out the first '#' and 
         * the current character
         * 
         */
      } else {
        fputc('#', actout);
        fputc(inchar, actout);
      }
    } 
  }
  fclose(fs);
  fflush(actout);
  vclose();

  return 0;
}

void check_user_forward_vacation(char newchar)
{
 static struct vqpasswd *vpw = NULL;
 static FILE *fs1=NULL; /* for the .qmail file */
 static FILE *fs2=NULL; /* for the vacation message file */
 int i;

  if (vpw==NULL) vpw = vauth_getpw(ActionUser, Domain); 
  if (fs1== NULL) {
    snprintf(NTmpBuf,500, "%s/.qmail", vpw->pw_dir);
    fs1 = fopen(NTmpBuf,"r");
  }

  if ( newchar=='7') {
    fprintf(actout, "%s", vpw->pw_gecos);
    return;
  }

  if (fs1 == NULL) {
    if (newchar=='0'){
      printf("checked ");
    }
    return;
  } 

  /* start at the begingin if second time thru */
  rewind(fs1);

  if (fgets(NTmpBuf,500,fs1)!=NULL) {
                           
    /* if it is a forward to a program */
    if (strstr(NTmpBuf, "autorespond")!=NULL ) {
      if (newchar=='4') {
        printf("checked ");
      } else if (newchar=='5') {
        if (fs2 == NULL) { 
          snprintf(NTmpBuf,500, "%s/vacation/message", vpw->pw_dir);
          fs2 = fopen(NTmpBuf,"r");
        }
        if (fs2 != NULL) {
          rewind(fs2);
          /*
           *  it's a hack, the second line always has
           *  the subject
           */ 
          fgets(NTmpBuf,500,fs2);
          fgets(NTmpBuf,500,fs2);
          printf("%s", &NTmpBuf[9]);
        }
      } else if (newchar=='6') {
        if (fs2 == NULL) { 
          snprintf(NTmpBuf,500, "%s/vacation/message", vpw->pw_dir);
          fs2 = fopen(NTmpBuf,"r");
        }
        if (fs2 != NULL) {
          rewind(fs2);
          for(i = 0; i < 3 && fgets(NTmpBuf,500,fs2) != NULL; ++i);
          while (fgets(NTmpBuf,500,fs2) != NULL) {
            printf("%s", NTmpBuf);
          }
        }
      }

      i = 0;
      do {
        if ( newchar == '3' && NTmpBuf[0] == '/' ) {
          printf("checked ");
          return;
        }
        if ( newchar == '2' ) {
          if (NTmpBuf[0]=='/') continue;
          if (NTmpBuf[0]=='|') continue;
          if ( i>0 ) printf(", ");
          if (NTmpBuf[0]=='&') {
            printf("%s", strtok(&NTmpBuf[1], "\n"));
          } else {
            printf("%s", NTmpBuf[0]);
          } 
          ++i;
        }
      } while(fgets(NTmpBuf,500,fs1) != NULL );
                   
      
      return;
    } else {
      if (newchar == '1') {
        printf("checked ");
        return;
      }
      i = 0;
      do { 
        if (newchar == '3' && NTmpBuf[0] == '/') {
          printf("checked "); 
          return;
        }

        if (newchar == '2') {
          if (NTmpBuf[0]=='/') continue;
          if (i > 0) printf(", ");
          if (NTmpBuf[0] == '&') {
            printf("%s", strtok(&NTmpBuf[1], "\n"));
          } else {
            printf("%s", NTmpBuf);
          } 
          ++i;
        }
      } while (fgets(NTmpBuf,500,fs1) != NULL);
    }
  }
  return;
}
