#! /usr/bin/perl
#
# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;
use Qt;
use InstWiz;
use InstSplash;
use DesignerMimeSourceFactory_qvamps;


my $app    = Qt::Application (\@ARGV);
my $pixmap = Qt::Pixmap;

$pixmap -> loadFromData (PAR::read_file ("images/inst_splash.png"));

my ($win, $icon);
my $splash = InstSplash ($pixmap);
my $font   = $splash -> font ();

$splash -> show ();
$font   -> setPixelSize (22);
$splash -> setFont ($font);
$splash -> repaint ();

{
  my    $show_splash = 1;
  local $SIG {ALRM}  = sub { $show_splash = 0; };

  # show splash screen for at least 3s
  alarm (3);

  $win  = InstWiz;
  $icon = Qt::Pixmap::fromMimeSource ("icon.png");

  $win -> setIcon ($icon);
  $app -> setMainWidget ($win);
  $win -> show ();

  while ($show_splash)
  {
    select (undef, undef, undef, 0.1);
  }

  $splash -> finish ($win);
}

undef $pixmap;
undef $splash;

exit ($app -> exec ());
