/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.NamespaceHelper;

public class DocumentBinding
extends AbstractBinding {
    public void readMessage(InMessage inMessage, MessageContext context) throws XFireFault {
        Service endpoint = context.getService();
        Collection operations = endpoint.getServiceInfo().getOperations();
        this.read(inMessage, context, operations);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        MessagePartInfo outParam;
        OperationInfo op = context.getExchange().getOperation();
        Object[] values = (Object[])message.getBody();
        int i = 0;
        MessageInfo msgInfo = null;
        boolean client = DocumentBinding.isClientModeOn(context);
        msgInfo = client ? op.getInputMessage() : op.getOutputMessage();
        HashSet<String> namespaces = new HashSet<String>();
        Iterator itr = msgInfo.getMessageParts().iterator();
        while (itr.hasNext()) {
            outParam = (MessagePartInfo)itr.next();
            String ns = this.getBoundNamespace(context, outParam);
            namespaces.add(ns);
        }
        Iterator iter = namespaces.iterator();
        while (iter.hasNext()) {
            String ns = (String)iter.next();
            try {
                NamespaceHelper.getUniquePrefix(writer, ns, true);
            }
            catch (XMLStreamException e) {
                throw new XFireFault("Could not write to outgoing stream.", e, XFireFault.RECEIVER);
            }
        }
        itr = msgInfo.getMessageParts().iterator();
        while (itr.hasNext()) {
            outParam = (MessagePartInfo)itr.next();
            try {
                Object value = client ? this.getClientParam(values, outParam, context) : this.getParam(values, outParam, context);
                DocumentBinding.writeParameter(writer, context, value, outParam, this.getBoundNamespace(context, outParam));
            }
            catch (XMLStreamException e) {
                throw new XFireFault("Could not write to outgoing stream.", e, XFireFault.RECEIVER);
            }
            ++i;
        }
    }
}

