# These are functions that encapsulate the names
# of the exact form of the C-level symbols that
# implement the R/SPlus ggobi interface.
# These allow us to change the prefix used for these symbols
# in order to avoid name conflicts with other packages, etc.


.ggobi.symbol <-
#
# A simple way of generating the prefix for a symbol
# used in this package/library so that we can hide
# it from other packages and avoid conflicts.
#
function(name)
{
  paste("RS_GGOBI", name, sep="_")
}


.GGobiCall <-
#
# Convenience function for calling
# routines within the GGobi chapter
# in the same manner as .Call()
#
function(name, ..., .gobi = getDefaultGGobi())
{
 if(missing(.gobi))
  stop("It is rare that the .gobi argument is missing. Probably a mistake")

 if(is.numeric(.gobi))
   .gobi <- as.integer(.gobi-1)

 .Call(.ggobi.symbol(name),..., .gobi)
}

.GGobiC <-
# Convenience function for calling
# routines within the GGobi chapter
# in the same manner as .C()
#
function(name, ..., .gobi = getDefaultGGobi())
{
 if(missing(.gobi))
  stop("It is rare that the .gobi argument is missing. Probably a mistake")

 if(is.integer(.gobi))
   .gobi <- as.integer(.gobi-1)
 else if(inherits(.gobi, "ggobi")) {
   .gobi <- unclass(.gobi)[["ref"]]
 } else
   stop("The .gobi argument should be an integer or an object of class ggobi")
 .C(.ggobi.symbol(name),..., .gobi)
}

