checkStructs.ggobi <-
function()
{
  ours <- .Call(.ggobi.symbol("getStructSizes"), TRUE)
  theirs <- .Call(.ggobi.symbol("getStructSizes"), FALSE)

  which <- match(names(ours), names(theirs))
  if(any(is.na(which)))
    stop(paste("No information about some struct(s):", paste("`", names(ours)[is.na(which)],"'", collapse=", ", sep="")))

  ok <- ours == theirs[which]
  if(!all(ok)) {
    warning("some structs have different size")
    return(ok)
  }

  TRUE
}

