#
# These functions provide basic access to the
# underlying Gtk objects within the GGobi data
# structures. These can then be used with the RGtk
# package to combine plots in a different GtkContainer,
# specify event callback functions, etc.
#
#
# Want a way to be able to create a display without
# creating the window.
#

getDisplayWindow.ggobi <-
function(display = 1, .gobi = getDefaultGGobi(), expandClasses = TRUE)
{
#
# This returns an reference to the GtkWindow object
# associated with the given display.
#
# The value of display should be either an integer
# identifying by index the display of interest within the GGobi
# instance (.gobi), or an object of class ggobiDisplay
#  
#  
  if(is.numeric(display)) {
    display <- as.integer(display)
    display <- getDisplays.ggobi(FALSE, .gobi=.gobi)[[display]]
    
  }

  if(!inherits(display, "ggobiDisplay"))
    stop("Need an object of class ggobiDisplay")
  
  dpy <- .Call(.ggobi.symbol("getDisplayWindow"), display)

    # now put on the class information.
  if(!is.null(dpy) && expandClasses) {
     require(RGtk)
     class(dpy) <- gtkObjectGetClasses(dpy, check = FALSE)
  }

  dpy
}  

getPlotWidgets.ggobiDisplay <-
function(dpy, expandClasses = TRUE)  
{
#
# Get references to the GtkDrawingArea widgets
# of the splotd objects in the given display.
# The value of dpy should be an object of class
# ggobiDisplay and can be obtained using a call of the
# form
#    getDisplays.ggobi(FALSE)[[which]]
#  
 if(!inherits(dpy, "ggobiDisplay"))
    stop("Object must be of class ggobiDisplay")


 els <- .Call(.ggobi.symbol("getDisplayPlotWidgets"), dpy)
 if(expandClasses) {
   require(RGtk)  
   els <- lapply(els, function(x) {
                         class(x) <- gtkObjectGetClasses(x, check = FALSE)
                         x
                       })
 }

 els
}

