getEdges.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
 if(is.numeric(.data))
   .data <- as.integer(.data - 1)

  m <- .GGobiCall("getConnectedEdges", .data, .gobi = .gobi)
  colnames(m) <- c("source", "destination")

  m
}


setEdges.ggobi <-
#
# x and y are vectors of equal length identifying the points
#
function(x, y, append=T, .data = 1, .gobi = getDefaultGGobi())
{
 if(missing(y)) {
  if(is.matrix(x)) {
    y <- x[,2]
    x <- x[,1]
  }
 } 

 if(length(x) != length(y)) {
    m <- min(length(x),length(y))
    length(x) <- m
    length(y) <- m
 }

 if(mode(.data) == "numeric") {
    if(.data <= getNumDatasets.ggobi(.gobi = .gobi))
      .data <- .gobi[[ .data ]]

  if(FALSE) {    
    if(!inherits(.data, "ggobiEdgeDataset")) {
      .data <- createEdgeData.ggobi(length(x), .gobi = .gobi)
    }
  }
 }

 if(mode(x) != mode(y))
   stop("x and y must have the same types")

 if(mode(x) == "character") {
   v <- .GGobiCall("setEdges", x, y, as.logical(append), 
                                       .data, .gobi=.gobi)
 } else 
   v <- .GGobiCall("setEdgeIndices", as.integer(x), as.integer(y), as.logical(append), 
                                       .data, .gobi=.gobi)
}



createEdgeData.ggobi <-
function(numEdges, labels=rep("", numEdges), colors = NULL, .gobi = getDefaultGGobi())
{
 d <- .GGobiCall("createEdgeDataset", as.integer(numEdges), .gobi = .gobi)

 setRowNames.ggobi(as.character(labels), .data = d)

 if(!is.null(colors))
  setColors.ggobi(colors, .data = d)

 d
}



setDisplayEdges.ggobi <-
function(displays, edgeData, directed = FALSE, .gobi = getDefaultGGobi())
{
 if(missing(displays))
    displays <- getDisplays.ggobi(.gobi = .gobi)

 if(inherits(displays, "ggobiDisplay"))
   displays <- list(displays)

 if(missing(edgeData)) {
   datasets <- getDatasetReference.ggobi(1:getNumDatasets.ggobi(.gobi=.gobi), .gobi = .gobi)
   e <- sapply(datasets, function(x) inherits(x, "ggobiEdgeDataset"))
   if(!any(e))
     stop("No edge data")

   k <- ((1:length(e))[e])[1] 
   edgeData <- datasets[[ k ]]
 } else {
   if(is.numeric(edgeData)) {
     edgeData <- .gobi[[edgeData]]
   }
 }

 if(!inherits(edgeData, "ggobiEdgeDataset"))
   stop("Not an edge dataset")

 .GGobiCall("setDisplayEdges", displays, edgeData, as.logical(directed), .gobi = .gobi)
}

