\name{setBrushLocation.ggobi}
\alias{setBrushSize.ggobi}
\alias{getBrushSize.ggobi}
\alias{setBrushLocation.ggobi}
\alias{getBrushLocation.ggobi}
\title{Gets or sets the location and/or dimension of the selection region
       of a ggobi dataset.}
\description{
 This  allows the user to query and set the location and 
 size of the brushing region of a ggobi dataset.
}
\usage{
setBrushLocation.ggobi(x, y, .data = 1, .gobi=getDefaultGGobi(), update=T, units=0)
getBrushLocation.ggobi(.data = 1, .gobi=getDefaultGGobi(), units=0)
setBrushSize.ggobi(w, h, .data=1, .gobi=getDefaultGGobi(), update = T, units=0)
getBrushSize.ggobi(.data=1, .gobi=getDefaultGGobi(), units=0)
}
\arguments{
  \item{x}{the x coordinate at which to locate the brushing region (in pixels)}
  \item{y}{the x coordinate at which to locate the brushing region (in pixels)}
  \item{w}{the width to which to set the brushing region (in pixels)}
  \item{h}{the height to which to set the brushing region (in pixels)}
  \item{.data}{the dataset identifier for which the brush should be set or queried.
 This can be a simple index or an object of class \code{ggobiDataset}.
If the latter is set, no value for \code{.gobi} need be specified.}
  \item{.gobi}{the identifier for the ggobi instance in which the 
 dataset can be resolved. This can be either an index identifying
the ggobi instance by order, or an object of class \code{ggobi} 
returned from a call to \code{\link{ggobi}} or \code{\link{getGGobi}}.}
  \item{update}{whether to force the recomputation of the points within 
 the brushing region and the updating of the display giving the number of points
 within this region. This is often supressed when changing both location and size
 in two separate actions.}
  \item{units}{currently ignored, but will allow specification of what units}
}
\details{
}
\value{
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\note{ The settings are in pixel coordinates relative to the plot and
not the coordinates of the data being plotted.  In the future, we will
provide functions to map between these different units.}


\seealso{
\code{\link{getSelectedIndices.ggobi}}
\code{\link{getBrushColor.ggobi}}
\code{\link{setBrushColor.ggobi}}
\code{\link{getBrushGlyph.ggobi}}
\code{\link{setBrushGlyph.ggobi}}
}

\examples{
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 g$setMode("Brush"); 
 g$setBrushLocation(50, 50); 
 g$setBrushSize(100, 50); 
 g$getSelectedIndices()
}
\keyword{visualization}
\keyword{interactive graphics}


