\name{getColorMap.ggobi}
\alias{getColorMap.ggobi}
\alias{setColorMap.ggobi}
\title{Set or query the colormap for a ggobi instance.}
\description{
 These functions allow one to retrieve or set the contents
of the color map used by a ggobi instance.
The color map is an $n \times 3$ matrix of
of which each row contains the 
Red, Green and Blue values defining a color.
Some colors have names and others are referenced
simply by index in the colormap.
}
\usage{
getColorMap.ggobi(.gobi=getDefaultGGobi())
setColorMap.ggobi(vals, .gobi=getDefaultGGobi(), scale = 65535)
}
\arguments{
  \item{vals}{an $n$ by $3$ matrix giving the entries in the colormap
   in terms of their Red, Green and Blue components. The columns of the matrix
  should be in that order.}
  \item{.gobi}{an identifier for the ggobi instance whose color map is
to be set or retrieved. This is either an integer or an object
of class \code{ggobi}.}
  \item{scale}{a scaling factor by which the elements of the matrix
   are multiplied to convert them to internal format for use with Gtk.}
}
\details{
  These functions convert the internal representation in
ggobi of a colormap to an R matrix and vice-versa.
}
\value{
 \code{getColorMap.ggobi} returns a matrix of 
dimension $n \times 3$ containing the Red, Green and Blue values
with each element being between  $0$ and $1$.
The row names are those stored in the ggobi colormap, if supplied
when reading the color map,
or otherwise the index (starting at $1$).

 \code{setColorMap} 
}
\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}


\note{
 Currently, when operating on the colormap, one must operate on all of
it, rather than operating on individual elements.  In other words, one
has to copy it all into R, modify the values and then transfer it back
to ggobi.  Since colormaps are reasonably small, can be specified in
files and change infrequently, this is not a large penalty.  }

\seealso{
\code{\link{getColors.ggobi}}
\code{\link{setColors.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$getColorMap()
  names(g$getColorMap())
  
    # register a new color map with only 3 entries - Red, Green and Blue.
    # Then convert the colors' of the points to these values.
  cm <- diag(3)
  rownames(cm) <- c("R", "G","B")
  g$setColorMap(cm)

\dontrun{
  m["green", 1] <- .5
  g$setColorMap(m)
  g$setColors(rep("green", 20))
}

\dontrun{
  # Copy a colormap from one ggobi to another
 g1 <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 g2 <- ggobi(system.file("data", "sat.xml", package="Rggobi"), args="-noinit")
 g2$setColorMap(g1$getColorMap())
}
}
\keyword{visualization}
\keyword{interactive graphics}
