\name{[.ggobiDataset}
\alias{[.ggobiDataset}
\alias{[<-.ggobiDataset}
\alias{[[<-.ggobiDataset}
\title{Subsetting extraction and assignments for ggobi datasets}
\description{
These functions/methods allow one to treat
a ggobi dataset as if it were a local matrix/data.frame.
One can extract and assign elements within the 
dataset.
There is a fundamental difference between
the two assignment operators (\code{[<-} and \code{[[<-}).
  The \code{[<-} operator first retrieves all the data
  from the GGobi dataset, does the replacement using R's
  semantics and then resets the data.
  \code{[[<-} attempts directly replaces
  the value(s) specified by the index d
  within the GGobi. This is much more efficient
  as it avoids copying all the data.
  However, the semantics are not the same as the
  usual R subsetting. This is currently intended
  for changing individual points and support for
  vector indices will probably change.
}
\usage{
"[.ggobiDataset"(x, ..., drop=F)
"[<-.ggobiDataset"(x, i, j, value)
"[[<-.ggobiDataset"(x, i, j, value)
}
\arguments{
  \item{x}{the \code{ggobiDataset} object}
  \item{drop}{the drop argument as in the regular 
      matrix and data frame subsetting functions.
     This is passed to the relevant subset operation when the data is transferred.}
  \item{\dots}{the indices by which to subset the dataset}
  \item{i}{the indices for selecting the rows of the matrix to which
    the values are to be assigned.}
  \item{j}{the indices for selecting the columns of the matrix to which
    the values are to be assigned.}
  \item{value}{the values to assigned to the elements of the matrix.}
}
\details{
 At present, the assignment is unecessarily expensive
in that it transfers the entire dataset from 
ggobi, performs the usual subsetting operations
and then transfers the results back into the
variables of the original dataset.
This can be made smarter.
}
\value{
 The subsetting operator \code{[}
 returns the result of subsetting the
 matrix corresponding to the ggobi dataset.
 This is identical to the functionality of the
 subsetting of a matrix.

 The assignment operator \code{[<-}
 returns the original \code{ggobiDataset} 
 object. The side-effect is to modify the
 contents of the internal ggobi dataset.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{setVariableValues.ggobi}}
  \code{\link{getVariable.ggobi}}
  \code{\link{getData.ggobi}}
  \code{\link{names.ggobiDataset}}
  \code{\link{dimnames.ggobiDataset}}
}

\examples{
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 d <- g[[1]]
 d[1,1] <- 100
# d[[1,1]] <- 100
  # 
 g$getData()[1,1]

 d[1:3,1:2] <- .3
 d[1:3,1:2]
}
\keyword{visualization}
\keyword{interactive graphics}
