\name{.GGobiCall}
\alias{.GGobiCall}
\alias{.GGobiC}
\alias{.ggobi.symbol}
\title{Wrappers for calling C routines in the R-ggobi library.}
\description{
 The \code{.ggobi.symbol} function is used entirely within R to 
map the given name to the name of the corresponding
C routine.
 The other two functions -- \code{.GGobiC} and \code{.GGobiCall} --
 convert the name and then call their C invocation counterparts.

 These functions map the simple name of a C routine into the
package-specific version of that name.  These allow use to hide the
use a name \textit{mangling} scheme of our choosing for the C level
routines in the shared library/DLL that provides the glue between R
and ggobi.  This is useful for avoiding name conflicts with other C
code in R or other packages.  These are only of relevance to the
developers of this package and those working with its C code.

}
\usage{
.GGobiCall(name, ..., .gobi=getDefaultGGobi())
.GGobiC(name, ..., .gobi=getDefaultGGobi())
.ggobi.symbol(name)
}
\arguments{
  \item{name}{the simple name of the C routine to be resolved}
  \item{\dots}{the arguments that to be passed to the \code{\link{.C}} or \code{\link{.Call}}}
  \item{.gobi}{the ggobi instance identifier that is to be passed to the C routine as its last
       argument. Specifying this here helps to ensure it is not omitted.}
}
\details{
 The mapping of the name to its corresponding C routine name
is done in conjunction with the pre-processor macro
\code{RS_GGOBI}. These  must be synchronized.
}
\value{
 \code{.ggobi.symbol} returns the name of the C routine
corresponding to its argument.

  The \code{.GGobiC} and \code{.GGobiCall} functions invoke the C
routine corresponding to the specified name and return the same result
as the corresponding \code{.C} and \code{.Call} do.

}

\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{.C}}
\code{\link{.Call}}
}


\examples{

}
\keyword{visualization}
\keyword{interactive graphics}
