\name{getMode.ggobi}
\alias{getMode.ggobi}
\alias{setMode.ggobi}
\title{Get or sets the operation mode for a ggobi instance.}
\description{
 A ggobi instance can be in one of several diffferent modes,
 each of which has different response to user inputs, different controls, etc.
 These methods allow one to determine the current mode and also programmatically
 set it.
}
\usage{
getMode.ggobi(.gobi=getDefaultGGobi())
setMode.ggobi(name, .gobi=getDefaultGGobi())
}
\arguments{
  \item{name}{the name of the mode, one of the values returned from
   \code{\link{getModeNames.ggobi}}, such as "Brush", "Identify", "Move Points".}
  \item{.gobi}{the ggobi instance identifer; either an integer index or \code{ggobi}
  reference.}
}
\details{
  This re-initializes the ggobi instance
 for this mode. No displays, plots, datasets,  etc. are 
 modified, just the state of the ggobi instance
 and th response to different user actions.
}
\value{
 The name of the current (in the case of \code{setMode.ggobi})
 or the previous setting of the operation mode.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{getModeNames.ggobi}}
}

\examples{
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 g$setBrushLocation(50, 50); 
 g$setBrushSize(100, 50); 
  # Now, go into brushing mode.
 g$setMode("Brush"); 

  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  old <- g$getMode()
  g$setMode("Brush")
  which <- g$getSelectedIndices()
  g$setMode(old)
}
\keyword{visualization}
\keyword{interactive graphics}

