\name{describe.ggobi}
\alias{describe.ggobi}
\title{Provide a description of one or more ggobi instances}
\description{
 This returns a description of each of the ggobi instances identified
in the arguments. These should be specified as objects of class
\code{ggobi}. The result describes the current state of the ggobi
instance, including its datasets and displays.
}
\usage{
describe.ggobi(..., full=F)
}
\arguments{
  \item{\dots}{any number of \code{ggobi} objects. If no values are specfied,
   all GGobi instances are used.}
  \item{full}{(currently ignored) a logical value indicating whether the full
  or brief description should be returned for each ggobi instance.}
}
\value{
 This returns a list with as many elements as there are ggobi instances
specfied. Each element is a list of length $3$ with elements:
  \item{datasets}{a named list describing each dataset within this ggobi instance.
     Each description consists of 
     \item{name} a character vector containing the name of the dataset and the (primary) file
        from which it was read.
     \item{dims}  the number of records and variables in the dataset.
     \item{format} the data format of the file from which the data was read (e.g. XML, ASCII, 
         binary, MySQL, etc.)
     \item{variables} a character vector giving the names of the variables
     \item{auxillaryFiles} any additional files that were read when processing the 
        primary file (e.g. links in the XML file, .col and .rows files in ASCII format, etc.)
  }
  \item{displays}{ a list describing each of the displays within}
  \item{ggobi}{the ggobi instance from which this description was obtained}
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{ggobi}}
 \code{\link{getGGobi}}
}

\examples{
 ggobi(args=c("-noinit", "-verbose", "-xml", system.file("data", "COI.xml", package="Rggobi")))
 describe.ggobi()
}
\keyword{visualization}
\keyword{interactive graphics}
